/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.enums.ContentMode;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;

public class CommonUtil {
    public static void initFontColorAndAlpha(PDPageContentStream stream, Color backgroundColor, FontStyle fontStyle, Color fontColor, Color strokColor, float fontAlpha) {
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        stream.setGraphicsStateParameters(state);
        if (fontStyle.isFill()) {
            stream.setNonStrokingColor(fontColor);
            state.setNonStrokingAlphaConstant(Float.valueOf(fontAlpha));
        }
        if (fontStyle.isStroke()) {
            stream.setStrokingColor(strokColor);
            state.setStrokingAlphaConstant(Float.valueOf(fontAlpha));
        }
        if (fontStyle.isLight()) {
            stream.setStrokingColor(backgroundColor);
            stream.setNonStrokingColor(fontColor);
            state.setNonStrokingAlphaConstant(Float.valueOf(fontAlpha));
        }
    }

    public static void initMatrix(PDPageContentStream stream, float beginX, float beginY, float relativeBeginX, float relativeBeginY, float width, float height, float angle, float alpha) {
        float offsetX = 0.5f * width;
        float offsetY = 0.5f * height;
        stream.saveGraphicsState();
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        state.setNonStrokingAlphaConstant(Float.valueOf(alpha));
        stream.setGraphicsStateParameters(state);
        stream.transform(Matrix.getTranslateInstance((float)(beginX + relativeBeginX + offsetX), (float)(beginY - relativeBeginY + offsetY)));
        stream.transform(Matrix.getRotateInstance((double)Math.toRadians(angle), (float)0.0f, (float)0.0f));
        stream.transform(Matrix.getTranslateInstance((float)(-offsetX), (float)(-offsetY)));
    }

    public static float initLineWidth(FontStyle style) {
        float lineWidth = 1.0f;
        if (style.isBold()) {
            lineWidth = 0.31415927f;
        } else if (style.isLight()) {
            lineWidth = 0.0f;
        } else if (style.isStroke()) {
            lineWidth = 0.5f;
        }
        return lineWidth;
    }

    public static List<BufferedImage> extractImage(PDPage page) {
        ArrayList<BufferedImage> data = new ArrayList<BufferedImage>(16);
        CommonUtil.extractImage(data, page.getResources());
        return data;
    }

    public static void extractImage(List<BufferedImage> list, PDResources resources) {
        Iterable objectNames = resources.getXObjectNames();
        for (COSName objectName : objectNames) {
            PDXObject xObject = resources.getXObject(objectName);
            if (xObject instanceof PDImage) {
                list.add(((PDImage)xObject).getImage());
                continue;
            }
            if (!(xObject instanceof PDFormXObject)) continue;
            CommonUtil.extractImage(list, ((PDFormXObject)xObject).getResources());
        }
    }

    public static void addBackgroundColor(Context context, ContentMode mode, boolean isResetContentStream, PDRectangle rectangle, Color backgroundColor) {
        if (Objects.nonNull(backgroundColor)) {
            PDPageContentStream stream = new PDPageContentStream(context.getTargetDocument(), context.getTargetPage(), mode.getMode(), true, isResetContentStream);
            stream.addRect(rectangle);
            stream.setNonStrokingColor(backgroundColor);
            stream.fill();
            stream.close();
        }
    }

    public static PDRectangle getRectangle(float beginX, float beginY, float width, float height) {
        return new PDRectangle(beginX, beginY, width, height);
    }

    public static PDRectangle getRectangle(float width, float height) {
        return new PDRectangle(width, height);
    }

    /*
     * Exception decompiling
     */
    public static byte[] toBytes(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int[] toIntArray(List<Integer> list) {
        return list.stream().mapToInt(Integer::intValue).toArray();
    }

    public static float[] toFloatArray(List<Float> list) {
        float[] array = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).floatValue();
        }
        return array;
    }

    public static double[] toDoubleArray(List<Double> list) {
        return list.stream().mapToDouble(Double::doubleValue).toArray();
    }

    public static Character[] toCharacterArray(String text) {
        Character[] array = new Character[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            array[i] = Character.valueOf(text.charAt(i));
        }
        return array;
    }

    public static List<Character> toCharacterList(char[] array) {
        ArrayList<Character> list = new ArrayList<Character>(array.length);
        for (char c : array) {
            list.add(Character.valueOf(c));
        }
        return list;
    }

    public static int[] createIntArray(int size) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static float[] getQuadPoints(PDRectangle rectangle) {
        return new float[]{rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getUpperRightX(), rectangle.getLowerLeftY(), rectangle.getLowerLeftX(), rectangle.getUpperRightY(), rectangle.getUpperRightX(), rectangle.getUpperRightY()};
    }

    public static float[] getQuadPoints2(PDRectangle rectangle) {
        return new float[]{rectangle.getLowerLeftX(), rectangle.getUpperRightY(), rectangle.getUpperRightX(), rectangle.getUpperRightY(), rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getUpperRightX(), rectangle.getLowerLeftY()};
    }
}

