/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;

class PDFObjectQueue {
    private final LinkedHashMap<COSBase, ObjectMetaData> object_queue = new LinkedHashMap();
    private final HashMap<PDFDummyObjects, ObjectMetaData> dummies = new HashMap();
    private int object_id = 0;

    PDFObjectQueue() {
    }

    void enqueueObject(COSBase object) {
        if (!this.object_queue.containsKey(object)) {
            object.setDirect(true);
            this.object_queue.put(object, new ObjectMetaData(this.object_id++));
            if (object instanceof COSObject) {
                ((COSObject)object).getObject().setDirect(false);
                object.setKey(new COSObjectKey((long)(this.object_id - 1), 0));
            }
        }
    }

    int size() {
        return this.object_queue.size();
    }

    Set<Map.Entry<COSBase, ObjectMetaData>> entrySet() {
        return this.object_queue.entrySet();
    }

    Set<COSBase> keySet() {
        return this.object_queue.keySet();
    }

    void setObjectID(int id) {
        this.object_id = id;
    }

    void resetObjectID() {
        this.object_id = 1;
    }

    void enqueuePart(List<COSBase> part) {
        for (COSBase iter : part) {
            this.enqueueObject(iter);
        }
    }

    void enqueueDummy(PDFDummyObjects key) {
        this.dummies.put(key, new ObjectMetaData(this.object_id++));
    }

    void replaceDummy(PDFDummyObjects key, COSBase object) {
        ObjectMetaData data = this.get(key);
        this.dummies.remove((Object)key);
        this.object_queue.put(object, data);
    }

    ObjectMetaData get(COSBase base) {
        return this.object_queue.get(base);
    }

    ObjectMetaData get(PDFDummyObjects dummy) {
        return this.dummies.get((Object)dummy);
    }

    int getNextID() {
        return this.object_id;
    }

    class ObjectMetaData {
        final int objNumber;
        long objLength = -1L;

        ObjectMetaData(int objNumber) {
            this.objNumber = objNumber;
        }
    }

    static enum PDFDummyObjects {
        LINDICT,
        FIRSTXREF,
        SECONDXREF,
        HINTSTREAM;

    }
}

