/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.PDFXRefStream;
import org.apache.pdfbox.pdfparser.xref.NormalXReference;
import org.apache.pdfbox.pdfparser.xref.ObjectStreamXReference;
import org.apache.pdfbox.pdfparser.xref.XReferenceEntry;
import org.apache.pdfbox.pdfwriter.COSStandardOutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.pdfbox.support.linearization.COSWriter;
import org.dromara.pdf.pdfbox.support.linearization.VirtualPart;

class LinearizedPDFWriter
extends COSWriter {
    static final Comparator<XReferenceEntry> XREFCOMP = (lhs, rhs) -> {
        long lhsInt = lhs.getReferencedKey().getNumber();
        long rhsInt = rhs.getReferencedKey().getNumber();
        return (int)(rhsInt - lhsInt);
    };
    private List<VirtualPart> writtenParts;
    private long lastLength = -1L;
    private int lastCount = 0;

    LinearizedPDFWriter(PDDocument doc) {
        super(new ByteArrayOutputStream());
        this.pdDocument = doc;
        if (doc.getEncryption() != null) {
            this.willEncrypt = true;
        }
        this.writtenParts = new ArrayList<VirtualPart>();
    }

    private XReferenceEntry getFakeEntry(int i) {
        return new NormalXReference(ThreadLocalRandom.current().nextInt(), new COSObjectKey((long)i, 0), null);
    }

    void doWriteXrefRangeDummy(COSDocument doc, int xRefRangesStart, long xRefLength, COSDictionary trailer, int xRefId, long xRefOffset) throws IOException {
        long startPos = this.getPos();
        PDFXRefStream pdfxRefStream = new PDFXRefStream(doc);
        int i = 0;
        while ((long)i < xRefLength + 1L) {
            pdfxRefStream.addEntry(this.getFakeEntry(i + xRefRangesStart));
            ++i;
        }
        pdfxRefStream.addTrailerInfo(trailer);
        pdfxRefStream.setSize((long)trailer.getInt(COSName.SIZE));
        COSStream stream2 = pdfxRefStream.getStream();
        this.getObjectKeys().put((COSBase)((Object)stream2), new COSObjectKey((long)xRefId, 0));
        this.doWriteObject((COSBase)((Object)stream2));
        long endPos = this.getPos();
        long length = endPos - startPos;
        long overflow = (long)Math.max(Math.ceil((double)length * 0.003), 11.0);
        this.doWriteSpaces(overflow);
        this.writeEndXrefStream(xRefOffset);
    }

    private void writeEndXrefStream(long xRefOffset) throws IOException {
        this.getStandardOutput().write(STARTXREF);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(String.valueOf(xRefOffset).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(EOF);
        this.getStandardOutput().writeEOL();
    }

    void doWriteXrefRange(COSDocument doc, long xRefLength, List<XReferenceEntry> entries, COSDictionary trailer, int xRefId, long xRefOffset, long startPos) throws IOException {
        entries.add((XReferenceEntry)new NormalXReference(startPos, new COSObjectKey((long)xRefId, 0), null));
        if (xRefLength != (long)entries.size()) {
            throw new ArithmeticException("xRefLength != entries.size()");
        }
        entries.sort(XREFCOMP);
        PDFXRefStream pdfxRefStream = new PDFXRefStream(doc);
        int i = 0;
        while ((long)i < xRefLength) {
            pdfxRefStream.addEntry(entries.get(i));
            ++i;
        }
        pdfxRefStream.addTrailerInfo(trailer);
        pdfxRefStream.setSize((long)trailer.getInt(COSName.SIZE));
        COSStream stream = pdfxRefStream.getStream();
        this.getObjectKeys().put((COSBase)((Object)stream), new COSObjectKey((long)xRefId, 0));
        this.doWriteObject((COSBase)((Object)stream));
        this.writeEndXrefStream(xRefOffset);
    }

    long getPos() {
        if (this.writtenParts.isEmpty()) {
            return this.getStandardOutput().getPos();
        }
        if (this.lastCount == 0) {
            this.lastLength = VirtualPart.calculateInflatedLength(this.writtenParts);
        } else {
            long length = 0L;
            for (int i = this.lastCount - 1; i < this.writtenParts.size(); ++i) {
                length += (long)this.writtenParts.get(i).getInflatedLength();
            }
            this.lastLength = length;
        }
        this.lastCount = this.writtenParts.size();
        return this.lastLength + this.getStandardOutput().getPos();
    }

    void removeWrittenObject(COSBase obj) {
        if (!this.writtenObjects.contains(obj)) {
            return;
        }
        this.writtenObjects.remove(obj);
        for (XReferenceEntry entry : this.getXRefEntries()) {
            if (entry instanceof NormalXReference) {
                if (((NormalXReference)entry).getObject() != obj) continue;
                this.getXRefEntries().remove(entry);
                break;
            }
            if (!(entry instanceof ObjectStreamXReference) || ((ObjectStreamXReference)entry).getObject() != obj) continue;
            this.getXRefEntries().remove(entry);
            break;
        }
    }

    long doWriteObjectInSequence(COSBase obj) throws IOException {
        long oldPos = this.getPos();
        this.doWriteObject(obj);
        if (this.getStandardOutput().getPos() > 131072L) {
            this.getOutput().flush();
            this.getStandardOutput().flush();
            this.writtenParts.add(new VirtualPart(((ByteArrayOutputStream)this.getOutput()).toByteArray()));
            this.resetOutputs();
        }
        return this.getPos() - oldPos;
    }

    public void writeHeader() throws IOException {
        this.doWriteHeader(this.pdDocument.getDocument());
    }

    public List<XReferenceEntry> retrieveXRefEntries() {
        return this.getXRefEntries();
    }

    public void close() throws IOException {
        this.getOutput().flush();
        if (this.getStandardOutput().getPos() > 0L) {
            this.writtenParts.add(new VirtualPart(((ByteArrayOutputStream)this.getOutput()).toByteArray()));
        }
    }

    List<VirtualPart> getAndResetParts() throws IOException {
        this.close();
        List<VirtualPart> retVal = this.writtenParts;
        this.resetOutputs();
        this.writtenParts = new ArrayList<VirtualPart>();
        return retVal;
    }

    private void resetOutputs() {
        this.setOutput(new ByteArrayOutputStream());
        this.setStandardOutput(new COSStandardOutputStream(this.getOutput()));
    }

    private void doWriteSpaces(long spacesCount) throws IOException {
        for (long i = 0L; i < spacesCount - 1L; ++i) {
            this.getStandardOutput().write(COMMENT);
        }
        this.getStandardOutput().writeLF();
    }

    void fillUntilPos(long pos) throws IOException {
        long currentPos = this.getPos();
        if (pos < currentPos) {
            throw new ArithmeticException("LinearizedPDFWriter failed to add paddig characters because the current position is already beyond the requested one. This is ususally due to a failed length estimation. Current pos: " + currentPos + " Requested pos: " + pos);
        }
        this.doWriteSpaces(pos - currentPos);
    }
}

