/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.pdfbox.support.linearization.BitWriter;
import org.dromara.pdf.pdfbox.support.linearization.IO;
import org.dromara.pdf.pdfbox.support.linearization.PDFObjectQueue;
import org.dromara.pdf.pdfbox.support.linearization.StructuredPDFInfo;

public class HSharedObject {
    int first_shared_obj = 0;
    long first_shared_offset = 0L;
    int nshared_first_page = 0;
    int nshared_total = 0;
    int nbits_nobjects = 0;
    int min_group_length = 0;
    int nbits_delta_group_length = 0;
    List<HSharedObjectEntry> entries = new ArrayList<HSharedObjectEntry>();

    private HSharedObject(int objects) {
        for (int i = 0; i < objects; ++i) {
            this.entries.add(new HSharedObjectEntry());
        }
    }

    static HSharedObject filledSharedObjectHints(StructuredPDFInfo info, PDFObjectQueue queue, long first_shared_offset) {
        int i;
        long min_length = Integer.MAX_VALUE;
        long max_length = Integer.MIN_VALUE;
        HSharedObject sharedObjectHints = new HSharedObject(info.sharedObjectData.nshared_total);
        for (i = 0; i < info.sharedObjectData.nshared_total; ++i) {
            long length = queue.get((COSBase)info.sharedObjectData.entries.get((int)i)).objLength;
            min_length = Math.min(min_length, length);
            max_length = Math.max(max_length, length);
            sharedObjectHints.entries.get((int)i).delta_group_length = (int)length;
        }
        sharedObjectHints.nshared_total = info.sharedObjectData.nshared_total;
        sharedObjectHints.nshared_first_page = info.sharedObjectData.nshared_first_page;
        if (sharedObjectHints.nshared_total > sharedObjectHints.nshared_first_page) {
            sharedObjectHints.first_shared_obj = queue.get((COSBase)info.sharedObjectData.first_shared_obj).objNumber;
            sharedObjectHints.first_shared_offset = first_shared_offset;
        }
        sharedObjectHints.min_group_length = (int)min_length;
        sharedObjectHints.nbits_delta_group_length = IO.nbits((int)max_length - (int)min_length);
        for (i = 0; i < info.sharedObjectData.nshared_total; ++i) {
            assert ((long)sharedObjectHints.entries.get((int)i).delta_group_length >= min_length);
            sharedObjectHints.entries.get((int)i).delta_group_length = (int)((long)sharedObjectHints.entries.get((int)i).delta_group_length - min_length);
        }
        return sharedObjectHints;
    }

    void writeHSharedObject(BitWriter w) throws IOException {
        w.writeBits(this.first_shared_obj, 32);
        w.writeBits(this.first_shared_offset, 32);
        w.writeBits(this.nshared_first_page, 32);
        w.writeBits(this.nshared_total, 32);
        w.writeBits(this.nbits_nobjects, 16);
        w.writeBits(this.min_group_length, 32);
        w.writeBits(this.nbits_delta_group_length, 16);
        int nitems = this.nshared_total;
        for (HSharedObjectEntry en : this.entries) {
            w.writeBits(en.delta_group_length, this.nbits_delta_group_length);
        }
        w.flush();
        for (HSharedObjectEntry en : this.entries) {
            w.writeBits(en.signature_present, 1);
        }
        w.flush();
        for (int i = 0; i < nitems; ++i) {
            if (this.entries.get((int)i).signature_present == 0) continue;
        }
        for (HSharedObjectEntry en : this.entries) {
            w.writeBits(en.nobjects_minus_one, this.nbits_nobjects);
        }
        w.flush();
    }

    class HSharedObjectEntry {
        int delta_group_length = 0;
        int signature_present = 0;
        int nobjects_minus_one = 0;

        private HSharedObjectEntry() {
        }
    }
}

