/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.io.IOException;
import java.io.OutputStream;

class BitWriter {
    private final char[] ch = new char[1];
    private final int[] bitOffset = new int[1];
    private final OutputStream str;
    private final int[] length = new int[1];

    BitWriter(OutputStream str) {
        this.str = str;
        this.ch[0] = '\u0000';
        this.length[0] = 0;
        this.bitOffset[0] = 7;
    }

    private static void write_bits(char[] ch, int[] bitOffset, long val, int bits, OutputStream str, int[] length) throws IOException {
        if (bits > 32) {
            throw new ArithmeticException("write_bits: too many bits requested");
        }
        while (bits > 0) {
            int bitsToWrite = Math.min(bits, bitOffset[0] + 1);
            char newval = (char)(val >> bits - bitsToWrite & (long)((1 << bitsToWrite) - 1));
            int bits_left_in_ch = bitOffset[0] + 1 - bitsToWrite;
            newval = (char)(newval << bits_left_in_ch);
            ch[0] = (char)(ch[0] | newval);
            if (bits_left_in_ch == 0) {
                str.write((byte)ch[0]);
                bitOffset[0] = 7;
                ch[0] = '\u0000';
                length[0] = length[0] + 1;
            } else {
                bitOffset[0] = bitOffset[0] - bitsToWrite;
            }
            bits -= bitsToWrite;
        }
    }

    void writeBits(long val, int bits) throws IOException {
        BitWriter.write_bits(this.ch, this.bitOffset, val, bits, this.str, this.length);
    }

    int getCount() {
        return this.length[0];
    }

    void writeBitsSigned(long val, int bits) throws IOException {
        long uval = val < 0L ? (long)(1 << bits) + val : val;
        this.writeBits(uval, bits);
    }

    void flush() throws IOException {
        if (this.bitOffset[0] < 7) {
            int bitsToWrite = this.bitOffset[0] + 1;
            BitWriter.write_bits(this.ch, this.bitOffset, 0L, bitsToWrite, this.str, this.length);
        }
    }
}

