/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import jj2000.disp.BlkImgDataSrcImageProducer;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.Decoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.util.ISRandomAccessIO;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.CBlkWTDataSrcDec;
import jj2000.j2k.wavelet.synthesis.InverseWT;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.dromara.pdf.pdfbox.core.enums.ImageType;

public class J2kImageHandler {
    public static BufferedImage parse(InputStream inputStream) {
        ISRandomAccessIO in = new ISRandomAccessIO(inputStream);
        FileFormatReader ff = new FileFormatReader((RandomAccessIO)in);
        ff.readFileFormat();
        if (ff.JP2FFUsed) {
            in.seek(ff.getFirstCodeStreamPos());
        }
        ParameterList dpl = new ParameterList();
        String[][] param = Decoder.getAllParameters();
        for (int i = param.length - 1; i >= 0; --i) {
            if (param[i][3] == null) continue;
            dpl.put((Object)param[i][0], (Object)param[i][3]);
        }
        ParameterList pl = new ParameterList(dpl);
        HeaderInfo hi = new HeaderInfo();
        HeaderDecoder hd = new HeaderDecoder((RandomAccessIO)in, pl, hi);
        DecoderSpecs decSpec = hd.getDecoderSpecs();
        BitstreamReaderAgent agent = BitstreamReaderAgent.createInstance((RandomAccessIO)in, (HeaderDecoder)hd, (ParameterList)pl, (DecoderSpecs)decSpec, (boolean)false, (HeaderInfo)hi);
        int nCompCod = hd.getNumComps();
        int[] depth = new int[nCompCod];
        for (int i = 0; i < nCompCod; ++i) {
            depth[i] = hd.getOriginalBitDepth(i);
        }
        InverseWT wt = InverseWT.createInstance((CBlkWTDataSrcDec)hd.createDequantizer((CBlkQuantDataSrcDec)hd.createROIDeScaler((CBlkQuantDataSrcDec)hd.createEntropyDecoder((CodedCBlkDataSrcDec)agent, pl), pl, decSpec), depth, decSpec), (DecoderSpecs)decSpec);
        wt.setImgResLevel(agent.getImgRes());
        ImgDataConverter converter = new ImgDataConverter((BlkImgDataSrc)wt, 0);
        InvCompTransf decodedImage = new InvCompTransf((BlkImgDataSrc)converter, decSpec, depth, pl);
        Image j2kimage = BlkImgDataSrcImageProducer.createImage((BlkImgDataSrc)decodedImage);
        BufferedImage image = new BufferedImage(j2kimage.getWidth(null), j2kimage.getHeight(null), 2);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(j2kimage, 0, 0, null);
        graphics.dispose();
        return image;
    }

    public static void transcode(InputStream inputStream, OutputStream outputStream, ImageType outputType) {
        Objects.requireNonNull(inputStream, "the input stream can not be null");
        Objects.requireNonNull(outputStream, "the output stream can not be null");
        Objects.requireNonNull(outputType, "the output type can not be null");
        ImageIOUtil.writeImage((BufferedImage)J2kImageHandler.parse(inputStream), (String)outputType.getType(), (OutputStream)outputStream);
    }
}

