/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.handler;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontInfo;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.FontType;
import org.dromara.pdf.pdfbox.support.CharacterWrapper;
import org.dromara.pdf.pdfbox.support.fonts.FontMapperImpl;

public class FontHandler {
    private static final Log log = LogFactory.getLog(FontHandler.class);
    private static final FontHandler INSTANCE = new FontHandler();
    private final Map<String, Map<CharacterWrapper, Float>> codeWithMap = new ConcurrentHashMap<String, Map<CharacterWrapper, Float>>(16);

    private FontHandler() {
        this.addFont(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/dromara/pdf/pdfbox/ttf/HarmonyOS_Sans_SC_Regular.ttf"), "HarmonyOS_Sans_SC", FontType.TTF);
    }

    public static FontHandler getInstance() {
        return INSTANCE;
    }

    public void initCodeMap(String fontName) {
        Map<String, org.dromara.pdf.pdfbox.support.fonts.FontInfo> fontInfoByName = FontMapperImpl.getInstance().getFontInfoByName();
        org.dromara.pdf.pdfbox.support.fonts.FontInfo fontInfo = fontInfoByName.get(fontName);
        if (Objects.isNull((Object)fontInfo)) {
            this.codeWithMap.putIfAbsent(fontName, new ConcurrentHashMap(2048, 1.0f));
        } else {
            this.codeWithMap.putIfAbsent(fontInfo.getPostScriptName(), new ConcurrentHashMap(2048, 1.0f));
        }
    }

    public Map<CharacterWrapper, Float> getCodeMap(String fontName) {
        Map<CharacterWrapper, Float> map = this.codeWithMap.get(fontName);
        if (Objects.isNull(map)) {
            this.initCodeMap(fontName);
            map = this.codeWithMap.get(fontName);
        }
        return map;
    }

    public List<String> getFontNames() {
        return new ArrayList<String>(FontMapperImpl.getInstance().getFontInfoByName().keySet());
    }

    public List<? extends org.dromara.pdf.pdfbox.support.fonts.FontInfo> getFontInfos() {
        return FontMapperImpl.getInstance().getProvider().getFontInfo();
    }

    public PDFont getPDFont(Document document, String fontName) {
        return this.getPDFont(document.getTarget(), fontName);
    }

    public PDFont getPDFont(PDDocument document, String fontName) {
        return this.getPDFont(document, fontName, true);
    }

    public PDFont getPDFont(Document document, String fontName, boolean embedSubset) {
        return this.getPDFont(document.getTarget(), fontName, embedSubset);
    }

    public PDFont getPDFont(PDDocument document, String fontName, boolean embedSubset) {
        org.dromara.pdf.pdfbox.support.fonts.FontInfo fontInfo = FontMapperImpl.getInstance().getFontInfoByName().get(fontName);
        if (Objects.nonNull((Object)fontInfo) && fontInfo.getFormat() == FontFormat.OTF) {
            embedSubset = false;
        }
        return PDType0Font.load((PDDocument)document, (TrueTypeFont)this.getTrueTypeFont(fontName), (boolean)embedSubset);
    }

    public TrueTypeFont getTrueTypeFont(String fontName) {
        org.dromara.pdf.pdfbox.support.fonts.FontInfo fontInfo = FontMapperImpl.getInstance().getFontInfoByName().get(fontName);
        return (TrueTypeFont)FontMapperImpl.getInstance().getTrueTypeFont(Optional.ofNullable(fontInfo).map(FontInfo::getPostScriptName).orElse(fontName), null).getFont();
    }

    public void addFont(File file, String alias) {
        if (Objects.nonNull(file)) {
            FontMapperImpl.getInstance().getProvider().addFont(file, alias);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added font ['" + alias + "']"));
            }
        }
    }

    public void addFont(File ... files) {
        if (Objects.nonNull(files)) {
            Arrays.stream(files).forEach(file -> FontMapperImpl.getInstance().getProvider().addFont((File)file));
        }
    }

    public void addFont(Collection<File> files) {
        if (Objects.nonNull(files)) {
            files.forEach(file -> FontMapperImpl.getInstance().getProvider().addFont((File)file));
        }
    }

    public void addFont(InputStream inputStream, String alias, FontType type) {
        FontMapperImpl.getInstance().getProvider().addFont(inputStream, alias, type);
    }

    public void addToSubset(PDDocument document, PDFont font, String text) {
        if (Objects.nonNull(font) && font.willBeSubset()) {
            int codePoint;
            int length = text.length();
            for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(offset);
                font.addToSubset(codePoint);
            }
            document.addFontToSubset(font);
        }
    }
}

