/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.templater;

import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.templater.AbstractHtmlTemplater;

public class VelocityTemplater
extends AbstractHtmlTemplater {
    protected static final Map<String, VelocityEngine> ENGINE_CACHE = new ConcurrentHashMap<String, VelocityEngine>(16);

    public VelocityTemplater(Document document) {
        super(document);
    }

    @Override
    public void setTemplatePath(String templatePath) {
        super.setTemplatePath(templatePath);
        if (Objects.isNull(Thread.currentThread().getContextClassLoader().getResource(templatePath))) {
            ENGINE_CACHE.computeIfAbsent(templatePath, this::initFileEngine);
        } else {
            ENGINE_CACHE.computeIfAbsent(templatePath, this::initClassPathEngine);
        }
    }

    protected VelocityEngine initFileEngine(String templatePath) {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loaders", (Object)"file");
        engine.setProperty("resource.loader.file.path", (Object)templatePath);
        engine.setProperty("resource.loader.file.class", (Object)FileResourceLoader.class.getName());
        engine.init();
        return engine;
    }

    protected VelocityEngine initClassPathEngine(String templatePath) {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loaders", (Object)"class");
        engine.setProperty("resource.loader.path", (Object)templatePath);
        engine.setProperty("resource.loader.class.class", (Object)ClasspathResourceLoader.class.getName());
        engine.init();
        return engine;
    }

    @Override
    protected void process(Writer writer) {
        String templatePath = String.join((CharSequence)"/", this.templatePath, this.templateName);
        if (Thread.currentThread().getContextClassLoader().getResource(templatePath) == null) {
            ENGINE_CACHE.get(this.templatePath).getTemplate(this.templateName).merge((Context)this.getEngineContext(), writer);
        } else {
            ENGINE_CACHE.get(this.templatePath).getTemplate(templatePath).merge((Context)this.getEngineContext(), writer);
        }
    }

    protected VelocityContext getEngineContext() {
        return new VelocityContext(this.templateData);
    }
}

