/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDRadioButton;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Size;
import org.dromara.pdf.pdfbox.core.enums.FormFieldStateStyle;
import org.dromara.pdf.pdfbox.core.ext.processor.form.AbstractFormFieldBuilder;
import org.dromara.pdf.pdfbox.core.ext.processor.form.RadioField;

public class RadioFieldBuilder
extends AbstractFormFieldBuilder {
    protected List<RadioField> fields;

    private RadioFieldBuilder(Document document, Page page, Size size) {
        super(document, page, size);
    }

    public static RadioFieldBuilder builder(Document document, Page page) {
        return new RadioFieldBuilder(document, page, Size.create(0.0f, 0.0f, 0.0f, 0.0f));
    }

    public void addFields(RadioField ... fields) {
        Objects.requireNonNull(fields, "the fields can not be null");
        if (Objects.isNull(this.fields)) {
            this.fields = new ArrayList<RadioField>(10);
        }
        Collections.addAll(this.fields, fields);
    }

    @Override
    public PDField build(PDAcroForm form) {
        PDRadioButton field = new PDRadioButton(form);
        this.initProperties((PDField)field);
        this.initWidget(field);
        return field;
    }

    protected void initWidget(PDRadioButton field) {
        Objects.requireNonNull(this.fields, "the fields can not be null");
        COSArray options = new COSArray();
        ArrayList<PDAnnotationWidget> widgets = new ArrayList<PDAnnotationWidget>(this.fields.size());
        int index = 0;
        Integer selectIndex = null;
        for (RadioField radioField : this.fields) {
            PDAnnotationWidget widget = new PDAnnotationWidget(new COSDictionary());
            widget.setAppearanceState(COSName.Off.getName());
            widgets.add(widget);
            options.add((COSBase)new COSString(radioField.getValue()));
            this.initAppearance(widget, radioField.getStyle());
            this.initSize(widget, radioField.getSize());
            this.initBorder(widget);
            if (radioField.getIsSelected().booleanValue()) {
                selectIndex = index;
            }
            ++index;
        }
        if (Objects.nonNull(selectIndex)) {
            ((PDAnnotationWidget)widgets.get(selectIndex)).setAppearanceState(String.valueOf(selectIndex));
        }
        field.setWidgets(widgets);
        field.getCOSObject().setItem(COSName.OPT, (COSBase)options);
    }

    protected void initAppearance(PDAnnotationWidget widget, FormFieldStateStyle style) {
        PDAppearanceCharacteristicsDictionary appearance = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
        COSDictionary dictionary = appearance.getCOSObject();
        dictionary.setItem(COSName.CA, (COSBase)style.getType());
        widget.setAppearanceCharacteristics(appearance);
    }

    protected void initSize(PDAnnotationWidget widget, Size size) {
        widget.setRectangle(size.getRectangle());
        widget.setPage(this.page.getTarget());
        widget.setPrinted(true);
        this.page.getTarget().getAnnotations().add(widget);
    }

    protected void initBorder(PDAnnotationWidget widget) {
        PDBorderStyleDictionary borderStyle = new PDBorderStyleDictionary(new COSDictionary());
        borderStyle.setWidth(1.0f);
        borderStyle.setStyle("I");
        widget.setBorderStyle(borderStyle);
    }

    @Generated
    public void setFields(List<RadioField> fields) {
        this.fields = fields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RadioFieldBuilder)) {
            return false;
        }
        RadioFieldBuilder other = (RadioFieldBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<RadioField> this$fields = this.fields;
        List<RadioField> other$fields = other.fields;
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RadioFieldBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<RadioField> $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }
}

