/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.form;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Size;
import org.dromara.pdf.pdfbox.core.enums.ImageFieldLayout;
import org.dromara.pdf.pdfbox.core.ext.processor.form.AbstractFormFieldBuilder;

public class ImageFieldBuilder
extends AbstractFormFieldBuilder {
    protected static final COSName LAYOUT_KEY = COSName.getPDFName((String)"TP");
    protected String label;
    protected ImageFieldLayout layout;

    private ImageFieldBuilder(Document document, Page page, Size size) {
        super(document, page, size);
    }

    public static ImageFieldBuilder builder(Document document, Page page, Size size) {
        return new ImageFieldBuilder(document, page, size);
    }

    @Override
    public PDField build(PDAcroForm form) {
        PDPushButton field = new PDPushButton(form);
        this.initProperties((PDField)field);
        this.initSize((PDField)field);
        this.initAppearance((PDField)field);
        return field;
    }

    @Override
    protected void initProperties(PDField field) {
        super.initProperties(field);
        if (Objects.isNull((Object)this.layout)) {
            this.layout = ImageFieldLayout.IMAGE_ONLY;
        }
    }

    protected void initAppearance(PDField field) {
        PDAppearanceCharacteristicsDictionary appearance = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
        COSDictionary dictionary = appearance.getCOSObject();
        dictionary.setItem(LAYOUT_KEY, (COSBase)COSInteger.get((long)this.layout.getType()));
        dictionary.setItem(COSName.CA, (COSBase)new COSString(Optional.ofNullable(this.label).orElse("")));
        ((PDAnnotationWidget)field.getWidgets().get(0)).setAppearanceCharacteristics(appearance);
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setLayout(ImageFieldLayout layout) {
        this.layout = layout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageFieldBuilder)) {
            return false;
        }
        ImageFieldBuilder other = (ImageFieldBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$label = this.label;
        String other$label = other.label;
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        ImageFieldLayout this$layout = this.layout;
        ImageFieldLayout other$layout = other.layout;
        return !(this$layout == null ? other$layout != null : !((Object)((Object)this$layout)).equals((Object)other$layout));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImageFieldBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $label = this.label;
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        ImageFieldLayout $layout = this.layout;
        result = result * 59 + ($layout == null ? 43 : ((Object)((Object)$layout)).hashCode());
        return result;
    }
}

