/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.core.info.EmbeddedFileInfo;

public class AttachmentProcessor
extends AbstractProcessor {
    protected Map<String, EmbeddedFileInfo> fileMap = new HashMap<String, EmbeddedFileInfo>(16);

    public AttachmentProcessor(Document document) {
        super(document);
        this.initFiles();
    }

    public boolean isContainFile() {
        return !this.fileMap.isEmpty();
    }

    public int getFileCount() {
        return this.fileMap.size();
    }

    public void addOrSet(EmbeddedFileInfo ... files) {
        Objects.requireNonNull(files, "the file can not be null");
        for (EmbeddedFileInfo file : files) {
            this.fileMap.put(file.getName(), file);
        }
    }

    public void remove(String ... names) {
        if (Objects.isNull(names)) {
            this.fileMap = new HashMap<String, EmbeddedFileInfo>(0);
        } else {
            for (String name : names) {
                try {
                    this.fileMap.remove(name);
                }
                catch (Exception e) {
                    this.log.warn((Object)("the name['" + name + "'] is invalid, will be ignored"));
                }
            }
        }
    }

    public PDEmbeddedFile buildEmbeddedFile(byte[] data, String mimeType) {
        Objects.requireNonNull(data, "the data can not be null");
        PDEmbeddedFile file = new PDEmbeddedFile(this.getDocument(), (InputStream)new ByteArrayInputStream(data));
        file.setSubtype(mimeType);
        file.setSize(data.length);
        file.setCreationDate(Calendar.getInstance());
        return file;
    }

    public void flush() {
        this.getDocument().getDocumentCatalog().setNames(this.fileMap.isEmpty() ? null : this.createNameDictionary());
    }

    protected void initFiles() {
        PDEmbeddedFilesNameTreeNode tree;
        PDDocumentNameDictionary dictionary = this.getDocument().getDocumentCatalog().getNames();
        if (Objects.nonNull(dictionary) && Objects.nonNull(tree = dictionary.getEmbeddedFiles())) {
            this.extractFiles((PDNameTreeNode<PDComplexFileSpecification>)tree);
        }
    }

    protected void extractFiles(PDNameTreeNode<PDComplexFileSpecification> tree) {
        Map names = tree.getNames();
        if (Objects.nonNull(names)) {
            Set entrySet = names.entrySet();
            for (Map.Entry entry : entrySet) {
                PDComplexFileSpecification specification = (PDComplexFileSpecification)((Object)entry.getValue());
                if (!Objects.nonNull((Object)specification)) continue;
                this.fileMap.put(specification.getFilename(), new EmbeddedFileInfo(specification.getFilename(), specification.getFileDescription(), specification.getEmbeddedFile()));
            }
        } else {
            List kids = tree.getKids();
            if (Objects.isNull(kids)) {
                return;
            }
            for (PDNameTreeNode node : kids) {
                this.extractFiles((PDNameTreeNode<PDComplexFileSpecification>)node);
            }
        }
    }

    protected PDDocumentNameDictionary createNameDictionary() {
        PDDocumentNameDictionary names = new PDDocumentNameDictionary(this.getDocument().getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode tree = new PDEmbeddedFilesNameTreeNode();
        HashMap<String, PDComplexFileSpecification> map = new HashMap<String, PDComplexFileSpecification>(this.fileMap.size());
        Collection<EmbeddedFileInfo> infos = this.fileMap.values();
        for (EmbeddedFileInfo info : infos) {
            map.put(info.getName(), this.createSpecification(info));
        }
        tree.setNames(map);
        names.setEmbeddedFiles(tree);
        return names;
    }

    protected PDComplexFileSpecification createSpecification(EmbeddedFileInfo info) {
        PDComplexFileSpecification specification = new PDComplexFileSpecification();
        specification.setFile(info.getName());
        specification.setFileUnicode(info.getName());
        specification.setFileDescription(info.getDescription());
        specification.setEmbeddedFile(info.getEmbeddedFile());
        specification.setEmbeddedFileUnicode(info.getEmbeddedFile());
        return specification;
    }

    @Generated
    public Map<String, EmbeddedFileInfo> getFileMap() {
        return this.fileMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttachmentProcessor)) {
            return false;
        }
        AttachmentProcessor other = (AttachmentProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, EmbeddedFileInfo> this$fileMap = this.getFileMap();
        Map<String, EmbeddedFileInfo> other$fileMap = other.getFileMap();
        return !(this$fileMap == null ? other$fileMap != null : !((Object)this$fileMap).equals(other$fileMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttachmentProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, EmbeddedFileInfo> $fileMap = this.getFileMap();
        result = result * 59 + ($fileMap == null ? 43 : ((Object)$fileMap).hashCode());
        return result;
    }
}

