/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.parser.ai;

import com.alibaba.fastjson2.JSONObject;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import org.apache.pdfbox.text.PDFTextStripper;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.analyzer.DocumentAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.parser.AbstractParser;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AIParseInfo;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AIParserConfig;
import org.dromara.pdf.pdfbox.core.ext.processor.RenderProcessor;
import org.dromara.pdf.pdfbox.core.info.ImageInfo;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.util.HttpUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public abstract class AbstractAIParser
extends AbstractParser {
    private static final String CONTENT_JSON_PATH = "$.choices[0].message.content";
    private static final String TOKEN_JSON_PATH = "$.usage.total_tokens";
    protected String taskIdKey = "id";
    protected AIParserConfig config;

    public AbstractAIParser(Document document, String apiKey, boolean isJsonResponse) {
        super(document);
        this.config = new AIParserConfig(apiKey, "\u4f60\u662f\u4e00\u4e2a\u56fe\u50cf\u5206\u6790\u4e0e\u6570\u636e\u63d0\u53d6\u4e13\u5bb6\uff0c\u80fd\u591f\u6839\u636e\u6240\u7ed9\u7684\u4fe1\u606f\u51c6\u786e\u5730\u56de\u7b54\u7528\u6237\u63d0\u51fa\u7684\u95ee\u9898", "\u4f60\u662f\u4e00\u4e2a\u6570\u636e\u5206\u6790\u4e0e\u63d0\u53d6\u4e13\u5bb6\uff0c\u80fd\u591f\u6839\u636e\u6240\u7ed9\u7684\u4fe1\u606f\u51c6\u786e\u5730\u56de\u7b54\u7528\u6237\u63d0\u51fa\u7684\u95ee\u9898", isJsonResponse, HttpUtil.CLIENT);
    }

    public void setHttpClient(OkHttpClient client) {
        Objects.requireNonNull(client, "the http client can not be null");
        this.config.setClient(client);
    }

    public void setImageModel(String model) {
        Objects.requireNonNull(model, "the model can not be null");
        this.config.setImageModel(model);
    }

    public void setImageSystemPrompt(String prompt) {
        this.config.setImageSystemPrompt(prompt);
    }

    public void setTextModel(String model) {
        Objects.requireNonNull(model, "the model can not be null");
        this.config.setTextModel(model);
    }

    public void setTextSystemPrompt(String prompt) {
        this.config.setTextSystemPrompt(prompt);
    }

    public void setIsJsonResponse(boolean flag) {
        this.config.setJsonResponse(flag);
    }

    public AIParseInfo parsePageWithImage(String prompt, int pageIndex) {
        return this.parseImageInfo(this.createImageMessages(prompt, this.getPageImage(pageIndex)));
    }

    public AIParseInfo parseImageWithPage(String prompt, int pageIndex, int imageIndex) {
        return this.parseImageInfo(this.createImageMessages(prompt, this.getPageImage(pageIndex, imageIndex)));
    }

    public AIParseInfo parseTextWithDocument(String prompt) {
        return this.parseTextWithPage(prompt, -1, -1);
    }

    public AIParseInfo parseTextWithPage(String prompt, int beginPageIndex, int endPageIndex) {
        return this.parseTexInfo(this.createTextMessages(prompt, this.getPageText(beginPageIndex, endPageIndex)));
    }

    protected AIParseInfo parseImageInfo(List<Message> messages) {
        return this.parseInfo(this.config.getImageUrl(), this.config.getImageModel(), messages);
    }

    protected AIParseInfo parseTexInfo(List<Message> messages) {
        return this.parseInfo(this.config.getTextUrl(), this.config.getTextModel(), messages);
    }

    protected AIParseInfo parseInfo(String url, String model, List<Message> messages) {
        return this.getParseInfo(this.getResponse(url, model, messages));
    }

    protected List<Message> createImageMessages(String prompt, BufferedImage image) {
        ArrayList<Message> messages = new ArrayList<Message>(2);
        if (Objects.nonNull(this.config.getImageSystemPrompt())) {
            messages.add(new Message("system", this.config.getImageSystemPrompt()));
        }
        messages.add(new Message("user", this.createImageMessageContents(prompt, image)));
        return messages;
    }

    protected List<Object> createImageMessageContents(String prompt, BufferedImage image) {
        ArrayList<Object> contents = new ArrayList<Object>(2);
        contents.add(new ImageContent(ImageUtil.toBase64(image, ImageType.PNG.getType())));
        contents.add(new TextContent(prompt));
        return contents;
    }

    protected List<Message> createTextMessages(String prompt, String text) {
        ArrayList<Message> messages = new ArrayList<Message>(3);
        if (Objects.nonNull(this.config.getTextSystemPrompt())) {
            messages.add(new Message("system", this.config.getTextSystemPrompt()));
        }
        messages.add(new Message("user", text));
        messages.add(new Message("user", prompt));
        return messages;
    }

    protected String getAuthorization() {
        return "Bearer " + this.config.getApiKey();
    }

    protected Headers getRequestHeaders() {
        return new Headers.Builder().add("Authorization", this.getAuthorization()).build();
    }

    protected JSONObject getRequestBody(String model, List<Message> messages) {
        JSONObject jsonBody = JSONObject.of((String)"model", (Object)model).fluentPut("messages", messages);
        if (this.config.isJsonResponse()) {
            jsonBody.fluentPut("response_format ", (Object)JSONObject.of((String)"type", (Object)"json_object"));
        }
        return jsonBody;
    }

    protected JSONObject getResponse(String url, String model, List<Message> messages) {
        JSONObject response = HttpUtil.request(this.config.getClient(), url, this.getRequestHeaders(), this.getRequestBody(model, messages).toString());
        if (response.containsKey("error")) {
            throw new RuntimeException(response.toString());
        }
        return response;
    }

    protected AIParseInfo getParseInfo(JSONObject response) {
        return new AIParseInfo(response.getString(this.taskIdKey), String.valueOf(response.getByPath(CONTENT_JSON_PATH)), String.valueOf(response.getByPath(TOKEN_JSON_PATH)));
    }

    protected BufferedImage getPageImage(int pageIndex) {
        RenderProcessor processor = PdfHandler.getDocumentProcessor(this.document).getRenderProcessor();
        processor.setDpi(300.0f);
        return processor.image(ImageType.PNG, pageIndex);
    }

    protected BufferedImage getPageImage(int pageIndex, int imageIndex) {
        DocumentAnalyzer analyzer = PdfHandler.getDocumentAnalyzer(this.document);
        List list = analyzer.analyzeImage(pageIndex).stream().sorted(Comparator.comparing(ImageInfo::getImageIndex)).collect(Collectors.toList());
        try {
            return ((ImageInfo)list.get(imageIndex)).getImage();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the image index['" + imageIndex + "'] is error");
        }
    }

    protected String getPageText(int beginPageIndex, int endPageIndex) {
        PDFTextStripper stripper = new PDFTextStripper();
        if (beginPageIndex > -1) {
            stripper.setStartPage(beginPageIndex + 1);
        }
        if (endPageIndex > -1) {
            stripper.setEndPage(endPageIndex + 1);
        }
        return "\u9605\u8bfb\u4e0b\u9762\u6587\u7ae0\uff0c\u5e76\u6839\u636e\u6587\u7ae0\u5185\u5bb9\u56de\u7b54\u95ee\u9898\uff0c\u4e0d\u8981\u590d\u8ff0\u95ee\u9898\uff0c\u76f4\u63a5\u5f00\u59cb\u56de\u7b54\n\n" + stripper.getText(this.getDocument());
    }

    protected static class ImageUrl {
        protected String url;

        public ImageUrl(String url) {
            this.url = "data:image/png;base64," + url;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }
    }

    protected static class ImageContent {
        protected String type = "image_url";
        protected ImageUrl image_url;

        public ImageContent(String url) {
            this.image_url = new ImageUrl(url);
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setImage_url(ImageUrl image_url) {
            this.image_url = image_url;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public ImageUrl getImage_url() {
            return this.image_url;
        }
    }

    protected static class TextContent {
        protected String type = "text";
        protected String text;

        public TextContent(String text) {
            this.text = text;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getText() {
            return this.text;
        }
    }

    protected static class Message {
        protected String role;
        protected Object content;

        @Generated
        public void setRole(String role) {
            this.role = role;
        }

        @Generated
        public void setContent(Object content) {
            this.content = content;
        }

        @Generated
        public String getRole() {
            return this.role;
        }

        @Generated
        public Object getContent() {
            return this.content;
        }

        @Generated
        public Message(String role, Object content) {
            this.role = role;
            this.content = content;
        }
    }
}

