/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.handler.tokenizer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.TextLineInfo;
import org.dromara.pdf.pdfbox.core.ext.handler.tokenizer.AbstractTokenizer;
import org.dromara.pdf.pdfbox.util.TextUtil;

public class StandardTokenizer
extends AbstractTokenizer {
    @Override
    public TextLineInfo splitText(FontConfiguration fontConfiguration, String text, float lineWidth) {
        if (Objects.isNull(text) || text.isEmpty() || this.getTextWidth(fontConfiguration, String.valueOf(text.charAt(0))) > lineWidth) {
            return null;
        }
        StringBuilder tempText = new StringBuilder();
        float lastWidth = 0.0f;
        float width = 0.0f;
        int length = text.length();
        ArrayList<Character> words = new ArrayList<Character>();
        for (int i = 0; i < length; ++i) {
            Character c = Character.valueOf(text.charAt(i));
            if (TextUtil.isEnglishCharacter(c)) {
                words.add(c);
                continue;
            }
            if (!words.isEmpty()) {
                words.forEach(tempText::append);
                width = this.getTextWidth(fontConfiguration, tempText.toString());
                if (width > lineWidth) {
                    String temp = tempText.substring(0, tempText.length() - words.size());
                    if (temp.isEmpty()) {
                        return null;
                    }
                    return new TextLineInfo(temp, Float.valueOf(lastWidth));
                }
                lastWidth = width;
                words = new ArrayList();
            }
            tempText.append(c);
            width = this.getTextWidth(fontConfiguration, tempText.toString());
            if (width > lineWidth) {
                return new TextLineInfo(tempText.substring(0, tempText.length() - 1), Float.valueOf(lastWidth));
            }
            lastWidth = width;
        }
        return new TextLineInfo(text, Float.valueOf(width));
    }

    @Override
    public List<TextLineInfo> splitLines(FontConfiguration fontConfiguration, String text, float lineWidth) {
        if (Objects.isNull(text) || text.isEmpty() || this.getTextWidth(fontConfiguration, String.valueOf(text.charAt(0))) > lineWidth) {
            return new ArrayList<TextLineInfo>(0);
        }
        LinkedList<TextLineInfo> lineList = new LinkedList<TextLineInfo>();
        StringBuilder tempText = new StringBuilder();
        float lastWidth = 0.0f;
        float width = 0.0f;
        int length = text.length();
        ArrayList<Character> words = new ArrayList<Character>();
        for (int i = 0; i < length; ++i) {
            Character c = Character.valueOf(text.charAt(i));
            if (TextUtil.isEnglishCharacter(c)) {
                words.add(c);
                continue;
            }
            if (!words.isEmpty()) {
                words.forEach(tempText::append);
                width = this.getTextWidth(fontConfiguration, tempText.toString());
                if (width > lineWidth) {
                    lineList.add(new TextLineInfo(tempText.substring(0, tempText.length() - words.size()), Float.valueOf(lastWidth)));
                    tempText = new StringBuilder();
                    words.forEach(tempText::append);
                } else {
                    lastWidth = width;
                }
                words = new ArrayList();
            }
            tempText.append(c);
            width = this.getTextWidth(fontConfiguration, tempText.toString());
            if (width > lineWidth) {
                lineList.add(new TextLineInfo(tempText.substring(0, tempText.length() - 1), Float.valueOf(lastWidth)));
                tempText = new StringBuilder();
                tempText.append(c);
                continue;
            }
            lastWidth = width;
        }
        if (!words.isEmpty()) {
            words.forEach(tempText::append);
        }
        if (tempText.length() > 0) {
            String temp = tempText.toString();
            lineList.add(new TextLineInfo(temp, Float.valueOf(this.getTextWidth(fontConfiguration, temp))));
        }
        return lineList;
    }
}

