/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.handler.tokenizer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.TextLineInfo;
import org.dromara.pdf.pdfbox.core.ext.handler.tokenizer.AbstractTokenizer;

public class CharacterTokenizer
extends AbstractTokenizer {
    @Override
    public TextLineInfo splitText(FontConfiguration fontConfiguration, String text, float lineWidth) {
        if (Objects.isNull(text) || text.isEmpty() || this.getTextWidth(fontConfiguration, String.valueOf(text.charAt(0))) > lineWidth) {
            return null;
        }
        float lastWidth = 0.0f;
        float width = 0.0f;
        int fontCount = Math.max(1, (int)(lineWidth / (fontConfiguration.getFontSize().floatValue() + fontConfiguration.getCharacterSpacing().floatValue())));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            width = this.getTextWidth(fontConfiguration, tempText);
            if (width > lineWidth) {
                return new TextLineInfo(text.substring(beginIndex, i - 1), Float.valueOf(lastWidth));
            }
            lastWidth = width;
        }
        if (width == 0.0f) {
            width = this.getTextWidth(fontConfiguration, text);
        }
        return new TextLineInfo(text, Float.valueOf(width));
    }

    @Override
    public List<TextLineInfo> splitLines(FontConfiguration fontConfiguration, String text, float lineWidth) {
        String tempText;
        if (Objects.isNull(text) || text.isEmpty() || this.getTextWidth(fontConfiguration, String.valueOf(text.charAt(0))) > lineWidth) {
            return new ArrayList<TextLineInfo>(0);
        }
        LinkedList<TextLineInfo> lineList = new LinkedList<TextLineInfo>();
        float lastWidth = 0.0f;
        float width = 0.0f;
        int fontCount = Math.max(1, (int)(lineWidth / (fontConfiguration.getFontSize().floatValue() + fontConfiguration.getCharacterSpacing().floatValue())));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            tempText = text.substring(beginIndex, i);
            width = this.getTextWidth(fontConfiguration, tempText);
            if (width > lineWidth) {
                lineList.add(new TextLineInfo(text.substring(beginIndex, i - 1), Float.valueOf(lastWidth)));
                beginIndex = i - 1;
                i = i + fontCount - 1;
                if (i < len) continue;
                lineList.add(new TextLineInfo(text.substring(beginIndex), Float.valueOf(width)));
                continue;
            }
            lastWidth = width;
        }
        if (beginIndex + fontCount < text.length() || lineList.isEmpty()) {
            tempText = text.substring(beginIndex);
            if (width == 0.0f) {
                width = this.getTextWidth(fontConfiguration, tempText);
            }
            lineList.add(new TextLineInfo(tempText, Float.valueOf(width)));
        }
        return lineList;
    }
}

