/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.convertor.office.word;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.convertor.office.AbstractOfficeConvertor;
import org.dromara.pdf.pdfbox.core.ext.convertor.office.word.WordType;
import org.dromara.pdf.pdfbox.util.FileUtil;

public abstract class AbstractWordConvertor
extends AbstractOfficeConvertor {
    public AbstractWordConvertor(Document document) {
        super(document);
    }

    public abstract Document toPdf(WordType var1, InputStream var2);

    public abstract boolean toWord(WordType var1, OutputStream var2);

    public Document toPdf(WordType type, String source) {
        Objects.requireNonNull(type, "the type can not be null");
        return super.toPdf(type.getType(), source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document toPdf(WordType type, File source) {
        Objects.requireNonNull(source, "the source can not be null");
        try (InputStream inputStream = Files.newInputStream(source.toPath(), new OpenOption[0]);){
            Document document = this.toPdf(type, inputStream);
            return document;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean toWord(WordType type, String output) {
        Objects.requireNonNull(output, "the output can not be null");
        try (OutputStream outputStream = Files.newOutputStream(FileUtil.createDirectories(Paths.get(output, new String[0])), new OpenOption[0]);){
            boolean bl = this.toWord(type, outputStream);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean toWord(WordType type, File output) {
        Objects.requireNonNull(output, "the output can not be null");
        try (OutputStream outputStream = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            boolean bl = this.toWord(type, outputStream);
            return bl;
        }
    }
}

