/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.convertor.office.rtf;

import com.documents4j.api.DocumentType;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.convertor.office.AbstractOfficeConvertor;
import org.dromara.pdf.pdfbox.util.FileUtil;

public abstract class AbstractRichTextConvertor
extends AbstractOfficeConvertor {
    public AbstractRichTextConvertor(Document document) {
        super(document);
    }

    public abstract Document toPdf(InputStream var1);

    public abstract boolean toRtf(OutputStream var1);

    public Document toPdf(String source) {
        return super.toPdf(DocumentType.RTF, source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document toPdf(File source) {
        Objects.requireNonNull(source, "the source can not be null");
        try (InputStream inputStream = Files.newInputStream(source.toPath(), new OpenOption[0]);){
            Document document = this.toPdf(inputStream);
            return document;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean toRtf(String output) {
        Objects.requireNonNull(output, "the output can not be null");
        try (OutputStream outputStream = Files.newOutputStream(FileUtil.createDirectories(Paths.get(output, new String[0])), new OpenOption[0]);){
            boolean bl = this.toRtf(outputStream);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean toRtf(File output) {
        Objects.requireNonNull(output, "the output can not be null");
        try (OutputStream outputStream = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            boolean bl = this.toRtf(outputStream);
            return bl;
        }
    }
}

