/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.convertor.office.ppt;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.convertor.office.AbstractOfficeConvertor;
import org.dromara.pdf.pdfbox.core.ext.convertor.office.ppt.PowerpointType;

public abstract class AbstractPowerpointConvertor
extends AbstractOfficeConvertor {
    public AbstractPowerpointConvertor(Document document) {
        super(document);
    }

    public abstract Document toPdf(PowerpointType var1, InputStream var2);

    public Document toPdf(PowerpointType type, String source) {
        Objects.requireNonNull(type, "the type can not be null");
        return super.toPdf(type.getType(), source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document toPdf(PowerpointType type, File source) {
        Objects.requireNonNull(source, "the source can not be null");
        try (InputStream inputStream = Files.newInputStream(source.toPath(), new OpenOption[0]);){
            Document document = this.toPdf(type, inputStream);
            return document;
        }
    }
}

