/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.convertor.office;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConverter;
import com.documents4j.job.LocalConverter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.convertor.AbstractConvertor;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.support.Constants;

public abstract class AbstractOfficeConvertor
extends AbstractConvertor {
    protected static final IConverter CONVERTER = AbstractOfficeConvertor.init();

    public AbstractOfficeConvertor(Document document) {
        super(document);
    }

    protected static IConverter init() {
        LocalConverter.Builder builder = ((LocalConverter.Builder)LocalConverter.builder().baseFolder(new File(Constants.TEMP_FILE_PATH))).processTimeout(600L, TimeUnit.SECONDS);
        try {
            builder.enable(Class.forName("com.documents4j.conversion.msoffice.MicrosoftPowerpointBridge"));
        }
        catch (ClassNotFoundException e) {
            LogFactory.getLog(AbstractOfficeConvertor.class).warn((Object)"The MicrosoftPowerpointBridge class not found, will skip the ppt initialization");
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document toPdf(DocumentType type, String source) {
        Document document;
        Objects.requireNonNull(source, "the source can not be null");
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(source);
            if (Objects.isNull(inputStream)) {
                inputStream = Files.newInputStream(Paths.get(source, new String[0]), new OpenOption[0]);
            }
            document = this.toPdf(type, inputStream);
        }
        catch (Throwable throwable) {
            if (Objects.nonNull(inputStream)) {
                inputStream.close();
            }
            throw throwable;
        }
        if (Objects.nonNull(inputStream)) {
            inputStream.close();
        }
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document toPdf(DocumentType type, InputStream source) {
        Objects.requireNonNull(type, "the type can not be null");
        Objects.requireNonNull(source, "the source can not be null");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            boolean executed = CONVERTER.convert(source).as(type).to((OutputStream)outputStream).as(DocumentType.PDF).execute();
            if (executed) {
                Document document = PdfHandler.getDocumentHandler().load(outputStream.toByteArray());
                return document;
            }
            throw new RuntimeException("convert fail");
        }
    }

    protected boolean toFile(DocumentType type, OutputStream output) {
        Objects.requireNonNull(type, "the type can not be null");
        Objects.requireNonNull(output, "the output can not be null");
        File tempFile = this.document.getTempFile();
        boolean executed = CONVERTER.convert(tempFile).as(DocumentType.PDF).to(output).as(type).execute();
        if (Objects.nonNull(tempFile) && !tempFile.delete()) {
            this.log.warn((Object)("Delete temp file['" + tempFile.getName() + "'] fail: " + tempFile.getAbsolutePath()));
        }
        return executed;
    }
}

