/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.convertor.html;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.options.Margin;
import com.microsoft.playwright.options.ScreenshotType;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.component.Image;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.core.ext.convertor.AbstractConvertor;
import org.dromara.pdf.pdfbox.core.ext.convertor.html.PageLoadState;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.util.ImageUtil;
import org.dromara.pdf.pdfbox.util.UnitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlConvertor
extends AbstractConvertor {
    protected static final ThreadLocal<Page> THREAD_LOCAL = new ThreadLocal();
    protected static final ThreadPoolExecutor POOL = DefaultThreadPool.createPool();
    protected static final String UNIT = "px";
    protected Integer dpi;
    protected PageSize pageSize;
    protected Long requestTimeout;
    protected PageLoadState pageState;
    protected Float marginTop;
    protected Float marginBottom;
    protected Float marginLeft;
    protected Float marginRight;
    protected Float scale;
    protected Boolean isLandscape;
    protected Boolean isIncludeBackground;

    public HtmlConvertor(Document document) {
        super(document);
    }

    public void setMargin(float margin) {
        this.marginTop = Float.valueOf(margin);
        this.marginBottom = Float.valueOf(margin);
        this.marginLeft = Float.valueOf(margin);
        this.marginRight = Float.valueOf(margin);
    }

    public Document toPdf(File file) {
        return this.toPdf(file.getAbsolutePath());
    }

    public Document toPdf(String url) {
        this.init();
        return this.convertToPdf(url);
    }

    public byte[] toPdfBytes(File file) {
        return this.toPdfBytes(file.getAbsolutePath());
    }

    public byte[] toPdfBytes(String url) {
        this.init();
        return this.convertToPdfBytes(url);
    }

    public Document toPdfWithImage(File file) {
        return this.toPdfWithImage(file.getAbsolutePath());
    }

    public Document toPdfWithImage(String url) {
        this.init();
        BufferedImage bufferedImage = this.convertToImage(url);
        return this.imageToPdf(bufferedImage);
    }

    public BufferedImage toImage(File file) {
        return this.toImage(file.getAbsolutePath());
    }

    public BufferedImage toImage(String url) {
        this.init();
        return this.convertToImage(url);
    }

    public byte[] toImageBytes(File file) {
        return this.toImageBytes(file.getAbsolutePath());
    }

    public byte[] toImageBytes(String url) {
        this.init();
        return this.convertToImageBytes(url);
    }

    protected void init() {
        if (Objects.isNull(this.dpi)) {
            this.dpi = 96;
        }
        if (Objects.isNull(this.pageSize)) {
            this.pageSize = PageSize.A4;
        }
        if (Objects.isNull(this.isIncludeBackground)) {
            this.isIncludeBackground = true;
        }
        if (Objects.isNull(this.requestTimeout)) {
            this.requestTimeout = 60000L;
        }
        if (Objects.isNull((Object)this.pageState)) {
            this.pageState = PageLoadState.DOMCONTENTLOADED;
        }
        if (Objects.isNull(this.marginTop)) {
            this.marginTop = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginBottom)) {
            this.marginBottom = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginLeft)) {
            this.marginLeft = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginRight)) {
            this.marginRight = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.scale)) {
            this.scale = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.isLandscape)) {
            this.isLandscape = Boolean.FALSE;
        }
    }

    protected Document convertToPdf(String url) {
        return PdfHandler.getDocumentHandler().load(this.convertToPdfBytes(url));
    }

    protected byte[] convertToPdfBytes(String url) {
        Page.PdfOptions options = new Page.PdfOptions().setWidth(UnitUtil.pt2px(this.dpi, this.pageSize.getWidth().floatValue()) + UNIT).setHeight(UnitUtil.pt2px(this.dpi, this.pageSize.getHeight().floatValue()) + UNIT).setPrintBackground(this.isIncludeBackground.booleanValue()).setOutline(true).setScale((double)this.scale.floatValue()).setLandscape(this.isLandscape.booleanValue()).setMargin(new Margin().setLeft(this.marginLeft + UNIT).setRight(this.marginRight + UNIT).setTop(this.marginTop + UNIT).setBottom(this.marginBottom + UNIT));
        return this.convert(url, page -> page.pdf(options));
    }

    protected BufferedImage convertToImage(String url) {
        return ImageUtil.read(this.convertToImageBytes(url));
    }

    protected byte[] convertToImageBytes(String url) {
        return this.convert(url, page -> page.screenshot(new Page.ScreenshotOptions().setType(ScreenshotType.PNG).setFullPage(true).setOmitBackground(true)));
    }

    protected byte[] convert(String url, Function<Page, byte[]> function) {
        return POOL.submit(() -> {
            long begin = 0L;
            long end = 0L;
            Page page = this.getBrowserPage();
            if (this.log.isInfoEnabled()) {
                begin = System.currentTimeMillis();
                this.log.info((Object)("Loading page: " + url));
            }
            page.navigate(url);
            page.waitForLoadState(this.pageState.getState(), new Page.WaitForLoadStateOptions().setTimeout((double)this.requestTimeout.longValue()));
            page.evaluate("document.fonts.ready.then(() => { window.isFontLoaded = true; });");
            page.waitForFunction("window.isFontLoaded === true");
            if (this.log.isInfoEnabled()) {
                end = System.currentTimeMillis();
                this.log.info((Object)("Loaded page: " + (end - begin) + " ms"));
                begin = end;
                this.log.info((Object)"Converting page...");
            }
            byte[] bytes = (byte[])function.apply(page);
            if (this.log.isInfoEnabled()) {
                end = System.currentTimeMillis();
                this.log.info((Object)("Converted page: " + (end - begin) + " ms"));
            }
            return bytes;
        }).get(5L, TimeUnit.MINUTES);
    }

    protected Document imageToPdf(BufferedImage sourceImage) {
        int multiple = 2;
        Document document = PdfHandler.getDocumentHandler().create();
        document.setMarginTop(this.marginTop.floatValue());
        document.setMarginBottom(this.marginBottom.floatValue());
        document.setMarginLeft(this.marginLeft.floatValue());
        document.setMarginRight(this.marginRight.floatValue());
        org.dromara.pdf.pdfbox.core.base.Page page = new org.dromara.pdf.pdfbox.core.base.Page(document);
        float scale = page.getWithoutMarginWidth().floatValue() / (float)sourceImage.getWidth();
        List<BufferedImage> images = ImageUtil.splitForVertical(sourceImage, (int)(page.getWithoutMarginHeight().floatValue() / scale));
        for (BufferedImage image : images) {
            Image component = new Image(document.getCurrentPage());
            component.setImage(ImageUtil.scale(image, image.getWidth() * 2, image.getHeight() * 2, 1));
            component.setScale(Float.valueOf(scale * this.scale.floatValue() / 2.0f));
            component.setHorizontalAlignment(HorizontalAlignment.CENTER);
            component.setVerticalAlignment(VerticalAlignment.CENTER);
            component.render();
        }
        document.appendPage(page);
        return document;
    }

    protected Page getBrowserPage() {
        Page page = THREAD_LOCAL.get();
        if (Objects.nonNull(page)) {
            return page;
        }
        page = this.initBrowserPage();
        return page;
    }

    protected Page initBrowserPage() {
        long begin = 0L;
        long end = 0L;
        if (this.log.isInfoEnabled()) {
            begin = System.currentTimeMillis();
            this.log.info((Object)"Initializing browser...");
        }
        Playwright playwright = Playwright.create();
        Browser browser = playwright.chromium().launch(new BrowserType.LaunchOptions().setHeadless(true));
        if (this.log.isInfoEnabled()) {
            end = System.currentTimeMillis();
            this.log.info((Object)("Initialized browser: " + (end - begin) + " ms"));
            begin = end;
            this.log.info((Object)"Initializing page...");
        }
        Page newPage = browser.newPage();
        THREAD_LOCAL.set(newPage);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            browser.close();
            playwright.close();
        }));
        if (this.log.isInfoEnabled()) {
            end = System.currentTimeMillis();
            this.log.info((Object)("Initialized page: " + (end - begin) + " ms"));
        }
        return newPage;
    }

    @Generated
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    @Generated
    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Generated
    public void setPageState(PageLoadState pageState) {
        this.pageState = pageState;
    }

    @Generated
    public void setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
    }

    @Generated
    public void setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
    }

    @Generated
    public void setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
    }

    @Generated
    public void setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
    }

    @Generated
    public void setScale(Float scale) {
        this.scale = scale;
    }

    @Generated
    public void setIsLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    @Generated
    public void setIsIncludeBackground(Boolean isIncludeBackground) {
        this.isIncludeBackground = isIncludeBackground;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HtmlConvertor)) {
            return false;
        }
        HtmlConvertor other = (HtmlConvertor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$dpi = this.dpi;
        Integer other$dpi = other.dpi;
        if (this$dpi == null ? other$dpi != null : !((Object)this$dpi).equals(other$dpi)) {
            return false;
        }
        Long this$requestTimeout = this.requestTimeout;
        Long other$requestTimeout = other.requestTimeout;
        if (this$requestTimeout == null ? other$requestTimeout != null : !((Object)this$requestTimeout).equals(other$requestTimeout)) {
            return false;
        }
        Float this$marginTop = this.marginTop;
        Float other$marginTop = other.marginTop;
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.marginBottom;
        Float other$marginBottom = other.marginBottom;
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$marginLeft = this.marginLeft;
        Float other$marginLeft = other.marginLeft;
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.marginRight;
        Float other$marginRight = other.marginRight;
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$scale = this.scale;
        Float other$scale = other.scale;
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        Boolean this$isLandscape = this.isLandscape;
        Boolean other$isLandscape = other.isLandscape;
        if (this$isLandscape == null ? other$isLandscape != null : !((Object)this$isLandscape).equals(other$isLandscape)) {
            return false;
        }
        Boolean this$isIncludeBackground = this.isIncludeBackground;
        Boolean other$isIncludeBackground = other.isIncludeBackground;
        if (this$isIncludeBackground == null ? other$isIncludeBackground != null : !((Object)this$isIncludeBackground).equals(other$isIncludeBackground)) {
            return false;
        }
        PageSize this$pageSize = this.pageSize;
        PageSize other$pageSize = other.pageSize;
        if (this$pageSize == null ? other$pageSize != null : !this$pageSize.equals(other$pageSize)) {
            return false;
        }
        PageLoadState this$pageState = this.pageState;
        PageLoadState other$pageState = other.pageState;
        return !(this$pageState == null ? other$pageState != null : !((Object)((Object)this$pageState)).equals((Object)other$pageState));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HtmlConvertor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $dpi = this.dpi;
        result = result * 59 + ($dpi == null ? 43 : ((Object)$dpi).hashCode());
        Long $requestTimeout = this.requestTimeout;
        result = result * 59 + ($requestTimeout == null ? 43 : ((Object)$requestTimeout).hashCode());
        Float $marginTop = this.marginTop;
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.marginBottom;
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $marginLeft = this.marginLeft;
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.marginRight;
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $scale = this.scale;
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        Boolean $isLandscape = this.isLandscape;
        result = result * 59 + ($isLandscape == null ? 43 : ((Object)$isLandscape).hashCode());
        Boolean $isIncludeBackground = this.isIncludeBackground;
        result = result * 59 + ($isIncludeBackground == null ? 43 : ((Object)$isIncludeBackground).hashCode());
        PageSize $pageSize = this.pageSize;
        result = result * 59 + ($pageSize == null ? 43 : $pageSize.hashCode());
        PageLoadState $pageState = this.pageState;
        result = result * 59 + ($pageState == null ? 43 : ((Object)((Object)$pageState)).hashCode());
        return result;
    }

    protected static class DefaultThread
    extends Thread {
        public DefaultThread(@Nullable ThreadGroup group, Runnable target, @NotNull String name, long stackSize) {
            super(group, target, name, stackSize);
        }
    }

    protected static class DefaultThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final String namePrefix;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        DefaultThreadFactory() {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = "playwrightPool-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            DefaultThread t = new DefaultThread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    protected static class DefaultThreadPool {
        protected DefaultThreadPool() {
        }

        protected static ThreadPoolExecutor createPool() {
            int count = Runtime.getRuntime().availableProcessors() + 1;
            return new ThreadPoolExecutor(count, count, 300L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), new DefaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        }
    }
}

