/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.analyzer;

import java.io.Closeable;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractBookmarkAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractCommentAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractFormAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractImageAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractTextAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.BookmarkAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.CommentAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.FormAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.ImageAnalyzer;
import org.dromara.pdf.pdfbox.core.ext.analyzer.TextAnalyzer;
import org.dromara.pdf.pdfbox.core.info.BookmarkInfo;
import org.dromara.pdf.pdfbox.core.info.CommentInfo;
import org.dromara.pdf.pdfbox.core.info.FormFieldInfo;
import org.dromara.pdf.pdfbox.core.info.ImageInfo;
import org.dromara.pdf.pdfbox.core.info.TextInfo;

public class DocumentAnalyzer
extends AbstractAnalyzer
implements Closeable {
    protected AbstractTextAnalyzer textAnalyzer;
    protected AbstractCommentAnalyzer commentAnalyzer;
    protected AbstractImageAnalyzer imageAnalyzer;
    protected AbstractFormAnalyzer formAnalyzer;
    protected AbstractBookmarkAnalyzer bookmarkAnalyzer;

    public DocumentAnalyzer(Document document) {
        super(document);
    }

    public int getCharacterCount(int ... pageIndexes) {
        if (Objects.isNull(this.textAnalyzer)) {
            this.textAnalyzer = new TextAnalyzer(this.document);
        }
        int count = 0;
        if (Objects.isNull(pageIndexes) || pageIndexes.length == 0) {
            int total = this.getDocument().getNumberOfPages();
            for (int index = 0; index < total; ++index) {
                count += this.textAnalyzer.getCharacterCount(index);
            }
        } else {
            for (int index : pageIndexes) {
                if (index < 0) continue;
                count += this.textAnalyzer.getCharacterCount(index);
            }
        }
        return count;
    }

    public Set<TextInfo> analyzeText(int ... pageIndexes) {
        if (Objects.isNull(this.textAnalyzer)) {
            this.textAnalyzer = new TextAnalyzer(this.document);
        }
        this.process((index, page) -> this.textAnalyzer.processText((int)index), pageIndexes);
        return this.textAnalyzer.getInfoSet();
    }

    public Set<CommentInfo> analyzeComment(int ... pageIndexes) {
        if (Objects.isNull(this.commentAnalyzer)) {
            this.commentAnalyzer = new CommentAnalyzer(this.document);
        }
        this.process(this.commentAnalyzer::processComment, pageIndexes);
        return this.commentAnalyzer.getInfoSet();
    }

    public Set<ImageInfo> analyzeImage(int ... pageIndexes) {
        if (Objects.isNull(this.imageAnalyzer)) {
            this.imageAnalyzer = new ImageAnalyzer(this.document);
        }
        this.process(this.imageAnalyzer::processImage, pageIndexes);
        return this.imageAnalyzer.getInfoSet();
    }

    public Set<FormFieldInfo> analyzeForm(int ... pageIndexes) {
        if (Objects.isNull(this.formAnalyzer)) {
            this.formAnalyzer = new FormAnalyzer(this.document);
        }
        this.process(this.formAnalyzer::processForm, pageIndexes);
        if (Objects.isNull(pageIndexes) || pageIndexes.length == 0) {
            this.formAnalyzer.processForm(-1, null);
        }
        this.process(this.formAnalyzer::processForm, pageIndexes);
        return this.formAnalyzer.getInfoSet();
    }

    public Set<BookmarkInfo> analyzeBookmark(int ... bookmarkIndexes) {
        if (Objects.isNull(this.bookmarkAnalyzer)) {
            this.bookmarkAnalyzer = new BookmarkAnalyzer(this.document);
        }
        this.bookmarkAnalyzer.processOutlineItem(bookmarkIndexes);
        return this.bookmarkAnalyzer.getInfoSet();
    }

    @Override
    public void close() {
        this.textAnalyzer = null;
        this.commentAnalyzer = null;
        this.imageAnalyzer = null;
        this.formAnalyzer = null;
        this.bookmarkAnalyzer = null;
    }

    protected void process(BiConsumer<Integer, PDPage> consumer, int[] pageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.isNull(pageIndexes) || pageIndexes.length == 0) {
            int count = pageTree.getCount();
            for (int i = 0; i < count; ++i) {
                consumer.accept(i, pageTree.get(i));
            }
        } else {
            for (int index : pageIndexes) {
                if (index < 0) continue;
                consumer.accept(index, pageTree.get(index));
            }
        }
    }

    @Generated
    public AbstractTextAnalyzer getTextAnalyzer() {
        return this.textAnalyzer;
    }

    @Generated
    public AbstractCommentAnalyzer getCommentAnalyzer() {
        return this.commentAnalyzer;
    }

    @Generated
    public AbstractImageAnalyzer getImageAnalyzer() {
        return this.imageAnalyzer;
    }

    @Generated
    public AbstractFormAnalyzer getFormAnalyzer() {
        return this.formAnalyzer;
    }

    @Generated
    public AbstractBookmarkAnalyzer getBookmarkAnalyzer() {
        return this.bookmarkAnalyzer;
    }

    @Generated
    public void setTextAnalyzer(AbstractTextAnalyzer textAnalyzer) {
        this.textAnalyzer = textAnalyzer;
    }

    @Generated
    public void setCommentAnalyzer(AbstractCommentAnalyzer commentAnalyzer) {
        this.commentAnalyzer = commentAnalyzer;
    }

    @Generated
    public void setImageAnalyzer(AbstractImageAnalyzer imageAnalyzer) {
        this.imageAnalyzer = imageAnalyzer;
    }

    @Generated
    public void setFormAnalyzer(AbstractFormAnalyzer formAnalyzer) {
        this.formAnalyzer = formAnalyzer;
    }

    @Generated
    public void setBookmarkAnalyzer(AbstractBookmarkAnalyzer bookmarkAnalyzer) {
        this.bookmarkAnalyzer = bookmarkAnalyzer;
    }

    @Generated
    public String toString() {
        return "DocumentAnalyzer(textAnalyzer=" + this.getTextAnalyzer() + ", commentAnalyzer=" + this.getCommentAnalyzer() + ", imageAnalyzer=" + this.getImageAnalyzer() + ", formAnalyzer=" + this.getFormAnalyzer() + ", bookmarkAnalyzer=" + this.getBookmarkAnalyzer() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentAnalyzer)) {
            return false;
        }
        DocumentAnalyzer other = (DocumentAnalyzer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractTextAnalyzer this$textAnalyzer = this.getTextAnalyzer();
        AbstractTextAnalyzer other$textAnalyzer = other.getTextAnalyzer();
        if (this$textAnalyzer == null ? other$textAnalyzer != null : !this$textAnalyzer.equals(other$textAnalyzer)) {
            return false;
        }
        AbstractCommentAnalyzer this$commentAnalyzer = this.getCommentAnalyzer();
        AbstractCommentAnalyzer other$commentAnalyzer = other.getCommentAnalyzer();
        if (this$commentAnalyzer == null ? other$commentAnalyzer != null : !this$commentAnalyzer.equals(other$commentAnalyzer)) {
            return false;
        }
        AbstractImageAnalyzer this$imageAnalyzer = this.getImageAnalyzer();
        AbstractImageAnalyzer other$imageAnalyzer = other.getImageAnalyzer();
        if (this$imageAnalyzer == null ? other$imageAnalyzer != null : !this$imageAnalyzer.equals(other$imageAnalyzer)) {
            return false;
        }
        AbstractFormAnalyzer this$formAnalyzer = this.getFormAnalyzer();
        AbstractFormAnalyzer other$formAnalyzer = other.getFormAnalyzer();
        if (this$formAnalyzer == null ? other$formAnalyzer != null : !this$formAnalyzer.equals(other$formAnalyzer)) {
            return false;
        }
        AbstractBookmarkAnalyzer this$bookmarkAnalyzer = this.getBookmarkAnalyzer();
        AbstractBookmarkAnalyzer other$bookmarkAnalyzer = other.getBookmarkAnalyzer();
        return !(this$bookmarkAnalyzer == null ? other$bookmarkAnalyzer != null : !this$bookmarkAnalyzer.equals(other$bookmarkAnalyzer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentAnalyzer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AbstractTextAnalyzer $textAnalyzer = this.getTextAnalyzer();
        result = result * 59 + ($textAnalyzer == null ? 43 : $textAnalyzer.hashCode());
        AbstractCommentAnalyzer $commentAnalyzer = this.getCommentAnalyzer();
        result = result * 59 + ($commentAnalyzer == null ? 43 : $commentAnalyzer.hashCode());
        AbstractImageAnalyzer $imageAnalyzer = this.getImageAnalyzer();
        result = result * 59 + ($imageAnalyzer == null ? 43 : $imageAnalyzer.hashCode());
        AbstractFormAnalyzer $formAnalyzer = this.getFormAnalyzer();
        result = result * 59 + ($formAnalyzer == null ? 43 : $formAnalyzer.hashCode());
        AbstractBookmarkAnalyzer $bookmarkAnalyzer = this.getBookmarkAnalyzer();
        result = result * 59 + ($bookmarkAnalyzer == null ? 43 : $bookmarkAnalyzer.hashCode());
        return result;
    }
}

