/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationHighlight;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquiggly;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationStrikeout;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationUnderline;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.InnerDest;
import org.dromara.pdf.pdfbox.core.base.OuterDest;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Position;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.component.TextLineInfo;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;
import org.dromara.pdf.pdfbox.core.enums.HighlightMode;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.core.ext.handler.AbstractTextHandler;
import org.dromara.pdf.pdfbox.core.ext.handler.tokenizer.AbstractTokenizer;
import org.dromara.pdf.pdfbox.core.info.CatalogInfo;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.ColorUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;
import org.dromara.pdf.pdfbox.util.IdUtil;
import org.dromara.pdf.pdfbox.util.TextUtil;

public class Textarea
extends AbstractComponent {
    protected FontConfiguration fontConfiguration;
    protected CatalogInfo catalog;
    protected List<PDAnnotation> annotations;
    protected AbstractTextHandler textHandler;
    protected AbstractTokenizer tokenizer;
    protected Integer tabSize;
    protected String text;
    protected List<String> textList;
    protected List<TextLineInfo> infoList;
    protected Float rise;
    protected Color highlightColor;
    protected Boolean isHighlight;
    protected Color underlineColor;
    protected Boolean isUnderline;
    protected Color wavyLineColor;
    protected Boolean isWavyLine;
    protected Color deleteLineColor;
    protected Boolean isDeleteLine;
    protected InnerDest innerDest;
    protected OuterDest outerDest;
    protected Float fontHeight;
    protected Float fontDescent;

    public Textarea(Page page) {
        super(page);
        this.fontConfiguration = new FontConfiguration(page.getFontConfiguration());
    }

    public void setTextHandler(AbstractTextHandler handler) {
        Objects.requireNonNull(handler, "the handler can not be null");
        this.textHandler = handler;
    }

    public void setTokenizer(AbstractTokenizer tokenizer) {
        Objects.requireNonNull(tokenizer, "the tokenizer can not be null");
        this.tokenizer = tokenizer;
        this.tokenizer.setContext(this.getContext());
    }

    public void setTabSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("the size can not be less than 0");
        }
        this.tabSize = size;
    }

    @Override
    public ComponentType getType() {
        return ComponentType.TEXTAREA;
    }

    public String getPlaceholder() {
        return "${CPN}";
    }

    public PDFont getFont() {
        return this.getContext().getFont(this.fontConfiguration.getFontName());
    }

    public String getFontName() {
        return this.fontConfiguration.getFontName();
    }

    public void setFontName(String fontName) {
        if (Objects.nonNull(fontName)) {
            this.getContext().addFontCache(fontName);
            this.fontConfiguration.setFontName(fontName);
            this.fontHeight = null;
            this.fontDescent = null;
        } else {
            this.fontConfiguration.setFontName(this.getPage().getFontName());
        }
    }

    public List<String> getSpecialFontNames() {
        return this.fontConfiguration.getSpecialFontNames();
    }

    public void setSpecialFontNames(String ... fontNames) {
        this.getContext().addFontCache(fontNames);
        Collections.addAll(this.fontConfiguration.getSpecialFontNames(), fontNames);
    }

    public Float getFontSize() {
        return this.fontConfiguration.getFontSize();
    }

    public void setFontSize(float size) {
        this.fontConfiguration.setFontSize(size);
    }

    public Color getFontColor() {
        return this.fontConfiguration.getFontColor();
    }

    public void setFontColor(Color color) {
        this.fontConfiguration.setFontColor(color);
    }

    public Color getStrokColor() {
        return this.fontConfiguration.getStrokColor();
    }

    public void setStrokColor(Color color) {
        this.fontConfiguration.setStrokColor(color);
    }

    public Float getFontAlpha() {
        return this.fontConfiguration.getFontAlpha();
    }

    public void setFontAlpha(float alpha) {
        this.fontConfiguration.setFontAlpha(Float.valueOf(alpha));
    }

    public FontStyle getFontStyle() {
        return this.fontConfiguration.getFontStyle();
    }

    public void setFontStyle(FontStyle style) {
        this.fontConfiguration.setFontStyle(style);
        if (style.isItalic() && this.getFontSlope().floatValue() == 0.0f) {
            this.setFontSlope(Constants.DEFAULT_FONT_ITALIC_SLOPE.floatValue());
        }
    }

    public Float getFontSlope() {
        return this.fontConfiguration.getFontSlope();
    }

    public void setFontSlope(float slope) {
        this.fontConfiguration.setFontSlope(Float.valueOf(slope));
    }

    public Float getCharacterSpacing() {
        return this.fontConfiguration.getCharacterSpacing();
    }

    public void setCharacterSpacing(float spacing) {
        this.fontConfiguration.setCharacterSpacing(spacing);
    }

    public Float getLeading() {
        return this.fontConfiguration.getLeading();
    }

    public void setLeading(float leading) {
        this.fontConfiguration.setLeading(leading);
    }

    @Override
    protected void init() {
        super.init();
        this.annotations = this.getPage().getTarget().getAnnotations();
        if (Objects.isNull(this.textHandler)) {
            this.textHandler = this.getContext().getTextHandler();
        }
        if (Objects.nonNull(this.tokenizer)) {
            this.textHandler.setTokenizer(this.tokenizer);
        }
        if (Objects.isNull(this.tabSize)) {
            this.tabSize = 4;
        }
        if (Objects.isNull(this.rise)) {
            this.rise = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.highlightColor)) {
            this.highlightColor = this.getContext().getPage().getBackgroundColor();
        }
        if (Objects.isNull(this.isHighlight)) {
            this.isHighlight = Boolean.FALSE;
        }
        if (Objects.isNull(this.underlineColor)) {
            this.underlineColor = this.getFontColor();
        }
        if (Objects.isNull(this.isUnderline)) {
            this.isUnderline = Boolean.FALSE;
        }
        if (Objects.isNull(this.wavyLineColor)) {
            this.wavyLineColor = this.getFontColor();
        }
        if (Objects.isNull(this.isWavyLine)) {
            this.isWavyLine = Boolean.FALSE;
        }
        if (Objects.isNull(this.deleteLineColor)) {
            this.deleteLineColor = this.getFontColor();
        }
        if (Objects.isNull(this.isDeleteLine)) {
            this.isDeleteLine = Boolean.FALSE;
        }
        this.initFontHeightAndDescent();
        this.checkWrap(this.fontHeight.floatValue());
        if (this.getContext().isEqualsComponent(this.getType()) && this.checkPaging()) {
            this.setIsWrap(true);
            this.wrap(this.fontHeight.floatValue());
        }
        this.initText();
        this.initBeginY(this.getTextHandler().getTextHeight(this.getFontConfiguration(), this.getInfoList().size()));
    }

    @Override
    protected void writeContents() {
        if (this.getContext().getIsVirtualRender().booleanValue()) {
            this.virtualWrite();
        } else {
            this.write();
        }
    }

    @Override
    protected void reset() {
    }

    protected void initText() {
        LinkedList<String> tempTextList = new LinkedList<String>();
        if (Objects.nonNull(this.text)) {
            tempTextList.addAll(this.processText(this.text));
        } else if (Objects.nonNull(this.textList)) {
            this.textList.forEach(text -> tempTextList.addAll(this.processText((String)text)));
        } else {
            this.textList = Collections.emptyList();
            this.infoList = Collections.emptyList();
            return;
        }
        this.initTextList(tempTextList);
    }

    protected List<String> processText(String text) {
        String temp = TextUtil.filterAll(text);
        if (temp.contains("${CPN}")) {
            temp = temp.replace("${CPN}", this.getPage().getLastNo().toString());
        }
        if (temp.indexOf(Constants.TAB_CHARACTER.charValue()) > -1) {
            temp = TextUtil.replaceTab(temp, this.getTabSize());
        }
        return Arrays.asList(temp.split("\n"));
    }

    protected void initTextList(List<String> tempTextList) {
        this.infoList = new LinkedList<TextLineInfo>();
        if (tempTextList.isEmpty()) {
            return;
        }
        Context context = this.getContext();
        float firstWidth = context.getWrapWidth().floatValue() + context.getWrapBeginX().floatValue() - this.getBeginX().floatValue();
        float newWidth = context.getWrapWidth().floatValue();
        String text = tempTextList.get(0);
        if (Objects.nonNull(text)) {
            TextLineInfo firstContent = this.textHandler.splitText(this.getFontConfiguration(), text, firstWidth);
            if (Objects.isNull(firstContent)) {
                this.setBeginX(this.getContext().getWrapBeginX());
                this.setBeginY(Float.valueOf(this.getContext().getCursor().getY().floatValue() - this.getFontSize().floatValue() - this.getLeading().floatValue()));
                this.infoList.addAll(this.textHandler.splitLines(this.getFontConfiguration(), text, newWidth));
            } else {
                this.infoList.add(firstContent);
                if (firstContent.getText().length() < text.length()) {
                    this.infoList.addAll(this.textHandler.splitLines(this.getFontConfiguration(), text.substring(firstContent.getText().length()), newWidth));
                }
            }
        }
        int count = tempTextList.size();
        for (int i = 1; i < count; ++i) {
            String str = tempTextList.get(i);
            if (!Objects.nonNull(str)) continue;
            this.infoList.addAll(this.textHandler.splitLines(this.getFontConfiguration(), str, newWidth));
        }
    }

    protected void initCatalog(Position position) {
        if (Objects.nonNull(this.catalog)) {
            Context context = this.getContext();
            this.catalog.setPage(context.getPage());
            this.catalog.setBeginX(position.getX());
            this.catalog.setBeginY(position.getY());
            context.getCatalogs().add(this.catalog);
        }
    }

    @Override
    protected float getMinWidth() {
        return 0.0f;
    }

    protected void virtualWrite() {
        Position position = new Position(Float.valueOf(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue()), Float.valueOf(this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue()));
        if (!this.getInfoList().isEmpty()) {
            TextLineInfo text = null;
            Iterator<TextLineInfo> iterator = this.getInfoList().iterator();
            while (iterator.hasNext()) {
                text = iterator.next();
                this.virtualWrite(text, position);
                if (!iterator.hasNext()) continue;
                position.reset(this.getContext().getWrapBeginX(), Float.valueOf(position.getY().floatValue() - this.getFontHeight().floatValue() - this.getLeading().floatValue()));
            }
            if (Objects.nonNull(text)) {
                this.resetPagePosition(position, text.getWidth().floatValue());
            }
        }
        this.reset(this.getType(), position.getX().floatValue(), position.getY().floatValue());
    }

    protected void write() {
        Position position = new Position(Float.valueOf(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue()), Float.valueOf(this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue()));
        this.initCatalog(position);
        if (!this.getInfoList().isEmpty()) {
            float textWidth = 0.0f;
            PDPageContentStream contentStream = this.initContentStream();
            Iterator<TextLineInfo> iterator = this.getInfoList().iterator();
            while (iterator.hasNext()) {
                TextLineInfo text = iterator.next();
                textWidth = text.getWidth().floatValue();
                contentStream = this.write(text, contentStream, position);
                if (!iterator.hasNext()) continue;
                position.reset(Float.valueOf(this.getContext().getWrapBeginX().floatValue() + this.getMarginLeft().floatValue()), Float.valueOf(position.getY().floatValue() - this.getFontHeight().floatValue() - this.getLeading().floatValue()));
            }
            contentStream.close();
            this.resetPagePosition(position, textWidth);
        }
        this.reset(this.getType(), position.getX().floatValue(), position.getY().floatValue());
    }

    protected void virtualWrite(TextLineInfo text, Position position) {
        if (TextUtil.isNotBlank(text.getText())) {
            this.virtualCheckPaging(position);
        }
    }

    protected PDPageContentStream write(TextLineInfo text, PDPageContentStream contentStream, Position position) {
        if (Objects.nonNull(text)) {
            contentStream = this.checkPaging(contentStream, position);
            PDRectangle textRectangle = this.getLineRectangle(text.getWidth().floatValue(), position);
            PDRectangle lineRectangle = new PDRectangle(textRectangle.getLowerLeftX(), textRectangle.getLowerLeftY() + this.getFontDescent().floatValue(), textRectangle.getWidth(), textRectangle.getHeight());
            this.addHighlight(lineRectangle);
            this.addText(text, textRectangle, contentStream);
            this.addDeleteLine(lineRectangle);
            this.addUnderline(lineRectangle);
            this.addWavyLine(lineRectangle);
            this.addInnerDest(lineRectangle);
            this.addOuterDest(lineRectangle);
            this.addBorder(lineRectangle, contentStream);
            position.setX(Float.valueOf(lineRectangle.getLowerLeftX()));
        }
        return contentStream;
    }

    protected PDPageContentStream checkPaging(PDPageContentStream contentStream, Position position) {
        if (this.checkPaging(this, position.getY().floatValue())) {
            if (this.getContext().isEqualsComponent(this.getType())) {
                this.getContext().setIsAlreadyPaging(false);
            }
            this.processBreak();
            this.wrap(this.getFontHeight().floatValue());
            position.setY(this.getBeginY());
            if (position.getY().floatValue() > 0.0f) {
                this.initAfterPagingPosition(position);
                contentStream.close();
                return this.initContentStream();
            }
            return this.checkPaging(contentStream, position);
        }
        return contentStream;
    }

    protected void virtualCheckPaging(Position position) {
        if (this.checkPaging(this, position.getY().floatValue())) {
            if (this.getContext().isEqualsComponent(this.getType())) {
                this.getContext().setIsAlreadyPaging(false);
            }
            this.processBreak();
            this.wrap(this.getFontHeight().floatValue());
            position.setY(Float.valueOf(this.getBeginY().floatValue() - this.getContext().getOffsetY().floatValue()));
            if (position.getY().floatValue() > 0.0f) {
                this.initAfterPagingPosition(position);
            } else {
                this.virtualCheckPaging(position);
            }
        }
    }

    protected void initAfterPagingPosition(Position position) {
        if (this.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
            position.setY(Float.valueOf(position.getY().floatValue() + this.getFontHeight().floatValue()));
        } else {
            position.setY(Float.valueOf(Math.min(position.getY().floatValue(), this.getContext().getMaxBeginY() - this.getFontHeight().floatValue())));
        }
    }

    protected void addHighlight(PDRectangle rectangle) {
        if (this.getIsHighlight().booleanValue()) {
            PDAnnotationHighlight annotation = new PDAnnotationHighlight();
            annotation.setAnnotationName(IdUtil.get());
            annotation.setColor(ColorUtil.toPDColor(this.getHighlightColor()));
            annotation.setPage(this.getPage().getTarget());
            annotation.setQuadPoints(CommonUtil.getQuadPoints(rectangle));
            this.annotations.add((PDAnnotation)annotation);
        }
    }

    protected void addText(TextLineInfo text, PDRectangle rectangle, PDPageContentStream contentStream) {
        CommonUtil.initFontColorAndAlpha(contentStream, this.getPage().getBackgroundColor(), this.getFontStyle(), this.getFontColor(), this.getStrokColor(), this.getFontAlpha().floatValue());
        contentStream.beginText();
        this.initMatrix(contentStream, rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
        this.getTextHandler().writeText(this.getFontConfiguration(), contentStream, text);
        contentStream.endText();
    }

    protected void addDeleteLine(PDRectangle rectangle) {
        if (this.getIsDeleteLine().booleanValue()) {
            PDAnnotationStrikeout annotation = new PDAnnotationStrikeout();
            annotation.setAnnotationName(IdUtil.get());
            annotation.setColor(ColorUtil.toPDColor(this.getDeleteLineColor()));
            annotation.setQuadPoints(CommonUtil.getQuadPoints(rectangle));
            this.annotations.add((PDAnnotation)annotation);
        }
    }

    protected void addUnderline(PDRectangle rectangle) {
        if (this.getIsUnderline().booleanValue()) {
            PDAnnotationUnderline annotation = new PDAnnotationUnderline();
            annotation.setAnnotationName(IdUtil.get());
            annotation.setColor(ColorUtil.toPDColor(this.getUnderlineColor()));
            annotation.setQuadPoints(CommonUtil.getQuadPoints2(rectangle));
            this.annotations.add((PDAnnotation)annotation);
        }
    }

    protected void addWavyLine(PDRectangle rectangle) {
        if (this.getIsWavyLine().booleanValue()) {
            PDAnnotationSquiggly annotation = new PDAnnotationSquiggly();
            annotation.setAnnotationName(IdUtil.get());
            annotation.setColor(ColorUtil.toPDColor(this.getWavyLineColor()));
            annotation.setQuadPoints(CommonUtil.getQuadPoints2(rectangle));
            this.annotations.add((PDAnnotation)annotation);
        }
    }

    protected void addInnerDest(PDRectangle rectangle) {
        if (Objects.nonNull(this.getInnerDest())) {
            Objects.requireNonNull(this.getInnerDest().getPage(), "the page of inner destination can not be null");
            PDPageXYZDestination destination = new PDPageXYZDestination();
            destination.setPage(this.getInnerDest().getPage().getTarget());
            Optional.ofNullable(this.getInnerDest().getTopY()).ifPresent(arg_0 -> ((PDPageXYZDestination)destination).setTop(arg_0));
            PDActionGoTo action = new PDActionGoTo();
            action.setDestination((PDDestination)destination);
            this.addLink((PDAction)action, this.getInnerDest().getName(), rectangle, this.getInnerDest().getHighlightMode());
        }
    }

    protected void addOuterDest(PDRectangle rectangle) {
        if (Objects.nonNull(this.getOuterDest())) {
            Objects.requireNonNull(this.getOuterDest().getUrl(), "the url of outer destination can not be null");
            PDActionURI action = new PDActionURI();
            action.setURI(this.getOuterDest().getUrl());
            this.addLink((PDAction)action, this.getOuterDest().getName(), rectangle, this.getOuterDest().getHighlightMode());
        }
    }

    protected void addLink(PDAction action, String name, PDRectangle rectangle, HighlightMode mode) {
        PDPage page = this.getPage().getTarget();
        PDAnnotationLink link = new PDAnnotationLink();
        link.setAnnotationName(Optional.ofNullable(name).orElse(IdUtil.get()));
        Optional.ofNullable(mode).map(HighlightMode::getMode).ifPresent(arg_0 -> ((PDAnnotationLink)link).setHighlightMode(arg_0));
        link.setAction(action);
        link.setRectangle(rectangle);
        link.setBorderStyle(this.getDefaultLinkBorderStyle());
        link.setPage(page);
        this.annotations.add((PDAnnotation)link);
    }

    protected void addBorder(PDRectangle rectangle, PDPageContentStream stream) {
        if (this.getBorderConfiguration().hasBorder()) {
            BorderUtil.drawNormalBorder(stream, rectangle, new BorderData(this, this.getBorderConfiguration()), this.getPage().getBackgroundColor());
            stream.stroke();
        }
    }

    protected PDPageContentStream initContentStream() {
        Context context = this.getContext();
        PDPageContentStream contentStream = new PDPageContentStream(context.getTargetDocument(), context.getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream());
        contentStream.setFont(this.getFont(), this.getFontSize().floatValue());
        contentStream.setRenderingMode(this.getFontStyle().getMode());
        contentStream.setTextRise(this.getRise().floatValue());
        contentStream.setLeading(this.getLeading().floatValue());
        contentStream.setCharacterSpacing(this.getCharacterSpacing().floatValue());
        contentStream.setLineWidth(CommonUtil.initLineWidth(this.getFontStyle()));
        return contentStream;
    }

    protected void initMatrix(PDPageContentStream stream, float beginX, float beginY) {
        Matrix matrix = new Matrix(1.0f, 0.0f, this.getFontSlope().floatValue(), 1.0f, beginX, beginY);
        stream.setTextMatrix(matrix);
    }

    protected void initFontHeightAndDescent() {
        PDFontDescriptor fontDescriptor = this.getFont().getFontDescriptor();
        float ascent = fontDescriptor.getAscent();
        float descent = fontDescriptor.getDescent();
        this.fontHeight = Float.valueOf((ascent - descent) / 1000.0f * this.getFontSize().floatValue());
        this.fontDescent = Float.valueOf(descent / 1000.0f * this.getFontSize().floatValue());
    }

    protected PDRectangle getLineRectangle(float textWidth, Position position) {
        PDRectangle rectangle = new PDRectangle();
        switch (this.getHorizontalAlignment()) {
            case CENTER: {
                float offset = (this.getContext().getWrapWidth().floatValue() - textWidth) / 2.0f;
                rectangle.setLowerLeftX(position.getX().floatValue() + offset);
                rectangle.setUpperRightX(rectangle.getLowerLeftX() + textWidth);
                break;
            }
            case RIGHT: {
                float offset = this.getContext().getWrapWidth().floatValue() - textWidth - this.getMarginRight().floatValue();
                rectangle.setLowerLeftX(Math.min(this.getBeginX().floatValue() + offset, this.getContext().getMaxBeginX() - textWidth));
                rectangle.setUpperRightX(rectangle.getLowerLeftX() + textWidth);
                break;
            }
            default: {
                rectangle.setLowerLeftX(position.getX().floatValue());
                rectangle.setUpperRightX(position.getX().floatValue() + textWidth);
            }
        }
        rectangle.setLowerLeftY(position.getY().floatValue());
        rectangle.setUpperRightY(rectangle.getLowerLeftY() + this.getFontHeight().floatValue());
        return rectangle;
    }

    protected PDBorderStyleDictionary getDefaultLinkBorderStyle() {
        PDBorderStyleDictionary border = new PDBorderStyleDictionary();
        border.setWidth(0.0f);
        return border;
    }

    protected void resetPagePosition(Position position, float textWidth) {
        position.setX(Float.valueOf(position.getX().floatValue() + textWidth + this.getMarginRight().floatValue()));
        if (Objects.nonNull(this.getCatalog())) {
            this.getCatalog().setEndX(position.getX());
            this.getCatalog().setEndY(position.getY());
        }
    }

    @Override
    protected void reset(ComponentType type, float x, float y) {
        super.reset(type, x, y);
        this.getPage().getTarget().setAnnotations(this.getAnnotations());
        this.annotations = null;
    }

    @Generated
    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    @Generated
    public CatalogInfo getCatalog() {
        return this.catalog;
    }

    @Generated
    public List<PDAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public AbstractTextHandler getTextHandler() {
        return this.textHandler;
    }

    @Generated
    public AbstractTokenizer getTokenizer() {
        return this.tokenizer;
    }

    @Generated
    public Integer getTabSize() {
        return this.tabSize;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public List<String> getTextList() {
        return this.textList;
    }

    @Generated
    public List<TextLineInfo> getInfoList() {
        return this.infoList;
    }

    @Generated
    public Float getRise() {
        return this.rise;
    }

    @Generated
    public Color getHighlightColor() {
        return this.highlightColor;
    }

    @Generated
    public Boolean getIsHighlight() {
        return this.isHighlight;
    }

    @Generated
    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    @Generated
    public Boolean getIsUnderline() {
        return this.isUnderline;
    }

    @Generated
    public Color getWavyLineColor() {
        return this.wavyLineColor;
    }

    @Generated
    public Boolean getIsWavyLine() {
        return this.isWavyLine;
    }

    @Generated
    public Color getDeleteLineColor() {
        return this.deleteLineColor;
    }

    @Generated
    public Boolean getIsDeleteLine() {
        return this.isDeleteLine;
    }

    @Generated
    public InnerDest getInnerDest() {
        return this.innerDest;
    }

    @Generated
    public OuterDest getOuterDest() {
        return this.outerDest;
    }

    @Generated
    public Float getFontHeight() {
        return this.fontHeight;
    }

    @Generated
    public Float getFontDescent() {
        return this.fontDescent;
    }

    @Generated
    public void setFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    @Generated
    public void setCatalog(CatalogInfo catalog) {
        this.catalog = catalog;
    }

    @Generated
    public void setAnnotations(List<PDAnnotation> annotations) {
        this.annotations = annotations;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    @Generated
    public void setInfoList(List<TextLineInfo> infoList) {
        this.infoList = infoList;
    }

    @Generated
    public void setRise(Float rise) {
        this.rise = rise;
    }

    @Generated
    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    @Generated
    public void setIsHighlight(Boolean isHighlight) {
        this.isHighlight = isHighlight;
    }

    @Generated
    public void setUnderlineColor(Color underlineColor) {
        this.underlineColor = underlineColor;
    }

    @Generated
    public void setIsUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    @Generated
    public void setWavyLineColor(Color wavyLineColor) {
        this.wavyLineColor = wavyLineColor;
    }

    @Generated
    public void setIsWavyLine(Boolean isWavyLine) {
        this.isWavyLine = isWavyLine;
    }

    @Generated
    public void setDeleteLineColor(Color deleteLineColor) {
        this.deleteLineColor = deleteLineColor;
    }

    @Generated
    public void setIsDeleteLine(Boolean isDeleteLine) {
        this.isDeleteLine = isDeleteLine;
    }

    @Generated
    public void setInnerDest(InnerDest innerDest) {
        this.innerDest = innerDest;
    }

    @Generated
    public void setOuterDest(OuterDest outerDest) {
        this.outerDest = outerDest;
    }

    @Generated
    public void setFontHeight(Float fontHeight) {
        this.fontHeight = fontHeight;
    }

    @Generated
    public void setFontDescent(Float fontDescent) {
        this.fontDescent = fontDescent;
    }

    @Override
    @Generated
    public String toString() {
        return "Textarea(fontConfiguration=" + this.getFontConfiguration() + ", catalog=" + this.getCatalog() + ", annotations=" + this.getAnnotations() + ", textHandler=" + this.getTextHandler() + ", tokenizer=" + this.getTokenizer() + ", tabSize=" + this.getTabSize() + ", text=" + this.getText() + ", textList=" + this.getTextList() + ", infoList=" + this.getInfoList() + ", rise=" + this.getRise() + ", highlightColor=" + this.getHighlightColor() + ", isHighlight=" + this.getIsHighlight() + ", underlineColor=" + this.getUnderlineColor() + ", isUnderline=" + this.getIsUnderline() + ", wavyLineColor=" + this.getWavyLineColor() + ", isWavyLine=" + this.getIsWavyLine() + ", deleteLineColor=" + this.getDeleteLineColor() + ", isDeleteLine=" + this.getIsDeleteLine() + ", innerDest=" + this.getInnerDest() + ", outerDest=" + this.getOuterDest() + ", fontHeight=" + this.getFontHeight() + ", fontDescent=" + this.getFontDescent() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Textarea)) {
            return false;
        }
        Textarea other = (Textarea)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$tabSize = this.getTabSize();
        Integer other$tabSize = other.getTabSize();
        if (this$tabSize == null ? other$tabSize != null : !((Object)this$tabSize).equals(other$tabSize)) {
            return false;
        }
        Float this$rise = this.getRise();
        Float other$rise = other.getRise();
        if (this$rise == null ? other$rise != null : !((Object)this$rise).equals(other$rise)) {
            return false;
        }
        Boolean this$isHighlight = this.getIsHighlight();
        Boolean other$isHighlight = other.getIsHighlight();
        if (this$isHighlight == null ? other$isHighlight != null : !((Object)this$isHighlight).equals(other$isHighlight)) {
            return false;
        }
        Boolean this$isUnderline = this.getIsUnderline();
        Boolean other$isUnderline = other.getIsUnderline();
        if (this$isUnderline == null ? other$isUnderline != null : !((Object)this$isUnderline).equals(other$isUnderline)) {
            return false;
        }
        Boolean this$isWavyLine = this.getIsWavyLine();
        Boolean other$isWavyLine = other.getIsWavyLine();
        if (this$isWavyLine == null ? other$isWavyLine != null : !((Object)this$isWavyLine).equals(other$isWavyLine)) {
            return false;
        }
        Boolean this$isDeleteLine = this.getIsDeleteLine();
        Boolean other$isDeleteLine = other.getIsDeleteLine();
        if (this$isDeleteLine == null ? other$isDeleteLine != null : !((Object)this$isDeleteLine).equals(other$isDeleteLine)) {
            return false;
        }
        Float this$fontHeight = this.getFontHeight();
        Float other$fontHeight = other.getFontHeight();
        if (this$fontHeight == null ? other$fontHeight != null : !((Object)this$fontHeight).equals(other$fontHeight)) {
            return false;
        }
        Float this$fontDescent = this.getFontDescent();
        Float other$fontDescent = other.getFontDescent();
        if (this$fontDescent == null ? other$fontDescent != null : !((Object)this$fontDescent).equals(other$fontDescent)) {
            return false;
        }
        FontConfiguration this$fontConfiguration = this.getFontConfiguration();
        FontConfiguration other$fontConfiguration = other.getFontConfiguration();
        if (this$fontConfiguration == null ? other$fontConfiguration != null : !((Object)this$fontConfiguration).equals(other$fontConfiguration)) {
            return false;
        }
        CatalogInfo this$catalog = this.getCatalog();
        CatalogInfo other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !((Object)this$catalog).equals(other$catalog)) {
            return false;
        }
        List<PDAnnotation> this$annotations = this.getAnnotations();
        List<PDAnnotation> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        AbstractTextHandler this$textHandler = this.getTextHandler();
        AbstractTextHandler other$textHandler = other.getTextHandler();
        if (this$textHandler == null ? other$textHandler != null : !((Object)this$textHandler).equals(other$textHandler)) {
            return false;
        }
        AbstractTokenizer this$tokenizer = this.getTokenizer();
        AbstractTokenizer other$tokenizer = other.getTokenizer();
        if (this$tokenizer == null ? other$tokenizer != null : !this$tokenizer.equals(other$tokenizer)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$textList = this.getTextList();
        List<String> other$textList = other.getTextList();
        if (this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList)) {
            return false;
        }
        List<TextLineInfo> this$infoList = this.getInfoList();
        List<TextLineInfo> other$infoList = other.getInfoList();
        if (this$infoList == null ? other$infoList != null : !((Object)this$infoList).equals(other$infoList)) {
            return false;
        }
        Color this$highlightColor = this.getHighlightColor();
        Color other$highlightColor = other.getHighlightColor();
        if (this$highlightColor == null ? other$highlightColor != null : !((Object)this$highlightColor).equals(other$highlightColor)) {
            return false;
        }
        Color this$underlineColor = this.getUnderlineColor();
        Color other$underlineColor = other.getUnderlineColor();
        if (this$underlineColor == null ? other$underlineColor != null : !((Object)this$underlineColor).equals(other$underlineColor)) {
            return false;
        }
        Color this$wavyLineColor = this.getWavyLineColor();
        Color other$wavyLineColor = other.getWavyLineColor();
        if (this$wavyLineColor == null ? other$wavyLineColor != null : !((Object)this$wavyLineColor).equals(other$wavyLineColor)) {
            return false;
        }
        Color this$deleteLineColor = this.getDeleteLineColor();
        Color other$deleteLineColor = other.getDeleteLineColor();
        if (this$deleteLineColor == null ? other$deleteLineColor != null : !((Object)this$deleteLineColor).equals(other$deleteLineColor)) {
            return false;
        }
        InnerDest this$innerDest = this.getInnerDest();
        InnerDest other$innerDest = other.getInnerDest();
        if (this$innerDest == null ? other$innerDest != null : !((Object)this$innerDest).equals(other$innerDest)) {
            return false;
        }
        OuterDest this$outerDest = this.getOuterDest();
        OuterDest other$outerDest = other.getOuterDest();
        return !(this$outerDest == null ? other$outerDest != null : !((Object)this$outerDest).equals(other$outerDest));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Textarea;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $tabSize = this.getTabSize();
        result = result * 59 + ($tabSize == null ? 43 : ((Object)$tabSize).hashCode());
        Float $rise = this.getRise();
        result = result * 59 + ($rise == null ? 43 : ((Object)$rise).hashCode());
        Boolean $isHighlight = this.getIsHighlight();
        result = result * 59 + ($isHighlight == null ? 43 : ((Object)$isHighlight).hashCode());
        Boolean $isUnderline = this.getIsUnderline();
        result = result * 59 + ($isUnderline == null ? 43 : ((Object)$isUnderline).hashCode());
        Boolean $isWavyLine = this.getIsWavyLine();
        result = result * 59 + ($isWavyLine == null ? 43 : ((Object)$isWavyLine).hashCode());
        Boolean $isDeleteLine = this.getIsDeleteLine();
        result = result * 59 + ($isDeleteLine == null ? 43 : ((Object)$isDeleteLine).hashCode());
        Float $fontHeight = this.getFontHeight();
        result = result * 59 + ($fontHeight == null ? 43 : ((Object)$fontHeight).hashCode());
        Float $fontDescent = this.getFontDescent();
        result = result * 59 + ($fontDescent == null ? 43 : ((Object)$fontDescent).hashCode());
        FontConfiguration $fontConfiguration = this.getFontConfiguration();
        result = result * 59 + ($fontConfiguration == null ? 43 : ((Object)$fontConfiguration).hashCode());
        CatalogInfo $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : ((Object)$catalog).hashCode());
        List<PDAnnotation> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        AbstractTextHandler $textHandler = this.getTextHandler();
        result = result * 59 + ($textHandler == null ? 43 : ((Object)$textHandler).hashCode());
        AbstractTokenizer $tokenizer = this.getTokenizer();
        result = result * 59 + ($tokenizer == null ? 43 : $tokenizer.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        List<TextLineInfo> $infoList = this.getInfoList();
        result = result * 59 + ($infoList == null ? 43 : ((Object)$infoList).hashCode());
        Color $highlightColor = this.getHighlightColor();
        result = result * 59 + ($highlightColor == null ? 43 : ((Object)$highlightColor).hashCode());
        Color $underlineColor = this.getUnderlineColor();
        result = result * 59 + ($underlineColor == null ? 43 : ((Object)$underlineColor).hashCode());
        Color $wavyLineColor = this.getWavyLineColor();
        result = result * 59 + ($wavyLineColor == null ? 43 : ((Object)$wavyLineColor).hashCode());
        Color $deleteLineColor = this.getDeleteLineColor();
        result = result * 59 + ($deleteLineColor == null ? 43 : ((Object)$deleteLineColor).hashCode());
        InnerDest $innerDest = this.getInnerDest();
        result = result * 59 + ($innerDest == null ? 43 : ((Object)$innerDest).hashCode());
        OuterDest $outerDest = this.getOuterDest();
        result = result * 59 + ($outerDest == null ? 43 : ((Object)$outerDest).hashCode());
        return result;
    }
}

