/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.base.config.BorderConfiguration;
import org.dromara.pdf.pdfbox.core.component.BorderInfo;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.core.component.DiagonalLine;
import org.dromara.pdf.pdfbox.core.component.Table;
import org.dromara.pdf.pdfbox.core.component.TableRow;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.util.BorderUtil;

public class TableCell
extends BorderData {
    protected Color backgroundColor;
    protected TableRow row;
    protected Integer index;
    protected List<Component> components;
    protected Float width;
    protected Integer rowspan;
    protected Integer colspan;
    protected Float beginX;
    protected Float beginY;
    protected Boolean isPagingBorder;
    protected Float contentMarginTop;
    protected Float contentMarginBottom;
    protected Float contentMarginLeft;
    protected Float contentMarginRight;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;
    protected Boolean isEnableUpLine;
    protected Boolean isEnableDownLine;

    public TableCell(TableRow row) {
        this.row = row;
        this.borderConfiguration = new BorderConfiguration(false);
    }

    public void setContentMargin(float margin) {
        this.contentMarginTop = Float.valueOf(margin);
        this.contentMarginBottom = Float.valueOf(margin);
        this.contentMarginLeft = Float.valueOf(margin);
        this.contentMarginRight = Float.valueOf(margin);
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void setComponents(Component ... components) {
        this.components = Objects.nonNull(components) ? new ArrayList<Component>(Arrays.asList(components)) : null;
    }

    public void addComponents(List<Component> components) {
        if (Objects.nonNull(components)) {
            if (Objects.isNull(this.components)) {
                this.components = new ArrayList<Component>(components);
            } else {
                this.components.addAll(components);
            }
        }
    }

    public void addComponents(Component ... components) {
        if (Objects.nonNull(components)) {
            if (Objects.isNull(this.components)) {
                this.components = new ArrayList<Component>(components.length);
            }
            Collections.addAll(this.components, components);
        }
    }

    public void useDefaultContentAlignment() {
        this.contentHorizontalAlignment = HorizontalAlignment.LEFT;
        this.contentVerticalAlignment = VerticalAlignment.TOP;
    }

    public Float getWidth() {
        if (this.getColspan() == 0) {
            return this.width;
        }
        int lastIndex = this.index + this.colspan;
        float total = this.width.floatValue();
        List<Float> cellWidths = this.getRow().getTable().getCellWidths();
        for (int i = this.index + 1; i <= lastIndex; ++i) {
            total += cellWidths.get(i).floatValue();
        }
        return Float.valueOf(total);
    }

    protected Float getHeight() {
        if (this.getRowspan() == 0) {
            return this.row.getHeight();
        }
        int lastIndex = this.row.getIndex() + this.rowspan;
        float total = this.row.getHeight().floatValue();
        TableRow tableRow = Optional.ofNullable(this.row.getNext()).orElse(this.row);
        for (int i = this.row.getIndex() + 1; i <= lastIndex; ++i) {
            total += tableRow.getHeight().floatValue();
            tableRow = Optional.ofNullable(tableRow.getNext()).orElse(this.row);
        }
        return Float.valueOf(total);
    }

    public Integer getRowspan() {
        return Optional.ofNullable(this.rowspan).orElse(0);
    }

    public Integer getColspan() {
        return Optional.ofNullable(this.colspan).orElse(0);
    }

    public Page getPage() {
        return this.row.getPage();
    }

    public void virtualRender(Float beginX, Float beginY) {
        this.processRender(beginX, beginY, false);
    }

    public void render(Float beginX, Float beginY) {
        this.processRender(beginX, beginY, true);
    }

    protected PagingEvent getPagingEvent() {
        return this.row.getPagingEvent();
    }

    protected void init(Float beginX, Float beginY) {
        try {
            this.width = this.row.getTable().getCellWidths().get(this.index);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the index['" + this.index + "'] of cell width is undefined");
        }
        if (Objects.isNull(this.backgroundColor)) {
            this.backgroundColor = this.row.getBackgroundColor();
        }
        if (Objects.isNull(this.contentMarginTop)) {
            this.contentMarginTop = this.row.getContentMarginTop();
        }
        if (Objects.isNull(this.contentMarginBottom)) {
            this.contentMarginBottom = this.row.getContentMarginBottom();
        }
        if (Objects.isNull(this.contentMarginLeft)) {
            this.contentMarginLeft = this.row.getContentMarginLeft();
        }
        if (Objects.isNull(this.contentMarginRight)) {
            this.contentMarginRight = this.row.getContentMarginRight();
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = this.row.getContentHorizontalAlignment();
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = this.row.getContentVerticalAlignment();
        }
        if (Objects.isNull(this.isEnableUpLine)) {
            this.isEnableUpLine = Boolean.FALSE;
        }
        if (Objects.isNull(this.isEnableDownLine)) {
            this.isEnableDownLine = Boolean.FALSE;
        }
        this.beginX = beginX;
        this.beginY = beginY;
        this.initBorder();
        this.initBorderInfo();
    }

    protected void initBorder() {
        super.init(this.row, this.row.getBorderConfiguration());
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = this.row.getIsPagingBorder();
        }
    }

    protected void initBorderInfo() {
        this.getContext().setBorderInfo(new BorderInfo(this, this.getBorderConfiguration(), this.getBackgroundColor(), this.getWidth().floatValue(), this.getHeight().floatValue(), this.getBeginX().floatValue(), this.getBeginY().floatValue(), this.getPagingEvent(), this.getIsPagingBorder()));
    }

    protected boolean isEnableDiagonalLine() {
        return this.isEnableUpLine != false || this.isEnableDownLine != false;
    }

    protected void processRender(Float beginX, Float beginY, boolean isRender) {
        this.init(beginX, beginY);
        BorderInfo borderInfo = this.getContext().getBorderInfo();
        Page page = this.getRow().getPage();
        Context context = page.getContext();
        context.setPage(page);
        context.getCursor().reset(beginX.floatValue(), beginY.floatValue());
        PDRectangle rectangle = this.addBorder(beginX, Float.valueOf(beginY.floatValue() - borderInfo.getHeight().floatValue()), borderInfo);
        this.addDiagonalLine(rectangle);
        float tempY = rectangle.getLowerLeftY();
        if (Objects.nonNull(this.getComponents())) {
            float contentBeginX = beginX.floatValue() + this.getContentMarginLeft().floatValue();
            float contentBeginY = beginY.floatValue() - this.getContentMarginTop().floatValue();
            float contentWidth = this.getWidth().floatValue() - this.getContentMarginLeft().floatValue() - this.getContentMarginRight().floatValue();
            context.setPage(page);
            context.setIsFirstComponent(true);
            context.setHeight(this.getHeight());
            context.getCursor().reset(contentBeginX, contentBeginY);
            for (Component component : this.getComponents()) {
                context.setWrapBeginX(Float.valueOf(contentBeginX));
                context.setWrapWidth(Float.valueOf(contentWidth));
                component.setHorizontalAlignment(this.getContentHorizontalAlignment());
                component.setVerticalAlignment(this.getContentVerticalAlignment());
                if (isRender) {
                    component.render();
                    continue;
                }
                component.virtualRender();
            }
        }
        context.resetCursor(Float.valueOf(beginX.floatValue() + this.getWidth().floatValue()), Float.valueOf(tempY));
    }

    protected PDRectangle addBorder(Float beginX, Float beginY, BorderInfo info) {
        Table table = this.getRow().getTable();
        info.setBeginX(beginX);
        if (info.isPaging() && !this.getIsPagingBorder().booleanValue()) {
            info.setIsBorderTop(Boolean.FALSE);
        }
        if (table.isPaging(table, beginY.floatValue())) {
            return this.addBorder(beginX, Float.valueOf(info.getBeginY().floatValue() - info.getHeight().floatValue()), info);
        }
        PDRectangle rectangle = new PDRectangle(info.getBeginX().floatValue(), info.getBeginY().floatValue() - info.getHeight().floatValue(), info.getWidth().floatValue(), info.getHeight().floatValue());
        BorderUtil.drawBorderWithData(info, rectangle, Optional.ofNullable(info.getBackgroundColor()).orElse(this.getPage().getBackgroundColor()));
        return rectangle;
    }

    protected void addDiagonalLine(PDRectangle rectangle) {
        if (this.isEnableDiagonalLine()) {
            DiagonalLine line = new DiagonalLine(this.getPage());
            line.setLineColor(this.getBorderTopColor());
            if (this.getIsEnableUpLine().booleanValue()) {
                line.setBeginX(Float.valueOf(rectangle.getLowerLeftX()));
                line.setBeginY(Float.valueOf(rectangle.getLowerLeftY()));
                line.setEndX(Float.valueOf(rectangle.getUpperRightX()));
                line.setEndY(Float.valueOf(rectangle.getUpperRightY()));
                line.render();
            }
            if (this.getIsEnableDownLine().booleanValue()) {
                line.setBeginX(Float.valueOf(rectangle.getLowerLeftX()));
                line.setBeginY(Float.valueOf(rectangle.getUpperRightY()));
                line.setEndX(Float.valueOf(rectangle.getUpperRightX()));
                line.setEndY(Float.valueOf(rectangle.getLowerLeftY()));
                line.render();
            }
        }
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public TableRow getRow() {
        return this.row;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public List<Component> getComponents() {
        return this.components;
    }

    @Generated
    public Float getBeginX() {
        return this.beginX;
    }

    @Generated
    public Float getBeginY() {
        return this.beginY;
    }

    @Generated
    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    @Generated
    public Float getContentMarginTop() {
        return this.contentMarginTop;
    }

    @Generated
    public Float getContentMarginBottom() {
        return this.contentMarginBottom;
    }

    @Generated
    public Float getContentMarginLeft() {
        return this.contentMarginLeft;
    }

    @Generated
    public Float getContentMarginRight() {
        return this.contentMarginRight;
    }

    @Generated
    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    @Generated
    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    @Generated
    public Boolean getIsEnableUpLine() {
        return this.isEnableUpLine;
    }

    @Generated
    public Boolean getIsEnableDownLine() {
        return this.isEnableDownLine;
    }

    @Generated
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    public void setRow(TableRow row) {
        this.row = row;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public void setWidth(Float width) {
        this.width = width;
    }

    @Generated
    public void setRowspan(Integer rowspan) {
        this.rowspan = rowspan;
    }

    @Generated
    public void setColspan(Integer colspan) {
        this.colspan = colspan;
    }

    @Generated
    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    @Generated
    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    @Generated
    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    @Generated
    public void setContentMarginTop(Float contentMarginTop) {
        this.contentMarginTop = contentMarginTop;
    }

    @Generated
    public void setContentMarginBottom(Float contentMarginBottom) {
        this.contentMarginBottom = contentMarginBottom;
    }

    @Generated
    public void setContentMarginLeft(Float contentMarginLeft) {
        this.contentMarginLeft = contentMarginLeft;
    }

    @Generated
    public void setContentMarginRight(Float contentMarginRight) {
        this.contentMarginRight = contentMarginRight;
    }

    @Generated
    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    @Generated
    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Generated
    public void setIsEnableUpLine(Boolean isEnableUpLine) {
        this.isEnableUpLine = isEnableUpLine;
    }

    @Generated
    public void setIsEnableDownLine(Boolean isEnableDownLine) {
        this.isEnableDownLine = isEnableDownLine;
    }

    @Override
    @Generated
    public String toString() {
        return "TableCell(backgroundColor=" + this.getBackgroundColor() + ", row=" + this.getRow() + ", index=" + this.getIndex() + ", components=" + this.getComponents() + ", width=" + this.getWidth() + ", rowspan=" + this.getRowspan() + ", colspan=" + this.getColspan() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", isPagingBorder=" + this.getIsPagingBorder() + ", contentMarginTop=" + this.getContentMarginTop() + ", contentMarginBottom=" + this.getContentMarginBottom() + ", contentMarginLeft=" + this.getContentMarginLeft() + ", contentMarginRight=" + this.getContentMarginRight() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ", isEnableUpLine=" + this.getIsEnableUpLine() + ", isEnableDownLine=" + this.getIsEnableDownLine() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableCell)) {
            return false;
        }
        TableCell other = (TableCell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$rowspan = this.getRowspan();
        Integer other$rowspan = other.getRowspan();
        if (this$rowspan == null ? other$rowspan != null : !((Object)this$rowspan).equals(other$rowspan)) {
            return false;
        }
        Integer this$colspan = this.getColspan();
        Integer other$colspan = other.getColspan();
        if (this$colspan == null ? other$colspan != null : !((Object)this$colspan).equals(other$colspan)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Float this$contentMarginTop = this.getContentMarginTop();
        Float other$contentMarginTop = other.getContentMarginTop();
        if (this$contentMarginTop == null ? other$contentMarginTop != null : !((Object)this$contentMarginTop).equals(other$contentMarginTop)) {
            return false;
        }
        Float this$contentMarginBottom = this.getContentMarginBottom();
        Float other$contentMarginBottom = other.getContentMarginBottom();
        if (this$contentMarginBottom == null ? other$contentMarginBottom != null : !((Object)this$contentMarginBottom).equals(other$contentMarginBottom)) {
            return false;
        }
        Float this$contentMarginLeft = this.getContentMarginLeft();
        Float other$contentMarginLeft = other.getContentMarginLeft();
        if (this$contentMarginLeft == null ? other$contentMarginLeft != null : !((Object)this$contentMarginLeft).equals(other$contentMarginLeft)) {
            return false;
        }
        Float this$contentMarginRight = this.getContentMarginRight();
        Float other$contentMarginRight = other.getContentMarginRight();
        if (this$contentMarginRight == null ? other$contentMarginRight != null : !((Object)this$contentMarginRight).equals(other$contentMarginRight)) {
            return false;
        }
        Boolean this$isEnableUpLine = this.getIsEnableUpLine();
        Boolean other$isEnableUpLine = other.getIsEnableUpLine();
        if (this$isEnableUpLine == null ? other$isEnableUpLine != null : !((Object)this$isEnableUpLine).equals(other$isEnableUpLine)) {
            return false;
        }
        Boolean this$isEnableDownLine = this.getIsEnableDownLine();
        Boolean other$isEnableDownLine = other.getIsEnableDownLine();
        if (this$isEnableDownLine == null ? other$isEnableDownLine != null : !((Object)this$isEnableDownLine).equals(other$isEnableDownLine)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        TableRow this$row = this.getRow();
        TableRow other$row = other.getRow();
        if (this$row == null ? other$row != null : !((Object)this$row).equals(other$row)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableCell;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $rowspan = this.getRowspan();
        result = result * 59 + ($rowspan == null ? 43 : ((Object)$rowspan).hashCode());
        Integer $colspan = this.getColspan();
        result = result * 59 + ($colspan == null ? 43 : ((Object)$colspan).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Float $contentMarginTop = this.getContentMarginTop();
        result = result * 59 + ($contentMarginTop == null ? 43 : ((Object)$contentMarginTop).hashCode());
        Float $contentMarginBottom = this.getContentMarginBottom();
        result = result * 59 + ($contentMarginBottom == null ? 43 : ((Object)$contentMarginBottom).hashCode());
        Float $contentMarginLeft = this.getContentMarginLeft();
        result = result * 59 + ($contentMarginLeft == null ? 43 : ((Object)$contentMarginLeft).hashCode());
        Float $contentMarginRight = this.getContentMarginRight();
        result = result * 59 + ($contentMarginRight == null ? 43 : ((Object)$contentMarginRight).hashCode());
        Boolean $isEnableUpLine = this.getIsEnableUpLine();
        result = result * 59 + ($isEnableUpLine == null ? 43 : ((Object)$isEnableUpLine).hashCode());
        Boolean $isEnableDownLine = this.getIsEnableDownLine();
        result = result * 59 + ($isEnableDownLine == null ? 43 : ((Object)$isEnableDownLine).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        TableRow $row = this.getRow();
        result = result * 59 + ($row == null ? 43 : ((Object)$row).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

