/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.core.enums.LineStyle;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class Line
extends AbstractComponent {
    protected LineStyle lineStyle;
    protected LineCapStyle lineCapStyle;
    protected Float lineLength;
    protected Float lineWidth;
    protected Color lineColor;
    protected Float dottedLength;
    protected Float dottedSpacing;
    protected Float angle;
    protected Float alpha;

    public Line(Page page) {
        super(page);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.LINE;
    }

    @Override
    protected void init() {
        super.init();
        if (Objects.isNull((Object)this.lineStyle)) {
            this.lineStyle = LineStyle.SOLID;
        }
        if (Objects.isNull((Object)this.lineCapStyle)) {
            this.lineCapStyle = LineCapStyle.NORMAL;
        }
        if (Objects.isNull(this.lineLength)) {
            this.lineLength = Float.valueOf(this.getContext().getWrapWidth().floatValue() - this.getMarginLeft().floatValue() - this.getMarginRight().floatValue());
        }
        if (Objects.isNull(this.lineWidth)) {
            this.lineWidth = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.lineColor)) {
            this.lineColor = Color.BLACK;
        }
        if (Objects.isNull(this.dottedLength)) {
            this.dottedLength = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.dottedSpacing)) {
            this.dottedSpacing = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.alpha)) {
            this.alpha = Float.valueOf(1.0f);
        }
        this.initBeginXY(this.getLineLength().floatValue(), this.getLineWidth().floatValue());
    }

    @Override
    protected float getMinWidth() {
        return this.getLineLength().floatValue();
    }

    @Override
    protected void writeContents() {
        PDPageContentStream stream = this.initContentStream();
        CommonUtil.initMatrix(stream, this.getBeginX().floatValue(), this.getBeginY().floatValue(), this.getRelativeBeginX().floatValue(), this.getRelativeBeginY().floatValue(), this.getLineLength().floatValue(), this.getLineWidth().floatValue(), this.getAngle().floatValue(), this.getAlpha().floatValue());
        float beginX = 0.0f;
        float beginY = 0.0f;
        float endX = this.getLineLength().floatValue();
        float endY = 0.0f;
        switch (this.getLineStyle()) {
            case SOLID: {
                BorderUtil.drawSolidLine(stream, this.getLineColor(), beginX, beginY, endX, endY);
                break;
            }
            case DOTTED: {
                BorderUtil.drawDottedLine(stream, this.getLineColor(), this.getDottedLength().floatValue(), this.getDottedSpacing().floatValue(), beginX, beginY, endX, endY);
            }
        }
        stream.stroke();
        stream.close();
    }

    @Override
    protected void reset() {
        float x = this.getBeginX().floatValue() + this.getLineLength().floatValue() + this.getMarginRight().floatValue();
        float y = this.getBeginY().floatValue();
        super.reset(this.getType(), x, y);
    }

    protected PDPageContentStream initContentStream() {
        PDPageContentStream stream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream());
        stream.setLineWidth(this.getLineWidth().floatValue());
        stream.setStrokingColor(this.getLineColor());
        stream.setLineCapStyle(this.getLineCapStyle().getType());
        return stream;
    }

    @Generated
    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Generated
    public LineCapStyle getLineCapStyle() {
        return this.lineCapStyle;
    }

    @Generated
    public Float getLineLength() {
        return this.lineLength;
    }

    @Generated
    public Float getLineWidth() {
        return this.lineWidth;
    }

    @Generated
    public Color getLineColor() {
        return this.lineColor;
    }

    @Generated
    public Float getDottedLength() {
        return this.dottedLength;
    }

    @Generated
    public Float getDottedSpacing() {
        return this.dottedSpacing;
    }

    @Generated
    public Float getAngle() {
        return this.angle;
    }

    @Generated
    public Float getAlpha() {
        return this.alpha;
    }

    @Generated
    public void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Generated
    public void setLineCapStyle(LineCapStyle lineCapStyle) {
        this.lineCapStyle = lineCapStyle;
    }

    @Generated
    public void setLineLength(Float lineLength) {
        this.lineLength = lineLength;
    }

    @Generated
    public void setLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Generated
    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    @Generated
    public void setDottedLength(Float dottedLength) {
        this.dottedLength = dottedLength;
    }

    @Generated
    public void setDottedSpacing(Float dottedSpacing) {
        this.dottedSpacing = dottedSpacing;
    }

    @Generated
    public void setAngle(Float angle) {
        this.angle = angle;
    }

    @Generated
    public void setAlpha(Float alpha) {
        this.alpha = alpha;
    }

    @Override
    @Generated
    public String toString() {
        return "Line(lineStyle=" + (Object)((Object)this.getLineStyle()) + ", lineCapStyle=" + (Object)((Object)this.getLineCapStyle()) + ", lineLength=" + this.getLineLength() + ", lineWidth=" + this.getLineWidth() + ", lineColor=" + this.getLineColor() + ", dottedLength=" + this.getDottedLength() + ", dottedSpacing=" + this.getDottedSpacing() + ", angle=" + this.getAngle() + ", alpha=" + this.getAlpha() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Line)) {
            return false;
        }
        Line other = (Line)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$lineLength = this.getLineLength();
        Float other$lineLength = other.getLineLength();
        if (this$lineLength == null ? other$lineLength != null : !((Object)this$lineLength).equals(other$lineLength)) {
            return false;
        }
        Float this$lineWidth = this.getLineWidth();
        Float other$lineWidth = other.getLineWidth();
        if (this$lineWidth == null ? other$lineWidth != null : !((Object)this$lineWidth).equals(other$lineWidth)) {
            return false;
        }
        Float this$dottedLength = this.getDottedLength();
        Float other$dottedLength = other.getDottedLength();
        if (this$dottedLength == null ? other$dottedLength != null : !((Object)this$dottedLength).equals(other$dottedLength)) {
            return false;
        }
        Float this$dottedSpacing = this.getDottedSpacing();
        Float other$dottedSpacing = other.getDottedSpacing();
        if (this$dottedSpacing == null ? other$dottedSpacing != null : !((Object)this$dottedSpacing).equals(other$dottedSpacing)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        LineStyle this$lineStyle = this.getLineStyle();
        LineStyle other$lineStyle = other.getLineStyle();
        if (this$lineStyle == null ? other$lineStyle != null : !((Object)((Object)this$lineStyle)).equals((Object)other$lineStyle)) {
            return false;
        }
        LineCapStyle this$lineCapStyle = this.getLineCapStyle();
        LineCapStyle other$lineCapStyle = other.getLineCapStyle();
        if (this$lineCapStyle == null ? other$lineCapStyle != null : !((Object)((Object)this$lineCapStyle)).equals((Object)other$lineCapStyle)) {
            return false;
        }
        Color this$lineColor = this.getLineColor();
        Color other$lineColor = other.getLineColor();
        return !(this$lineColor == null ? other$lineColor != null : !((Object)this$lineColor).equals(other$lineColor));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Line;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $lineLength = this.getLineLength();
        result = result * 59 + ($lineLength == null ? 43 : ((Object)$lineLength).hashCode());
        Float $lineWidth = this.getLineWidth();
        result = result * 59 + ($lineWidth == null ? 43 : ((Object)$lineWidth).hashCode());
        Float $dottedLength = this.getDottedLength();
        result = result * 59 + ($dottedLength == null ? 43 : ((Object)$dottedLength).hashCode());
        Float $dottedSpacing = this.getDottedSpacing();
        result = result * 59 + ($dottedSpacing == null ? 43 : ((Object)$dottedSpacing).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        LineStyle $lineStyle = this.getLineStyle();
        result = result * 59 + ($lineStyle == null ? 43 : ((Object)((Object)$lineStyle)).hashCode());
        LineCapStyle $lineCapStyle = this.getLineCapStyle();
        result = result * 59 + ($lineCapStyle == null ? 43 : ((Object)((Object)$lineCapStyle)).hashCode());
        Color $lineColor = this.getLineColor();
        result = result * 59 + ($lineColor == null ? 43 : ((Object)$lineColor).hashCode());
        return result;
    }
}

