/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.support.Constants;

public class Circle
extends AbstractComponent {
    protected Float radius;
    protected Color borderColor;
    protected Color backgroundColor;

    public Circle(Page page) {
        super(page);
    }

    public void setRadius(float radius) {
        if (radius < 1.0f) {
            throw new IllegalArgumentException("the radius can not be less than 1");
        }
        this.radius = Float.valueOf(radius);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.CIRCLE;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.radius, "the radius can not be null");
        super.init();
        if (Objects.isNull(this.borderColor)) {
            this.borderColor = Color.BLACK;
        }
        if (Objects.isNull(this.backgroundColor)) {
            this.backgroundColor = this.getPage().getBackgroundColor();
        }
        float diameter = this.getRadius().floatValue() * 2.0f;
        this.initBeginXY(diameter, diameter);
    }

    @Override
    protected void initBeginX(float width) {
        if (width == 0.0f) {
            return;
        }
        float radius = width / 2.0f;
        switch (this.getHorizontalAlignment()) {
            case CENTER: {
                float offset = (this.getContext().getWrapWidth().floatValue() - width) / 2.0f + radius;
                this.setBeginX(Float.valueOf(this.getBeginX().floatValue() + offset), this.getIsCustomX());
                break;
            }
            case RIGHT: {
                float offset = this.getContext().getWrapWidth().floatValue() - radius - this.getMarginRight().floatValue();
                this.setBeginX(Float.valueOf(Math.min(this.getBeginX().floatValue() + offset, this.getContext().getMaxBeginX() - radius)), this.getIsCustomX());
                break;
            }
        }
    }

    @Override
    protected void initBeginY(float height) {
        if (height == 0.0f) {
            return;
        }
        float radius = height / 2.0f;
        float offset = 0.0f;
        switch (this.getVerticalAlignment()) {
            case CENTER: {
                offset = (this.getContext().getHeight().floatValue() - height) / 2.0f - radius;
                break;
            }
            case BOTTOM: {
                offset = this.getContext().getHeight().floatValue() - height - radius - this.getMarginBottom().floatValue();
                break;
            }
        }
        this.setBeginY(Float.valueOf(this.getBeginY(this.getPage(), this.getBeginY().floatValue() - offset)), this.getIsCustomY());
    }

    @Override
    protected float getMinWidth() {
        return this.getRadius().floatValue();
    }

    @Override
    protected void writeContents() {
        if (!this.getContext().getIsVirtualRender().booleanValue()) {
            PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream());
            contentStream.setNonStrokingColor(this.getBackgroundColor());
            contentStream.setStrokingColor(this.getBorderColor());
            this.renderCircle(contentStream, this.getRadius().floatValue());
            contentStream.close();
        }
    }

    protected void renderCircle(PDPageContentStream contentStream, float radius) {
        float offset = radius * Constants.BEZIER_COEF.floatValue();
        float beginX = this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue();
        float beginY = this.getBeginY().floatValue() + this.getRelativeBeginX().floatValue();
        contentStream.moveTo(beginX, beginY + radius);
        contentStream.curveTo(beginX + offset, beginY + radius, beginX + radius, beginY + offset, beginX + radius, beginY);
        contentStream.curveTo(beginX + radius, beginY - offset, beginX + offset, beginY - radius, beginX, beginY - radius);
        contentStream.curveTo(beginX - offset, beginY - radius, beginX - radius, beginY - offset, beginX - radius, beginY);
        contentStream.curveTo(beginX - radius, beginY + offset, beginX - offset, beginY + radius, beginX, beginY + radius);
        contentStream.fillAndStroke();
    }

    @Override
    protected void reset() {
        float x = this.getBeginX().floatValue() + this.getMinWidth() + this.getMarginRight().floatValue();
        float y = this.getBeginY().floatValue();
        super.reset(this.getType(), x, y);
    }

    @Generated
    public Float getRadius() {
        return this.radius;
    }

    @Generated
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    @Generated
    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Generated
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    @Generated
    public String toString() {
        return "Circle(radius=" + this.getRadius() + ", borderColor=" + this.getBorderColor() + ", backgroundColor=" + this.getBackgroundColor() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Circle other = (Circle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$radius = this.getRadius();
        Float other$radius = other.getRadius();
        if (this$radius == null ? other$radius != null : !((Object)this$radius).equals(other$radius)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        return !(this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Circle;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $radius = this.getRadius();
        result = result * 59 + ($radius == null ? 43 : ((Object)$radius).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        return result;
    }
}

