/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.BarcodeErrorLevel;
import org.dromara.pdf.pdfbox.core.enums.BarcodeType;
import org.dromara.pdf.pdfbox.core.enums.BarcodeWordsStyle;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.handler.FontHandler;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class Barcode
extends AbstractComponent {
    protected static final Map<Integer, BufferedImage> CACHE = new HashMap<Integer, BufferedImage>(16);
    protected static final ReentrantLock LOCK = new ReentrantLock();
    protected Map<EncodeHintType, Object> encodeHints = new HashMap<EncodeHintType, Object>(8);
    protected Integer width;
    protected Integer height;
    protected Integer imageWidth;
    protected Integer imageHeight;
    protected BarcodeType codeType;
    protected Color onColor;
    protected Color offColor;
    protected String content;
    protected String words;
    protected String wordsFontName;
    protected Color wordsColor;
    protected BarcodeWordsStyle wordsStyle;
    protected Integer wordsSize;
    protected Integer wordsOffsetX;
    protected Integer wordsOffsetY;
    protected Float angle;
    protected Float alpha;
    protected Boolean isShowWords;
    protected Boolean isNoWhiteBorder;
    protected Boolean isCache;

    public Barcode(Page page) {
        super(page);
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("the width can not be less than 1");
        }
        this.width = width;
    }

    public void setHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("the height can not be less than 1");
        }
        this.height = height;
    }

    public void setImageWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("the image width can not be less than 1");
        }
        this.imageWidth = width;
    }

    public void setImageHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("the image height can not be less than 1");
        }
        this.imageHeight = height;
    }

    public void setCodeMargin(int margin) {
        if (margin < 0) {
            throw new IllegalArgumentException("the code margin can not be less than 0");
        }
        this.encodeHints.put(EncodeHintType.MARGIN, margin);
    }

    public void setErrorLevel(BarcodeErrorLevel level) {
        if (Objects.nonNull((Object)level)) {
            this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, level.getLevel());
        }
    }

    public void setQrVersion(int version) {
        boolean min = false;
        int max = 41;
        if (version <= 0 || version >= 41) {
            throw new IllegalArgumentException("the version must be between 1 and 40");
        }
        this.encodeHints.put(EncodeHintType.QR_VERSION, version);
    }

    public void setQrMaskPattern(int pattern) {
        if (!QRCode.isValidMaskPattern((int)pattern)) {
            throw new IllegalArgumentException("the qr mask pattern must be between 0 and 7");
        }
        this.encodeHints.put(EncodeHintType.QR_MASK_PATTERN, pattern);
    }

    public void setQrCompact(boolean isCompact) {
        this.encodeHints.put(EncodeHintType.QR_COMPACT, isCompact);
    }

    public void setEncodeHints(EncodeHintType type, Object value) {
        this.encodeHints.put(type, value);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.BARCODE;
    }

    @Override
    protected float getMinWidth() {
        return this.getWidth().intValue();
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.codeType, "the code type can not be null");
        Objects.requireNonNull(this.content, "the content can not be null");
        super.init();
        this.initWidthAndHeight();
        this.initErrorLevel();
        if (Objects.isNull(this.onColor)) {
            this.onColor = Color.BLACK;
        }
        if (Objects.isNull(this.offColor)) {
            this.offColor = this.getPage().getBackgroundColor();
        }
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.alpha)) {
            this.alpha = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.isShowWords)) {
            this.isShowWords = Boolean.FALSE;
        }
        if (Objects.isNull(this.isNoWhiteBorder)) {
            this.isNoWhiteBorder = Boolean.FALSE;
        }
        if (Objects.isNull(this.isCache)) {
            this.isCache = Boolean.FALSE;
        }
        this.initBeginXY(this.width.intValue(), this.height.intValue());
    }

    protected void initWidthAndHeight() {
        if (Objects.isNull(this.width)) {
            this.width = this.imageWidth;
            Objects.requireNonNull(this.width, "the width or image width can not be null");
        }
        if (Objects.isNull(this.height)) {
            this.height = this.imageHeight;
            Objects.requireNonNull(this.height, "the height or image height can not be null");
        }
        if (Objects.isNull(this.imageWidth)) {
            this.imageWidth = this.width;
        }
        if (Objects.isNull(this.imageHeight)) {
            this.imageHeight = this.height;
        }
    }

    protected void initErrorLevel() {
        this.encodeHints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
        Object errorLevel = this.encodeHints.get(EncodeHintType.ERROR_CORRECTION);
        if (Objects.isNull(errorLevel)) {
            if (BarcodeFormat.AZTEC == this.codeType.getCodeFormat() || BarcodeFormat.PDF_417 == this.codeType.getCodeFormat()) {
                this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M.getBits());
            } else {
                this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            }
        } else {
            ErrorCorrectionLevel level = (ErrorCorrectionLevel)errorLevel;
            if (BarcodeFormat.AZTEC == this.codeType.getCodeFormat() || BarcodeFormat.PDF_417 == this.codeType.getCodeFormat()) {
                this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, level.getBits());
            }
        }
    }

    @Override
    protected void writeContents() {
        if (!this.getContext().getIsVirtualRender().booleanValue()) {
            PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream());
            CommonUtil.initMatrix(contentStream, this.getBeginX().floatValue(), this.getBeginY().floatValue(), this.getRelativeBeginX().floatValue(), this.getRelativeBeginY().floatValue(), this.getWidth().intValue(), this.getHeight().intValue(), this.getAngle().floatValue(), this.getAlpha().floatValue());
            contentStream.drawImage(this.getImageXObject(), 0.0f, 0.0f, (float)this.getWidth().intValue(), (float)this.getHeight().intValue());
            BorderUtil.drawNormalBorder(contentStream, CommonUtil.getRectangle(this.getWidth().intValue(), this.getHeight().intValue()), BorderData.create(this, this.getBorderConfiguration()), this.getPage().getBackgroundColor());
            contentStream.stroke();
            contentStream.close();
        }
    }

    @Override
    protected void reset() {
        float x = this.getBeginX().floatValue() + (float)this.getWidth().intValue() + this.getMarginRight().floatValue();
        float y = this.getBeginY().floatValue();
        super.reset(this.getType(), x, y);
    }

    protected PDImageXObject getImageXObject() {
        return PDImageXObject.createFromByteArray((PDDocument)this.getContext().getTargetDocument(), (byte[])ImageUtil.toBytes(this.getBarcodeImage(), ImageType.PNG.getType()), (String)ImageType.PNG.getType());
    }

    public BufferedImage getBarcodeImage() {
        if (Optional.ofNullable(this.getIsCache()).orElse(Boolean.FALSE).booleanValue()) {
            BufferedImage bufferedImage = CACHE.get(this.cacheKey());
            if (Objects.isNull(bufferedImage)) {
                try {
                    LOCK.lock();
                    bufferedImage = CACHE.get(this.cacheKey());
                    if (Objects.isNull(bufferedImage)) {
                        bufferedImage = this.createBarcodeImage();
                        CACHE.put(this.cacheKey(), bufferedImage);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Added barcode image cache key: " + this.cacheKey()));
                        }
                    }
                }
                finally {
                    LOCK.unlock();
                }
            }
            return bufferedImage;
        }
        return this.createBarcodeImage();
    }

    protected BufferedImage createBarcodeImage() {
        this.initWidthAndHeight();
        BufferedImage bufferedImage = this.toBufferedImage(new MultiFormatWriter().encode(this.getContent(), this.getCodeType().getCodeFormat(), this.getImageWidth().intValue(), this.getImageHeight().intValue(), this.getEncodeHints()));
        if (Optional.ofNullable(this.getIsShowWords()).orElse(Boolean.FALSE).booleanValue()) {
            bufferedImage = this.addImageWords(bufferedImage);
        }
        return bufferedImage;
    }

    protected BufferedImage toBufferedImage(BitMatrix matrix) {
        if (Optional.ofNullable(this.getIsNoWhiteBorder()).orElse(Boolean.FALSE).booleanValue()) {
            matrix = this.removeWhiteBorder(matrix);
        }
        int onColor = Optional.ofNullable(this.getOnColor()).orElse(Color.BLACK).getRGB();
        int offColor = Optional.ofNullable(this.getOffColor()).orElse(this.getPage().getBackgroundColor()).getRGB();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] rowPixels = new int[width];
        BitArray row = new BitArray(width);
        for (int y = 0; y < height; ++y) {
            row = matrix.getRow(y, row);
            for (int x = 0; x < width; ++x) {
                rowPixels[x] = row.get(x) ? onColor : offColor;
            }
            image.setRGB(0, y, width, 1, rowPixels, 0, width);
        }
        return image;
    }

    protected BitMatrix removeWhiteBorder(BitMatrix matrix) {
        int[] rectangle = matrix.getEnclosingRectangle();
        int width = rectangle[2] + 1;
        int height = rectangle[3] + 1;
        BitMatrix bitMatrix = new BitMatrix(width, height);
        bitMatrix.clear();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (!matrix.get(i + rectangle[0], j + rectangle[1])) continue;
                bitMatrix.set(i, j);
            }
        }
        return bitMatrix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BufferedImage addImageWords(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        String words = Optional.ofNullable(this.getWords()).orElse(this.getContent());
        String wordsFontName = Optional.ofNullable(this.getWordsFontName()).orElse(this.getPage().getFontName());
        Color wordsColor = Optional.ofNullable(this.getWordsColor()).orElse(Color.BLACK);
        int wordsSize = Optional.ofNullable(this.getWordsSize()).orElse(10);
        int wordsStyle = Optional.ofNullable(this.getWordsStyle()).orElse(BarcodeWordsStyle.NORMAL).getStyle();
        int wordsOffsetX = Optional.ofNullable(this.getWordsOffsetX()).orElse(0);
        int wordsOffsetY = Optional.ofNullable(this.getWordsOffsetY()).orElse(0);
        int totalHeight = height + wordsSize;
        try (InputStream inputStream = FontHandler.getInstance().getTrueTypeFont(wordsFontName).getOriginalData();){
            BufferedImage out = new BufferedImage(width, totalHeight, 1);
            Graphics2D graphics = ImageUtil.createGraphics(out);
            graphics.fillRect(0, 0, width, totalHeight);
            graphics.setColor(wordsColor);
            graphics.drawImage(image, 0, 0, width, height, null);
            graphics.setFont(Font.createFont(0, inputStream).deriveFont(wordsStyle, wordsSize));
            int strWidth = graphics.getFontMetrics().stringWidth(words);
            int beginX = (width - strWidth) / 2 + wordsOffsetX;
            int beginY = height + wordsOffsetY;
            graphics.drawString(words, beginX, beginY);
            graphics.dispose();
            image.flush();
            BufferedImage bufferedImage = out;
            return bufferedImage;
        }
    }

    protected int cacheKey() {
        return Objects.hash(new Object[]{this.encodeHints, this.width, this.height, this.imageWidth, this.imageHeight, this.codeType, this.onColor, this.offColor, this.content, this.words, this.wordsFontName, this.wordsColor, this.wordsStyle, this.wordsSize, this.wordsOffsetX, this.wordsOffsetY, this.isShowWords, this.isNoWhiteBorder});
    }

    @Generated
    public Map<EncodeHintType, Object> getEncodeHints() {
        return this.encodeHints;
    }

    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @Generated
    public Integer getHeight() {
        return this.height;
    }

    @Generated
    public Integer getImageWidth() {
        return this.imageWidth;
    }

    @Generated
    public Integer getImageHeight() {
        return this.imageHeight;
    }

    @Generated
    public BarcodeType getCodeType() {
        return this.codeType;
    }

    @Generated
    public Color getOnColor() {
        return this.onColor;
    }

    @Generated
    public Color getOffColor() {
        return this.offColor;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getWords() {
        return this.words;
    }

    @Generated
    public String getWordsFontName() {
        return this.wordsFontName;
    }

    @Generated
    public Color getWordsColor() {
        return this.wordsColor;
    }

    @Generated
    public BarcodeWordsStyle getWordsStyle() {
        return this.wordsStyle;
    }

    @Generated
    public Integer getWordsSize() {
        return this.wordsSize;
    }

    @Generated
    public Integer getWordsOffsetX() {
        return this.wordsOffsetX;
    }

    @Generated
    public Integer getWordsOffsetY() {
        return this.wordsOffsetY;
    }

    @Generated
    public Float getAngle() {
        return this.angle;
    }

    @Generated
    public Float getAlpha() {
        return this.alpha;
    }

    @Generated
    public Boolean getIsShowWords() {
        return this.isShowWords;
    }

    @Generated
    public Boolean getIsNoWhiteBorder() {
        return this.isNoWhiteBorder;
    }

    @Generated
    public Boolean getIsCache() {
        return this.isCache;
    }

    @Generated
    public void setEncodeHints(Map<EncodeHintType, Object> encodeHints) {
        this.encodeHints = encodeHints;
    }

    @Generated
    public void setCodeType(BarcodeType codeType) {
        this.codeType = codeType;
    }

    @Generated
    public void setOnColor(Color onColor) {
        this.onColor = onColor;
    }

    @Generated
    public void setOffColor(Color offColor) {
        this.offColor = offColor;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setWords(String words) {
        this.words = words;
    }

    @Generated
    public void setWordsFontName(String wordsFontName) {
        this.wordsFontName = wordsFontName;
    }

    @Generated
    public void setWordsColor(Color wordsColor) {
        this.wordsColor = wordsColor;
    }

    @Generated
    public void setWordsStyle(BarcodeWordsStyle wordsStyle) {
        this.wordsStyle = wordsStyle;
    }

    @Generated
    public void setWordsSize(Integer wordsSize) {
        this.wordsSize = wordsSize;
    }

    @Generated
    public void setWordsOffsetX(Integer wordsOffsetX) {
        this.wordsOffsetX = wordsOffsetX;
    }

    @Generated
    public void setWordsOffsetY(Integer wordsOffsetY) {
        this.wordsOffsetY = wordsOffsetY;
    }

    @Generated
    public void setAngle(Float angle) {
        this.angle = angle;
    }

    @Generated
    public void setAlpha(Float alpha) {
        this.alpha = alpha;
    }

    @Generated
    public void setIsShowWords(Boolean isShowWords) {
        this.isShowWords = isShowWords;
    }

    @Generated
    public void setIsNoWhiteBorder(Boolean isNoWhiteBorder) {
        this.isNoWhiteBorder = isNoWhiteBorder;
    }

    @Generated
    public void setIsCache(Boolean isCache) {
        this.isCache = isCache;
    }

    @Override
    @Generated
    public String toString() {
        return "Barcode(encodeHints=" + this.getEncodeHints() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", imageWidth=" + this.getImageWidth() + ", imageHeight=" + this.getImageHeight() + ", codeType=" + (Object)((Object)this.getCodeType()) + ", onColor=" + this.getOnColor() + ", offColor=" + this.getOffColor() + ", content=" + this.getContent() + ", words=" + this.getWords() + ", wordsFontName=" + this.getWordsFontName() + ", wordsColor=" + this.getWordsColor() + ", wordsStyle=" + (Object)((Object)this.getWordsStyle()) + ", wordsSize=" + this.getWordsSize() + ", wordsOffsetX=" + this.getWordsOffsetX() + ", wordsOffsetY=" + this.getWordsOffsetY() + ", angle=" + this.getAngle() + ", alpha=" + this.getAlpha() + ", isShowWords=" + this.getIsShowWords() + ", isNoWhiteBorder=" + this.getIsNoWhiteBorder() + ", isCache=" + this.getIsCache() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Barcode)) {
            return false;
        }
        Barcode other = (Barcode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$imageWidth = this.getImageWidth();
        Integer other$imageWidth = other.getImageWidth();
        if (this$imageWidth == null ? other$imageWidth != null : !((Object)this$imageWidth).equals(other$imageWidth)) {
            return false;
        }
        Integer this$imageHeight = this.getImageHeight();
        Integer other$imageHeight = other.getImageHeight();
        if (this$imageHeight == null ? other$imageHeight != null : !((Object)this$imageHeight).equals(other$imageHeight)) {
            return false;
        }
        Integer this$wordsSize = this.getWordsSize();
        Integer other$wordsSize = other.getWordsSize();
        if (this$wordsSize == null ? other$wordsSize != null : !((Object)this$wordsSize).equals(other$wordsSize)) {
            return false;
        }
        Integer this$wordsOffsetX = this.getWordsOffsetX();
        Integer other$wordsOffsetX = other.getWordsOffsetX();
        if (this$wordsOffsetX == null ? other$wordsOffsetX != null : !((Object)this$wordsOffsetX).equals(other$wordsOffsetX)) {
            return false;
        }
        Integer this$wordsOffsetY = this.getWordsOffsetY();
        Integer other$wordsOffsetY = other.getWordsOffsetY();
        if (this$wordsOffsetY == null ? other$wordsOffsetY != null : !((Object)this$wordsOffsetY).equals(other$wordsOffsetY)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        Boolean this$isShowWords = this.getIsShowWords();
        Boolean other$isShowWords = other.getIsShowWords();
        if (this$isShowWords == null ? other$isShowWords != null : !((Object)this$isShowWords).equals(other$isShowWords)) {
            return false;
        }
        Boolean this$isNoWhiteBorder = this.getIsNoWhiteBorder();
        Boolean other$isNoWhiteBorder = other.getIsNoWhiteBorder();
        if (this$isNoWhiteBorder == null ? other$isNoWhiteBorder != null : !((Object)this$isNoWhiteBorder).equals(other$isNoWhiteBorder)) {
            return false;
        }
        Boolean this$isCache = this.getIsCache();
        Boolean other$isCache = other.getIsCache();
        if (this$isCache == null ? other$isCache != null : !((Object)this$isCache).equals(other$isCache)) {
            return false;
        }
        Map<EncodeHintType, Object> this$encodeHints = this.getEncodeHints();
        Map<EncodeHintType, Object> other$encodeHints = other.getEncodeHints();
        if (this$encodeHints == null ? other$encodeHints != null : !((Object)this$encodeHints).equals(other$encodeHints)) {
            return false;
        }
        BarcodeType this$codeType = this.getCodeType();
        BarcodeType other$codeType = other.getCodeType();
        if (this$codeType == null ? other$codeType != null : !((Object)((Object)this$codeType)).equals((Object)other$codeType)) {
            return false;
        }
        Color this$onColor = this.getOnColor();
        Color other$onColor = other.getOnColor();
        if (this$onColor == null ? other$onColor != null : !((Object)this$onColor).equals(other$onColor)) {
            return false;
        }
        Color this$offColor = this.getOffColor();
        Color other$offColor = other.getOffColor();
        if (this$offColor == null ? other$offColor != null : !((Object)this$offColor).equals(other$offColor)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$words = this.getWords();
        String other$words = other.getWords();
        if (this$words == null ? other$words != null : !this$words.equals(other$words)) {
            return false;
        }
        String this$wordsFontName = this.getWordsFontName();
        String other$wordsFontName = other.getWordsFontName();
        if (this$wordsFontName == null ? other$wordsFontName != null : !this$wordsFontName.equals(other$wordsFontName)) {
            return false;
        }
        Color this$wordsColor = this.getWordsColor();
        Color other$wordsColor = other.getWordsColor();
        if (this$wordsColor == null ? other$wordsColor != null : !((Object)this$wordsColor).equals(other$wordsColor)) {
            return false;
        }
        BarcodeWordsStyle this$wordsStyle = this.getWordsStyle();
        BarcodeWordsStyle other$wordsStyle = other.getWordsStyle();
        return !(this$wordsStyle == null ? other$wordsStyle != null : !((Object)((Object)this$wordsStyle)).equals((Object)other$wordsStyle));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Barcode;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $imageWidth = this.getImageWidth();
        result = result * 59 + ($imageWidth == null ? 43 : ((Object)$imageWidth).hashCode());
        Integer $imageHeight = this.getImageHeight();
        result = result * 59 + ($imageHeight == null ? 43 : ((Object)$imageHeight).hashCode());
        Integer $wordsSize = this.getWordsSize();
        result = result * 59 + ($wordsSize == null ? 43 : ((Object)$wordsSize).hashCode());
        Integer $wordsOffsetX = this.getWordsOffsetX();
        result = result * 59 + ($wordsOffsetX == null ? 43 : ((Object)$wordsOffsetX).hashCode());
        Integer $wordsOffsetY = this.getWordsOffsetY();
        result = result * 59 + ($wordsOffsetY == null ? 43 : ((Object)$wordsOffsetY).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        Boolean $isShowWords = this.getIsShowWords();
        result = result * 59 + ($isShowWords == null ? 43 : ((Object)$isShowWords).hashCode());
        Boolean $isNoWhiteBorder = this.getIsNoWhiteBorder();
        result = result * 59 + ($isNoWhiteBorder == null ? 43 : ((Object)$isNoWhiteBorder).hashCode());
        Boolean $isCache = this.getIsCache();
        result = result * 59 + ($isCache == null ? 43 : ((Object)$isCache).hashCode());
        Map<EncodeHintType, Object> $encodeHints = this.getEncodeHints();
        result = result * 59 + ($encodeHints == null ? 43 : ((Object)$encodeHints).hashCode());
        BarcodeType $codeType = this.getCodeType();
        result = result * 59 + ($codeType == null ? 43 : ((Object)((Object)$codeType)).hashCode());
        Color $onColor = this.getOnColor();
        result = result * 59 + ($onColor == null ? 43 : ((Object)$onColor).hashCode());
        Color $offColor = this.getOffColor();
        result = result * 59 + ($offColor == null ? 43 : ((Object)$offColor).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $words = this.getWords();
        result = result * 59 + ($words == null ? 43 : $words.hashCode());
        String $wordsFontName = this.getWordsFontName();
        result = result * 59 + ($wordsFontName == null ? 43 : $wordsFontName.hashCode());
        Color $wordsColor = this.getWordsColor();
        result = result * 59 + ($wordsColor == null ? 43 : ((Object)$wordsColor).hashCode());
        BarcodeWordsStyle $wordsStyle = this.getWordsStyle();
        result = result * 59 + ($wordsStyle == null ? 43 : ((Object)((Object)$wordsStyle)).hashCode());
        return result;
    }
}

