/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Cursor;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.base.config.MarginConfiguration;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.enums.RotationAngle;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.util.IdUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class Page
extends AbstractBase
implements Closeable {
    protected MarginConfiguration marginConfiguration;
    protected FontConfiguration fontConfiguration;
    protected Color backgroundColor;
    protected BufferedImage backgroundImage;
    protected String id;
    protected Integer index;
    protected PDPage target;
    protected PageSize pageSize;
    protected Page parentPage;
    protected Page subPage;
    protected HorizontalAlignment horizontalAlignment;
    protected VerticalAlignment verticalAlignment;
    protected Boolean isContentBorder;

    public Page(Document document) {
        this(document, new PDPage(PageSize.A4.getSize()));
    }

    public Page(Document document, PageSize pageSize) {
        if (Objects.isNull(pageSize)) {
            pageSize = PageSize.A4;
        }
        this.init(new PDPage(pageSize.getSize()), document, document.getMarginConfiguration(), document.getFontConfiguration(), document.getBackgroundColor(), document.getBackgroundImage());
    }

    public Page(Document document, PDPage target) {
        this.init(target, document, document.getMarginConfiguration(), document.getFontConfiguration(), document.getBackgroundColor(), document.getBackgroundImage());
    }

    protected Page(Page page) {
        this.init(new PDPage(page.getPageSize().getSize()), page, page.getMarginConfiguration(), page.getFontConfiguration(), page.getBackgroundColor(), page.getBackgroundImage());
        this.setIsContentBorder(page.getIsContentBorder());
        this.parentPage = page;
        page.setSubPage(this);
    }

    public void setMargin(float margin) {
        this.setMarginTop(margin);
        this.setMarginBottom(margin);
        this.setMarginLeft(margin);
        this.setMarginRight(margin);
        this.getContext().resetWrapWidth(null);
        this.getContext().resetHeight(null);
    }

    public void setBackgroundColor(Color color) {
        if (!Objects.equals(this.backgroundColor, color)) {
            this.backgroundColor = color;
            this.initBackgroundColor();
        }
    }

    public void setBackgroundImage(BufferedImage image) {
        this.backgroundImage = image;
        if (Objects.nonNull(image)) {
            this.initBackgroundImage();
        }
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        Objects.requireNonNull(horizontalAlignment, "the horizontal alignment can not be null");
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        Objects.requireNonNull(verticalAlignment, "the vertical alignment can not be null");
        this.verticalAlignment = verticalAlignment;
    }

    public void setIsContentBorder(boolean isContentBorder) {
        this.isContentBorder = isContentBorder;
        if (this.isContentBorder.booleanValue()) {
            this.initContentBorder();
        }
    }

    public PDFont getFont() {
        return this.getContext().getFont(this.fontConfiguration.getFontName());
    }

    public Float getMarginTop() {
        return this.marginConfiguration.getMarginTop();
    }

    public void setMarginTop(float margin) {
        Float height = this.getContext().getPage().getHeight();
        Float marginTop = this.getMarginTop();
        this.marginConfiguration.setMarginTop(margin);
        Cursor cursor = this.getContext().getCursor();
        if (Objects.equals(cursor.getY(), Float.valueOf(height.floatValue() - marginTop.floatValue()))) {
            cursor.setY(Float.valueOf(height.floatValue() - margin));
        }
        this.getContext().resetHeight(null);
    }

    public Float getMarginBottom() {
        return this.marginConfiguration.getMarginBottom();
    }

    public void setMarginBottom(float margin) {
        this.marginConfiguration.setMarginBottom(margin);
        this.getContext().resetHeight(null);
    }

    public Float getMarginLeft() {
        return this.marginConfiguration.getMarginLeft();
    }

    public void setMarginLeft(float margin) {
        Float marginLeft = this.getMarginLeft();
        this.marginConfiguration.setMarginLeft(margin);
        Cursor cursor = this.getContext().getCursor();
        if (Objects.equals(cursor.getX(), marginLeft)) {
            cursor.setX(Float.valueOf(margin));
        }
        this.getContext().setWrapBeginX(Float.valueOf(margin));
        this.getContext().resetWrapWidth(null);
    }

    public Float getMarginRight() {
        return this.marginConfiguration.getMarginRight();
    }

    public void setMarginRight(float margin) {
        this.marginConfiguration.setMarginRight(margin);
        this.getContext().resetWrapWidth(null);
    }

    public String getFontName() {
        return this.fontConfiguration.getFontName();
    }

    public void setFontName(String fontName) {
        this.fontConfiguration.setFontName(fontName);
        this.getContext().addFontCache(fontName);
    }

    public List<String> getSpecialFontNames() {
        return this.fontConfiguration.getSpecialFontNames();
    }

    public void setSpecialFontNames(String ... fontNames) {
        this.getContext().addFontCache(fontNames);
        Collections.addAll(this.fontConfiguration.getSpecialFontNames(), fontNames);
    }

    public Float getFontSize() {
        return this.fontConfiguration.getFontSize();
    }

    public void setFontSize(float size) {
        this.fontConfiguration.setFontSize(size);
    }

    public Color getFontColor() {
        return this.fontConfiguration.getFontColor();
    }

    public void setFontColor(Color color) {
        this.fontConfiguration.setFontColor(color);
    }

    public Float getFontAlpha() {
        return this.fontConfiguration.getFontAlpha();
    }

    public void setFontAlpha(float alpha) {
        this.fontConfiguration.setFontAlpha(Float.valueOf(alpha));
    }

    public FontStyle getFontStyle() {
        return this.fontConfiguration.getFontStyle();
    }

    public void setFontStyle(FontStyle style) {
        this.fontConfiguration.setFontStyle(style);
        if (style.isItalic() && this.getFontSlope().floatValue() == 0.0f) {
            this.setFontSlope(Constants.DEFAULT_FONT_ITALIC_SLOPE.floatValue());
        }
    }

    public Float getFontSlope() {
        return this.fontConfiguration.getFontSlope();
    }

    public void setFontSlope(float slope) {
        this.fontConfiguration.setFontSlope(Float.valueOf(slope));
    }

    public Float getCharacterSpacing() {
        return this.fontConfiguration.getCharacterSpacing();
    }

    public void setCharacterSpacing(float spacing) {
        this.fontConfiguration.setCharacterSpacing(spacing);
    }

    public Float getLeading() {
        return this.fontConfiguration.getLeading();
    }

    public void setLeading(float leading) {
        this.fontConfiguration.setLeading(leading);
    }

    public Float getWidth() {
        return this.pageSize.getWidth();
    }

    public Float getHeight() {
        return this.pageSize.getHeight();
    }

    public Float getWithoutMarginWidth() {
        return Float.valueOf(this.getWidth().floatValue() - this.getMarginLeft().floatValue() - this.getMarginRight().floatValue());
    }

    public Float getWithoutMarginHeight() {
        return Float.valueOf(this.getHeight().floatValue() - this.getMarginTop().floatValue() - this.getMarginBottom().floatValue());
    }

    public Page getFirstParentPage() {
        Page parent = this.getParentPage();
        if (Objects.nonNull(parent)) {
            while (Objects.nonNull(parent.getParentPage())) {
                parent = parent.getParentPage();
            }
        }
        return parent;
    }

    public Page getLastSubPage() {
        Page subPage = this.getSubPage();
        if (Objects.nonNull(subPage)) {
            while (Objects.nonNull(subPage.getSubPage())) {
                subPage = subPage.getSubPage();
            }
        }
        return subPage;
    }

    public Page getLastPage() {
        return Optional.ofNullable(this.getLastSubPage()).orElse(this);
    }

    public Integer getLastNo() {
        int index = Optional.ofNullable(this.getParentPage()).map(p -> 0).orElse(1);
        Page subPage = Optional.ofNullable(this.getFirstParentPage()).orElse(this.getSubPage());
        if (Objects.nonNull(subPage)) {
            ++index;
            while (Objects.nonNull(subPage.getSubPage())) {
                ++index;
                subPage = subPage.getSubPage();
            }
        }
        return index;
    }

    public String getPlaceholder() {
        return "${CPN}";
    }

    public void rotation(RotationAngle angle) {
        Objects.requireNonNull(angle, "the rotation angle can not be null");
        this.target.setRotation(angle.getAngle().intValue());
    }

    public void scale(PageSize rectangle) {
        Objects.requireNonNull(rectangle, "the rectangle can not be null");
        float widthScale = rectangle.getWidth().floatValue() / this.getPageSize().getWidth().floatValue();
        float heightScale = rectangle.getHeight().floatValue() / this.getPageSize().getHeight().floatValue();
        this.getTarget().setArtBox(this.getPageSize().getSize());
        this.getTarget().setMediaBox(rectangle.getSize());
        this.getTarget().setCropBox(null);
        this.setPageSize(rectangle);
        this.scaleContents(widthScale, heightScale);
    }

    public void scale(float scale) {
        this.scale(this.getPageSize().scale(scale));
    }

    public void crop(PageSize rectangle) {
        Objects.requireNonNull(rectangle, "the rectangle can not be null");
        this.getTarget().setArtBox(this.getPageSize().getSize());
        this.getTarget().setCropBox(rectangle.getSize());
        this.setPageSize(rectangle);
    }

    public void resetRectangle() {
        COSArray artBox = this.getTarget().getCOSObject().getCOSArray(COSName.ART_BOX);
        if (Objects.nonNull(artBox)) {
            PDRectangle rectangle = new PDRectangle(artBox);
            this.getTarget().setMediaBox(rectangle);
            this.setPageSize(new PageSize(rectangle));
        } else {
            this.setPageSize(new PageSize(this.getTarget().getMediaBox()));
        }
        this.getTarget().setCropBox(null);
        this.getTarget().setArtBox(null);
    }

    public Page createSubPage() {
        return new Page(this);
    }

    @Override
    public void close() {
        super.setContext(null);
        this.setTarget(null);
        this.setParentPage(null);
        this.setSubPage(null);
    }

    protected void init(PDPage target, AbstractBase base, MarginConfiguration marginConfiguration, FontConfiguration fontConfiguration, Color backgroundColor, BufferedImage backgroundImage) {
        this.id = IdUtil.get();
        this.target = target;
        this.pageSize = new PageSize(target.getCropBox());
        this.marginConfiguration = new MarginConfiguration(marginConfiguration);
        this.fontConfiguration = new FontConfiguration(fontConfiguration);
        this.backgroundColor = backgroundColor;
        this.backgroundImage = backgroundImage;
        this.horizontalAlignment = HorizontalAlignment.LEFT;
        this.verticalAlignment = VerticalAlignment.TOP;
        this.isContentBorder = Boolean.FALSE;
        super.init(base);
        Context context = this.getContext();
        context.reset(this);
        this.index = this.getContext().getPageCount() - 1;
        if (Objects.nonNull(this.fontConfiguration.getSpecialFontNames())) {
            for (String specialFontName : this.fontConfiguration.getSpecialFontNames()) {
                context.addFontCache(specialFontName);
            }
        }
        if (!Objects.equals(this.backgroundColor, Color.WHITE)) {
            this.initBackgroundColor();
        }
        if (Objects.nonNull(this.backgroundImage)) {
            this.initBackgroundImage();
        }
        if (context.hasPageHeader()) {
            context.getPageHeader().setIsAlreadyRendered(Boolean.FALSE);
        }
        if (context.hasPageFooter()) {
            context.getPageFooter().setIsAlreadyRendered(Boolean.FALSE);
        }
    }

    protected void initBackgroundColor() {
        PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getTarget(), PDPageContentStream.AppendMode.APPEND, true, this.getIsResetContentStream());
        contentStream.addRect(0.0f, 0.0f, this.getWidth().floatValue(), this.getHeight().floatValue());
        contentStream.setNonStrokingColor(this.getBackgroundColor());
        contentStream.fill();
        contentStream.close();
    }

    protected void initBackgroundImage() {
        PDImageXObject image = PDImageXObject.createFromByteArray((PDDocument)this.getContext().getTargetDocument(), (byte[])ImageUtil.resetBytes(ImageUtil.toBytes(this.getBackgroundImage(), ImageType.PNG.getType())), (String)"unknown");
        float width = Math.min((float)image.getWidth(), this.getWithoutMarginWidth().floatValue());
        float height = Math.min((float)image.getHeight(), this.getWithoutMarginHeight().floatValue());
        float x = Math.max(this.getMarginLeft().floatValue(), (this.getWithoutMarginWidth().floatValue() - width) / 2.0f);
        float y = Math.max(this.getMarginBottom().floatValue(), (this.getWithoutMarginHeight().floatValue() - height) / 2.0f);
        PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getTarget(), PDPageContentStream.AppendMode.APPEND, true, this.getIsResetContentStream());
        contentStream.drawImage(image, x, y, width, height);
        contentStream.close();
    }

    protected void initContentBorder() {
        PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getTarget(), PDPageContentStream.AppendMode.APPEND, true, false);
        contentStream.addRect(this.getMarginLeft().floatValue(), this.getMarginBottom().floatValue(), this.getWithoutMarginWidth().floatValue(), this.getWithoutMarginHeight().floatValue());
        contentStream.setStrokingColor(Color.BLACK);
        contentStream.stroke();
        contentStream.close();
    }

    protected void scaleContents(float widthScale, float heightScale) {
        PDPage page = this.getTarget();
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
        List tokens = parser.parse();
        tokens.add(0, new COSFloat(widthScale));
        tokens.add(1, COSInteger.ZERO);
        tokens.add(2, COSInteger.ZERO);
        tokens.add(3, new COSFloat(heightScale));
        tokens.add(4, COSInteger.ZERO);
        tokens.add(5, COSInteger.ZERO);
        tokens.add(6, Operator.getOperator((String)"cm"));
        PDStream contents = new PDStream(this.getContext().getTargetDocument());
        try (OutputStream outputStream = contents.createOutputStream();){
            ContentStreamWriter writer = new ContentStreamWriter(outputStream);
            writer.writeTokens(tokens);
            page.setContents(contents);
        }
    }

    @Generated
    public MarginConfiguration getMarginConfiguration() {
        return this.marginConfiguration;
    }

    @Generated
    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public BufferedImage getBackgroundImage() {
        return this.backgroundImage;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public PDPage getTarget() {
        return this.target;
    }

    @Generated
    public PageSize getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Page getParentPage() {
        return this.parentPage;
    }

    @Generated
    public Page getSubPage() {
        return this.subPage;
    }

    @Generated
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Generated
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Generated
    public Boolean getIsContentBorder() {
        return this.isContentBorder;
    }

    @Generated
    public void setMarginConfiguration(MarginConfiguration marginConfiguration) {
        this.marginConfiguration = marginConfiguration;
    }

    @Generated
    public void setFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public void setTarget(PDPage target) {
        this.target = target;
    }

    @Generated
    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setParentPage(Page parentPage) {
        this.parentPage = parentPage;
    }

    @Generated
    public void setSubPage(Page subPage) {
        this.subPage = subPage;
    }

    @Override
    @Generated
    public String toString() {
        return "Page(marginConfiguration=" + this.getMarginConfiguration() + ", fontConfiguration=" + this.getFontConfiguration() + ", backgroundColor=" + this.getBackgroundColor() + ", backgroundImage=" + this.getBackgroundImage() + ", id=" + this.getId() + ", index=" + this.getIndex() + ", target=" + this.getTarget() + ", pageSize=" + this.getPageSize() + ", parentPage=" + this.getParentPage() + ", subPage=" + this.getSubPage() + ", horizontalAlignment=" + (Object)((Object)this.getHorizontalAlignment()) + ", verticalAlignment=" + (Object)((Object)this.getVerticalAlignment()) + ", isContentBorder=" + this.getIsContentBorder() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Boolean this$isContentBorder = this.getIsContentBorder();
        Boolean other$isContentBorder = other.getIsContentBorder();
        if (this$isContentBorder == null ? other$isContentBorder != null : !((Object)this$isContentBorder).equals(other$isContentBorder)) {
            return false;
        }
        MarginConfiguration this$marginConfiguration = this.getMarginConfiguration();
        MarginConfiguration other$marginConfiguration = other.getMarginConfiguration();
        if (this$marginConfiguration == null ? other$marginConfiguration != null : !((Object)this$marginConfiguration).equals(other$marginConfiguration)) {
            return false;
        }
        FontConfiguration this$fontConfiguration = this.getFontConfiguration();
        FontConfiguration other$fontConfiguration = other.getFontConfiguration();
        if (this$fontConfiguration == null ? other$fontConfiguration != null : !((Object)this$fontConfiguration).equals(other$fontConfiguration)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        BufferedImage this$backgroundImage = this.getBackgroundImage();
        BufferedImage other$backgroundImage = other.getBackgroundImage();
        if (this$backgroundImage == null ? other$backgroundImage != null : !this$backgroundImage.equals(other$backgroundImage)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PDPage this$target = this.getTarget();
        PDPage other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        PageSize this$pageSize = this.getPageSize();
        PageSize other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !this$pageSize.equals(other$pageSize)) {
            return false;
        }
        Page this$parentPage = this.getParentPage();
        Page other$parentPage = other.getParentPage();
        if (this$parentPage == null ? other$parentPage != null : !((Object)this$parentPage).equals(other$parentPage)) {
            return false;
        }
        Page this$subPage = this.getSubPage();
        Page other$subPage = other.getSubPage();
        if (this$subPage == null ? other$subPage != null : !((Object)this$subPage).equals(other$subPage)) {
            return false;
        }
        HorizontalAlignment this$horizontalAlignment = this.getHorizontalAlignment();
        HorizontalAlignment other$horizontalAlignment = other.getHorizontalAlignment();
        if (this$horizontalAlignment == null ? other$horizontalAlignment != null : !((Object)((Object)this$horizontalAlignment)).equals((Object)other$horizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$verticalAlignment = this.getVerticalAlignment();
        VerticalAlignment other$verticalAlignment = other.getVerticalAlignment();
        return !(this$verticalAlignment == null ? other$verticalAlignment != null : !((Object)((Object)this$verticalAlignment)).equals((Object)other$verticalAlignment));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Boolean $isContentBorder = this.getIsContentBorder();
        result = result * 59 + ($isContentBorder == null ? 43 : ((Object)$isContentBorder).hashCode());
        MarginConfiguration $marginConfiguration = this.getMarginConfiguration();
        result = result * 59 + ($marginConfiguration == null ? 43 : ((Object)$marginConfiguration).hashCode());
        FontConfiguration $fontConfiguration = this.getFontConfiguration();
        result = result * 59 + ($fontConfiguration == null ? 43 : ((Object)$fontConfiguration).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        BufferedImage $backgroundImage = this.getBackgroundImage();
        result = result * 59 + ($backgroundImage == null ? 43 : $backgroundImage.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PDPage $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        PageSize $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : $pageSize.hashCode());
        Page $parentPage = this.getParentPage();
        result = result * 59 + ($parentPage == null ? 43 : ((Object)$parentPage).hashCode());
        Page $subPage = this.getSubPage();
        result = result * 59 + ($subPage == null ? 43 : ((Object)$subPage).hashCode());
        HorizontalAlignment $horizontalAlignment = this.getHorizontalAlignment();
        result = result * 59 + ($horizontalAlignment == null ? 43 : ((Object)((Object)$horizontalAlignment)).hashCode());
        VerticalAlignment $verticalAlignment = this.getVerticalAlignment();
        result = result * 59 + ($verticalAlignment == null ? 43 : ((Object)((Object)$verticalAlignment)).hashCode());
        return result;
    }
}

