/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.cos.COSUpdateState;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class COSArray
extends COSBase
implements Iterable<COSBase>,
COSUpdateInfo {
    private final List<COSBase> objects = new ArrayList<COSBase>();
    private final COSUpdateState updateState;
    private boolean isIndirect = false;

    public COSArray() {
        this.updateState = new COSUpdateState((COSUpdateInfo)this);
        this.setDirect(true);
    }

    public COSArray(List<? extends COSObjectable> cosObjectables) {
        if (cosObjectables == null) {
            throw new IllegalArgumentException("List of COSObjectables cannot be null");
        }
        this.updateState = new COSUpdateState((COSUpdateInfo)this);
        this.setDirect(true);
        cosObjectables.forEach(cosObjectable -> this.objects.add(cosObjectable != null ? cosObjectable.getCOSObject() : null));
    }

    public void add(COSBase object) {
        if ((object instanceof COSDictionary || object instanceof COSArray) && !object.isDirect() && object.getKey() != null) {
            COSObject cosObject = new COSObject(object, object.getKey());
            this.objects.add((COSBase)cosObject);
            this.getUpdateState().update((COSBase)cosObject);
        } else {
            this.objects.add(object);
            this.getUpdateState().update(object);
        }
    }

    public void add(COSObjectable object) {
        COSBase base = null;
        if (object != null) {
            base = object.getCOSObject();
        }
        this.add(base);
    }

    public void add(int i, COSBase object) {
        if ((object instanceof COSDictionary || object instanceof COSArray) && !object.isDirect() && object.getKey() != null) {
            COSObject cosObject = new COSObject(object, object.getKey());
            this.objects.add(i, (COSBase)cosObject);
            this.getUpdateState().update((COSBase)cosObject);
        } else {
            this.objects.add(i, object);
            this.getUpdateState().update(object);
        }
    }

    public void clear() {
        this.objects.clear();
        this.getUpdateState().update();
    }

    public void removeAll(Collection<COSBase> objectsList) {
        this.objects.removeAll(objectsList);
        this.getUpdateState().update();
    }

    public void retainAll(Collection<COSBase> objectsList) {
        if (this.objects.retainAll(objectsList)) {
            this.getUpdateState().update();
        }
    }

    public void addAll(Collection<COSBase> objectsList) {
        if (this.objects.addAll(objectsList)) {
            this.getUpdateState().update(objectsList);
        }
    }

    public void addAll(COSArray objectList) {
        if (objectList != null && this.objects.addAll(objectList.objects)) {
            this.getUpdateState().update(objectList);
        }
    }

    public void addAll(int i, Collection<COSBase> objectList) {
        if (this.objects.addAll(i, objectList)) {
            this.getUpdateState().update(objectList);
        }
    }

    public void set(int index, COSBase object) {
        if ((object instanceof COSDictionary || object instanceof COSArray) && !object.isDirect() && object.getKey() != null) {
            COSObject cosObject = new COSObject(object, object.getKey());
            this.objects.set(index, (COSBase)cosObject);
            this.getUpdateState().update((COSBase)cosObject);
        } else {
            this.objects.set(index, object);
            this.getUpdateState().update(object);
        }
    }

    public void set(int index, int intVal) {
        this.objects.set(index, (COSBase)COSInteger.get((long)intVal));
        this.getUpdateState().update();
    }

    public void set(int index, COSObjectable object) {
        COSBase base = null;
        if (object != null) {
            base = object.getCOSObject();
        }
        this.set(index, base);
    }

    public COSBase getObject(int index) {
        COSBase obj = this.objects.get(index);
        if (obj instanceof COSObject) {
            obj = ((COSObject)obj).getObject();
        }
        if (obj instanceof COSNull) {
            obj = null;
        }
        return obj;
    }

    public COSBase get(int index) {
        return this.objects.get(index);
    }

    public int getInt(int index) {
        return this.getInt(index, -1);
    }

    public int getInt(int index, int defaultValue) {
        COSBase obj;
        int retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSNumber) {
            retval = ((COSNumber)obj).intValue();
        }
        return retval;
    }

    public void setInt(int index, int value) {
        this.set(index, (COSBase)COSInteger.get((long)value));
    }

    public void setName(int index, String name) {
        this.set(index, (COSBase)COSName.getPDFName((String)name));
    }

    public String getName(int index) {
        return this.getName(index, null);
    }

    public String getName(int index, String defaultValue) {
        COSBase obj;
        String retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSName) {
            retval = ((COSName)obj).getName();
        }
        return retval;
    }

    public void setString(int index, String string) {
        if (string != null) {
            this.set(index, (COSBase)new COSString(string));
        } else {
            this.set(index, (COSBase)null);
        }
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    public String getString(int index, String defaultValue) {
        COSBase obj;
        String retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSString) {
            retval = ((COSString)obj).getString();
        }
        return retval;
    }

    public int size() {
        return this.objects.size();
    }

    public COSBase remove(int i) {
        COSBase removedEntry = this.objects.remove(i);
        this.getUpdateState().update();
        return removedEntry;
    }

    public boolean remove(COSBase o) {
        boolean removed = this.objects.remove(o);
        if (removed) {
            this.getUpdateState().update();
        }
        return removed;
    }

    public boolean removeObject(COSBase o) {
        boolean removed = this.remove(o);
        if (!removed) {
            for (int i = 0; i < this.size(); ++i) {
                COSObject objEntry;
                COSBase entry = this.get(i);
                if (!(entry instanceof COSObject) || !(objEntry = (COSObject)entry).getObject().equals(o)) continue;
                return this.remove(entry);
            }
        }
        return removed;
    }

    public String toString() {
        return "COSArray{" + this.objects + "}";
    }

    @Override
    public Iterator<COSBase> iterator() {
        return this.objects.iterator();
    }

    public int indexOf(COSBase object) {
        for (int i = 0; i < this.size(); ++i) {
            COSBase item = this.get(i);
            if (!(item == null ? object == null : item.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public int indexOfObject(COSBase object) {
        for (int i = 0; i < this.size(); ++i) {
            COSBase item = this.get(i);
            if (item == null) {
                if (item != object) continue;
                return i;
            }
            if (item.equals(object)) {
                return i;
            }
            if (!(item instanceof COSObject) || ((COSObject)item).getObject() == null || !((COSObject)item).getObject().equals(object)) continue;
            return i;
        }
        return -1;
    }

    public void growToSize(int size) {
        this.growToSize(size, null);
    }

    public void growToSize(int size, COSBase object) {
        while (this.size() < size) {
            this.add(object);
            this.getUpdateState().update(object);
        }
        this.getUpdateState().update();
    }

    @Override
    public void accept(ICOSVisitor visitor) throws IOException {
        visitor.visitFromArray(this);
    }

    public float[] toFloatArray() {
        float[] retval = new float[this.size()];
        for (int i = 0; i < retval.length; ++i) {
            COSBase base = this.getObject(i);
            retval[i] = base instanceof COSNumber ? ((COSNumber)base).floatValue() : 0.0f;
        }
        return retval;
    }

    public void setFloatArray(float[] value) {
        this.clear();
        for (float aValue : value) {
            this.add((COSBase)new COSFloat(aValue));
        }
    }

    public List<? extends COSBase> toList() {
        return new ArrayList<COSBase>(this.objects);
    }

    public List<String> toCOSNameStringList() {
        return this.objects.stream().map(o -> ((COSName)o).getName()).collect(Collectors.toList());
    }

    public List<String> toCOSStringStringList() {
        return this.objects.stream().map(o -> ((COSString)o).getString()).collect(Collectors.toList());
    }

    public List<Float> toCOSNumberFloatList() {
        ArrayList<Float> numbers = new ArrayList<Float>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            COSBase num = this.getObject(i);
            if (num instanceof COSNumber) {
                numbers.add(Float.valueOf(((COSNumber)num).floatValue()));
                continue;
            }
            numbers.add(null);
        }
        return numbers;
    }

    public List<Integer> toCOSNumberIntegerList() {
        ArrayList<Integer> numbers = new ArrayList<Integer>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            COSBase num = this.getObject(i);
            if (num instanceof COSNumber) {
                numbers.add(((COSNumber)num).intValue());
                continue;
            }
            numbers.add(null);
        }
        return numbers;
    }

    public static COSArray ofCOSIntegers(List<Integer> integer) {
        COSArray retval = new COSArray();
        integer.forEach(s -> retval.add((COSBase)COSInteger.get((long)s.longValue())));
        return retval;
    }

    public static COSArray ofCOSNames(List<String> strings) {
        COSArray retval = new COSArray();
        strings.forEach(s -> retval.add((COSBase)COSName.getPDFName((String)s)));
        return retval;
    }

    public static COSArray ofCOSStrings(List<String> strings) {
        COSArray retval = new COSArray();
        strings.forEach(s -> retval.add((COSBase)new COSString(s)));
        return retval;
    }

    public COSUpdateState getUpdateState() {
        return this.updateState;
    }

    public void getIndirectObjectKeys(List<COSObjectKey> indirectObjects) {
        this.getIndirectObjectKeys((Collection<COSObjectKey>)indirectObjects);
    }

    public void getIndirectObjectKeys(Collection<COSObjectKey> indirectObjects) {
        if (indirectObjects == null) {
            return;
        }
        if (this.isIndirect) {
            return;
        }
        this.isIndirect = true;
        COSObjectKey key = this.getKey();
        if (key != null) {
            if (indirectObjects.contains(key)) {
                return;
            }
            indirectObjects.add(key);
        }
        for (COSBase cosBase : this.objects) {
            COSObjectKey cosBaseKey;
            if (cosBase == null || (cosBaseKey = cosBase.getKey()) != null && indirectObjects.contains(cosBaseKey)) continue;
            if (cosBase instanceof COSObject) {
                cosBase = ((COSObject)cosBase).getObject();
            }
            if (cosBase instanceof COSDictionary) {
                ((COSDictionary)cosBase).getIndirectObjectKeys(indirectObjects);
                continue;
            }
            if (cosBase instanceof COSArray) {
                ((COSArray)cosBase).getIndirectObjectKeys(indirectObjects);
                continue;
            }
            if (cosBaseKey == null) continue;
            indirectObjects.add(cosBaseKey);
        }
    }
}

