/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.support.freemarker;

import freemarker.cache.URLTemplateLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import lombok.Generated;

public class DefaultURLTemplateLoader
extends URLTemplateLoader {
    private final String remotePath;
    private String templateName;

    public DefaultURLTemplateLoader(String remotePath) {
        this.remotePath = remotePath;
    }

    protected URL getURL(String name) {
        URL url;
        if (!Objects.equals(this.templateName, name)) {
            return null;
        }
        String fullPath = this.remotePath + name;
        if (this.remotePath.equals("/") && this.isInvalid(fullPath)) {
            return null;
        }
        try {
            url = new URL(fullPath);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }

    private boolean isInvalid(String fullPath) {
        int i = 0;
        int ln = fullPath.length();
        if (i < ln && fullPath.charAt(i) == '/') {
            ++i;
        }
        while (i < ln) {
            char c = fullPath.charAt(i);
            if (c == '/') {
                return false;
            }
            if (c == ':') {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Generated
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
}

