/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.Component;
import org.dromara.pdf.fop.core.doc.component.table.TableCellParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableCell {
    private final TableCellParam param = new TableCellParam();

    private TableCell setInitialCapacity(int initialCapacity) {
        this.param.setComponents(new ArrayList<Component>(initialCapacity));
        return this;
    }

    public TableCell setId(String id) {
        this.param.setId(id);
        return this;
    }

    public TableCell setWidth(String width) {
        if (this.param.getWidth() == null) {
            this.param.setWidth(width);
        }
        return this;
    }

    public TableCell setHeight(String height) {
        if (this.param.getHeight() == null) {
            this.param.setHeight(height);
        }
        return this;
    }

    public TableCell setBorder(String border) {
        this.param.setBorder(border);
        return this;
    }

    public TableCell setBorderStyle(String borderStyle) {
        this.param.setBorderStyle(borderStyle);
        return this;
    }

    public TableCell setBorderColor(String borderColor) {
        this.param.setBorderColor(borderColor);
        return this;
    }

    public TableCell setBorderWidth(String borderWidth) {
        this.param.setBorderWidth(borderWidth);
        return this;
    }

    public TableCell setBorderTop(String border) {
        this.param.setBorderTop(border);
        return this;
    }

    public TableCell setBorderTopStyle(String borderStyle) {
        this.param.setBorderTopStyle(borderStyle);
        return this;
    }

    public TableCell setBorderTopColor(String borderColor) {
        this.param.setBorderTopColor(borderColor);
        return this;
    }

    public TableCell setBorderTopWidth(String borderWidth) {
        this.param.setBorderTopWidth(borderWidth);
        return this;
    }

    public TableCell setBorderBottom(String border) {
        this.param.setBorderBottom(border);
        return this;
    }

    public TableCell setBorderBottomStyle(String borderStyle) {
        this.param.setBorderBottomStyle(borderStyle);
        return this;
    }

    public TableCell setBorderBottomColor(String borderColor) {
        this.param.setBorderBottomColor(borderColor);
        return this;
    }

    public TableCell setBorderBottomWidth(String borderWidth) {
        this.param.setBorderBottomWidth(borderWidth);
        return this;
    }

    public TableCell setBorderLeft(String border) {
        this.param.setBorderLeft(border);
        return this;
    }

    public TableCell setBorderLeftStyle(String borderStyle) {
        this.param.setBorderLeftStyle(borderStyle);
        return this;
    }

    public TableCell setBorderLeftColor(String borderColor) {
        this.param.setBorderLeftColor(borderColor);
        return this;
    }

    public TableCell setBorderLeftWidth(String borderWidth) {
        this.param.setBorderLeftWidth(borderWidth);
        return this;
    }

    public TableCell setBorderRight(String border) {
        this.param.setBorderRight(border);
        return this;
    }

    public TableCell setBorderRightStyle(String borderStyle) {
        this.param.setBorderRightStyle(borderStyle);
        return this;
    }

    public TableCell setBorderRightColor(String borderColor) {
        this.param.setBorderRightColor(borderColor);
        return this;
    }

    public TableCell setBorderRightWidth(String borderWidth) {
        this.param.setBorderRightWidth(borderWidth);
        return this;
    }

    public TableCell setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public TableCell setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public TableCell setLetterSpacing(String letterSpacing) {
        this.param.setLetterSpacing(letterSpacing);
        return this;
    }

    public TableCell setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public TableCell setWhiteSpace(String whiteSpace) {
        this.param.setWhiteSpace(whiteSpace);
        return this;
    }

    public TableCell setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public TableCell setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public TableCell setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public TableCell setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public TableCell setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public TableCell setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public TableCell setRowSpan(Integer rows) {
        this.param.setRowSpan(rows);
        return this;
    }

    public TableCell setColumnSpan(Integer columns) {
        this.param.setColumnSpan(columns);
        return this;
    }

    public TableCell setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public TableCell setVerticalStyle(String style) {
        this.param.setVerticalStyle(style);
        return this;
    }

    public TableCell setBackground(String background) {
        this.param.setBackground(background);
        return this;
    }

    public TableCell setBackgroundImage(String image) {
        this.param.setBackgroundImage(image);
        return this;
    }

    public TableCell setBackgroundImageWidth(String width) {
        this.param.setBackgroundImageWidth(width);
        return this;
    }

    public TableCell setBackgroundImageHeight(String height) {
        this.param.setBackgroundImageHeight(height);
        return this;
    }

    public TableCell setBackgroundAttachment(String attachment) {
        this.param.setBackgroundAttachment(attachment);
        return this;
    }

    public TableCell setBackgroundColor(String color) {
        this.param.setBackgroundColor(color);
        return this;
    }

    public TableCell setBackgroundPosition(String position) {
        this.param.setBackgroundPosition(position);
        return this;
    }

    public TableCell setBackgroundHorizontalPosition(String position) {
        this.param.setBackgroundPositionHorizontal(position);
        return this;
    }

    public TableCell setBackgroundVerticalPosition(String position) {
        this.param.setBackgroundPositionVertical(position);
        return this;
    }

    public TableCell setBackgroundRepeat(String repeat) {
        this.param.setBackgroundRepeat(repeat);
        return this;
    }

    public TableCell addComponent(Component ... components) {
        Optional.ofNullable(components).ifPresent(v -> Collections.addAll(this.param.getComponents(), v));
        return this;
    }

    public TableCell addComponent(List<Component> components) {
        Optional.ofNullable(components).ifPresent(this.param.getComponents()::addAll);
        return this;
    }

    public Element createElement(Document document) {
        Element tableCell = document.createElement("fo:table-cell");
        this.resetAttribute(tableCell);
        Optional.ofNullable(this.param.getId()).ifPresent(v -> tableCell.setAttribute("id", v.intern()));
        Optional.ofNullable(this.param.getWidth()).ifPresent(v -> tableCell.setAttribute("width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getHeight()).ifPresent(v -> tableCell.setAttribute("height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorder()).ifPresent(v -> tableCell.setAttribute("border", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderStyle()).ifPresent(v -> tableCell.setAttribute("border-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderColor()).ifPresent(v -> tableCell.setAttribute("border-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderWidth()).ifPresent(v -> tableCell.setAttribute("border-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRadius()).ifPresent(v -> tableCell.setAttribute("fox:border-radius", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderTop()).ifPresent(v -> tableCell.setAttribute("border-top", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderTopStyle()).ifPresent(v -> tableCell.setAttribute("border-top-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderTopColor()).ifPresent(v -> tableCell.setAttribute("border-top-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderTopWidth()).ifPresent(v -> tableCell.setAttribute("border-top-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderBottom()).ifPresent(v -> tableCell.setAttribute("border-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderBottomStyle()).ifPresent(v -> tableCell.setAttribute("border-bottom-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderBottomColor()).ifPresent(v -> tableCell.setAttribute("border-bottom-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderBottomWidth()).ifPresent(v -> tableCell.setAttribute("border-bottom-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderLeft()).ifPresent(v -> tableCell.setAttribute("border-left", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderLeftStyle()).ifPresent(v -> tableCell.setAttribute("border-left-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderLeftColor()).ifPresent(v -> tableCell.setAttribute("border-left-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderLeftWidth()).ifPresent(v -> tableCell.setAttribute("border-left-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRight()).ifPresent(v -> tableCell.setAttribute("border-right", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRightStyle()).ifPresent(v -> tableCell.setAttribute("border-right-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRightColor()).ifPresent(v -> tableCell.setAttribute("border-right-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRightWidth()).ifPresent(v -> tableCell.setAttribute("border-right-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLanguage()).ifPresent(v -> tableCell.setAttribute("language", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> tableCell.setAttribute("font-family", v.intern()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> tableCell.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> tableCell.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> tableCell.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> tableCell.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getColor()).ifPresent(v -> tableCell.setAttribute("color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLeading()).ifPresent(v -> tableCell.setAttribute("line-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLetterSpacing()).ifPresent(v -> tableCell.setAttribute("letter-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWordSpacing()).ifPresent(v -> tableCell.setAttribute("word-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWhiteSpace()).ifPresent(v -> tableCell.setAttribute("white-space", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getRowSpan()).ifPresent(v -> tableCell.setAttribute("number-rows-spanned", v.toString().intern()));
        Optional.ofNullable(this.param.getColumnSpan()).ifPresent(v -> tableCell.setAttribute("number-columns-spanned", v.toString().intern()));
        Optional.ofNullable(this.param.getHorizontalStyle()).ifPresent(v -> tableCell.setAttribute("text-align", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getVerticalStyle()).ifPresent(v -> tableCell.setAttribute("display-align", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundColor()).ifPresent(v -> tableCell.setAttribute("background-color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackground()).ifPresent(v -> tableCell.setAttribute("background", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundImage()).ifPresent(v -> tableCell.setAttribute("background-image", v.intern()));
        Optional.ofNullable(this.param.getBackgroundAttachment()).ifPresent(v -> tableCell.setAttribute("background-attachment", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundPosition()).ifPresent(v -> tableCell.setAttribute("background-position", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundPositionHorizontal()).ifPresent(v -> tableCell.setAttribute("background-position-horizontal", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundPositionVertical()).ifPresent(v -> tableCell.setAttribute("background-position-vertical", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundRepeat()).ifPresent(v -> tableCell.setAttribute("background-repeat", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getComponents()).ifPresent(v -> v.forEach(e -> tableCell.appendChild(e.createElement(document))));
        return tableCell;
    }

    private void resetAttribute(Element tableCell) {
        tableCell.setAttribute("margin", "0");
        tableCell.setAttribute("padding", "0");
    }
}

