/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.SharedResourceHolder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.plugin.grpc.cache.ApplicationConfigCache;
import org.dromara.soul.plugin.grpc.loadbalance.GrpcAttributeUtils;
import org.dromara.soul.plugin.grpc.resolver.SoulResolverHelper;
import org.dromara.soul.plugin.grpc.resolver.SoulServiceInstance;
import org.dromara.soul.plugin.grpc.resolver.SoulServiceInstanceLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoulNameResolver
extends NameResolver
implements Consumer<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoulNameResolver.class);
    private boolean resolving;
    private NameResolver.Listener2 listener;
    private Executor executor;
    private final String appName;
    private final Attributes attributes;
    private final SynchronizationContext syncContext;
    private final List<SoulServiceInstance> keep = null;
    private List<SoulServiceInstance> instanceList = Lists.newArrayList();
    private final SharedResourceHolder.Resource<Executor> executorResource;

    public SoulNameResolver(String appName, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource) {
        this.appName = appName;
        this.executor = args.getOffloadExecutor();
        this.executorResource = executorResource;
        this.attributes = Attributes.newBuilder().set(GrpcAttributeUtils.appName(), (Object)appName).build();
        this.syncContext = Objects.requireNonNull(args.getSynchronizationContext(), "syncContext");
    }

    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        ApplicationConfigCache.getInstance().watch(this.appName, this);
        this.resolve();
    }

    @Override
    public void accept(Object o) {
        this.syncContext.execute(() -> {
            if (this.listener != null) {
                this.resolve();
            }
        });
    }

    public void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    private void resolve() {
        log.info("Scheduled resolve for {}", (Object)this.appName);
        if (this.resolving) {
            return;
        }
        this.resolving = true;
        this.executor.execute(new Resolve(this.listener, this.instanceList));
    }

    public String getServiceAuthority() {
        return this.appName;
    }

    public void shutdown() {
        this.listener = null;
        if (this.executor != null) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
        this.instanceList = Lists.newArrayList();
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener2 savedListener;
        private final List<SoulServiceInstance> savedInstanceList;

        Resolve(NameResolver.Listener2 listener, List<SoulServiceInstance> instanceList) {
            this.savedListener = Objects.requireNonNull(listener, "listener");
            this.savedInstanceList = Objects.requireNonNull(instanceList, "instanceList");
        }

        @Override
        public void run() {
            AtomicReference<List<SoulServiceInstance>> resultContainer = new AtomicReference<List<SoulServiceInstance>>();
            try {
                resultContainer.set(this.resolveInternal());
            }
            catch (Exception e) {
                this.savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to update server list for " + SoulNameResolver.this.appName));
                resultContainer.set(Lists.newArrayList());
            }
            finally {
                SoulNameResolver.this.syncContext.execute(() -> {
                    SoulNameResolver.this.resolving = false;
                    List newInstanceList = (List)resultContainer.get();
                    if (newInstanceList != SoulNameResolver.this.keep && SoulNameResolver.this.listener != null) {
                        SoulNameResolver.this.instanceList = newInstanceList;
                    }
                });
            }
        }

        private List<SoulServiceInstance> resolveInternal() {
            String name = SoulNameResolver.this.appName;
            SoulServiceInstanceLists soulServiceInstanceLists = ApplicationConfigCache.getInstance().get(name);
            List<SoulServiceInstance> newInstanceList = soulServiceInstanceLists.getCopyInstances();
            log.info("Got {} candidate servers for {}", (Object)newInstanceList.size(), (Object)name);
            if (CollectionUtils.isEmpty(newInstanceList)) {
                log.info("No servers found for {}", (Object)name);
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("No servers found for " + name));
                return Lists.newArrayList();
            }
            if (!this.needsToUpdateConnections(newInstanceList)) {
                log.info("Nothing has changed... skipping update for {}", (Object)name);
                return null;
            }
            log.info("Ready to update server list for {}", (Object)name);
            List targets = newInstanceList.stream().map(instance -> {
                log.info("Found gRPC server {}:{} for {}", new Object[]{instance.getHost(), instance.getPort(), name});
                return SoulResolverHelper.convertToEquivalentAddressGroup(instance);
            }).collect(Collectors.toList());
            this.savedListener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(targets).setAttributes(SoulNameResolver.this.attributes).build());
            log.info("Done updating server list for {}", (Object)name);
            return newInstanceList;
        }

        private boolean needsToUpdateConnections(List<SoulServiceInstance> newInstanceList) {
            if (this.savedInstanceList.size() != newInstanceList.size()) {
                return true;
            }
            for (SoulServiceInstance instance : this.savedInstanceList) {
                String host = instance.getHost();
                int port = instance.getPort();
                boolean isSame = newInstanceList.stream().anyMatch(newInstance -> host.equals(newInstance.getHost()) && port == newInstance.getPort() && this.isMetadataEquals(instance.getMetadata(), newInstance.getMetadata()));
                if (isSame) continue;
                return true;
            }
            return false;
        }

        private boolean isMetadataEquals(Map<String, String> metadata, Map<String, String> newMetadata) {
            String[] keys;
            for (String key : keys = new String[]{"weight", "status"}) {
                String newValue;
                String value = metadata.get(key);
                if (Objects.equals(value, newValue = newMetadata.get(key))) continue;
                return false;
            }
            return true;
        }
    }
}

