/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.reflection;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.reflection.v1alpha.ServerReflectionGrpc;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.plugin.grpc.reflection.LookupServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SoulGrpcReflectionClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoulGrpcReflectionClient.class);
    private final Channel channel;
    private final Map<String, DescriptorProtos.FileDescriptorSet> fileDescriptorCache = new ConcurrentHashMap<String, DescriptorProtos.FileDescriptorSet>();

    private SoulGrpcReflectionClient(Channel channel) {
        this.channel = channel;
    }

    public static SoulGrpcReflectionClient create(Channel channel) {
        return new SoulGrpcReflectionClient(channel);
    }

    public ListenableFuture<DescriptorProtos.FileDescriptorSet> lookupService(String serviceName) {
        LookupServiceHandler rpcHandler = new LookupServiceHandler(serviceName);
        StreamObserver requestStream = ((ServerReflectionGrpc.ServerReflectionStub)ServerReflectionGrpc.newStub((Channel)this.channel).withDeadlineAfter(10000L, TimeUnit.MILLISECONDS)).serverReflectionInfo((StreamObserver)rpcHandler);
        return rpcHandler.start((StreamObserver<ServerReflectionRequest>)requestStream);
    }

    public DescriptorProtos.FileDescriptorSet resolveService(String serviceName) {
        return this.fileDescriptorCache.computeIfAbsent(serviceName, k -> {
            try {
                return (DescriptorProtos.FileDescriptorSet)this.lookupService((String)k).get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Resolve services get error", (Throwable)e);
                throw new SoulException((Throwable)e);
            }
        });
    }

    public String fetchFullMethodName(Descriptors.MethodDescriptor methodDescriptor) {
        String serviceName = methodDescriptor.getService().getFullName();
        String methodName = methodDescriptor.getName();
        return MethodDescriptor.generateFullMethodName((String)serviceName, (String)methodName);
    }

    public MethodDescriptor.MethodType fetchMethodType(Descriptors.MethodDescriptor methodDescriptor) {
        boolean clientStreaming = methodDescriptor.toProto().getClientStreaming();
        boolean serverStreaming = methodDescriptor.toProto().getServerStreaming();
        if (clientStreaming && serverStreaming) {
            return MethodDescriptor.MethodType.BIDI_STREAMING;
        }
        if (!clientStreaming && !serverStreaming) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (!clientStreaming) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        return MethodDescriptor.MethodType.SERVER_STREAMING;
    }

    public DynamicMessage parseToMessages(JsonFormat.TypeRegistry registry, Descriptors.Descriptor descriptor, String jsons) {
        JsonFormat.Parser parser = JsonFormat.parser().usingTypeRegistry(registry);
        try {
            DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
            parser.merge(jsons, (Message.Builder)messageBuilder);
            return messageBuilder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Unable to parse json text", e);
        }
    }

    public Map<String, DescriptorProtos.FileDescriptorSet> getFileDescriptorCache() {
        return this.fileDescriptorCache;
    }
}

