/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.proto;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.dromara.soul.plugin.grpc.proto.SoulGrpcResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageWriter<T extends Message>
implements StreamObserver<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageWriter.class);
    private final JsonFormat.Printer printer;
    private final SoulGrpcResponse results;

    private MessageWriter(JsonFormat.Printer printer, SoulGrpcResponse results) {
        this.printer = printer;
        this.results = results;
    }

    public static <T extends Message> MessageWriter<T> newInstance(JsonFormat.TypeRegistry registry, SoulGrpcResponse results) {
        return new MessageWriter<T>(JsonFormat.printer().usingTypeRegistry(registry), results);
    }

    public void onNext(T value) {
        try {
            this.results.setResult(this.printer.print(value));
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Skipping invalid response message", (Throwable)e);
        }
    }

    public void onError(Throwable t) {
        log.error("Messages write occur errors", t);
    }

    public void onCompleted() {
        log.info("Messages write complete");
    }
}

