/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.loadbalance.picker;

import io.grpc.LoadBalancer;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.plugin.grpc.loadbalance.SubChannelCopy;
import org.dromara.soul.plugin.grpc.loadbalance.picker.AbstractReadyPicker;

public class RandomPicker
extends AbstractReadyPicker {
    public RandomPicker(List<LoadBalancer.Subchannel> list) {
        super(list);
    }

    @Override
    protected SubChannelCopy pick(List<SubChannelCopy> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int index = this.getRandomIndexByWeight(list);
        return list.get(index);
    }

    private int getRandomIndexByWeight(List<SubChannelCopy> list) {
        int sumWeight = list.stream().mapToInt(SubChannelCopy::getWeight).sum();
        if (sumWeight <= 0) {
            return ThreadLocalRandom.current().nextInt(list.size());
        }
        int randomInt = ThreadLocalRandom.current().nextInt(sumWeight);
        int sumI = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (randomInt >= (sumI += list.get(i).getWeight())) continue;
            return i;
        }
        return list.size() - 1;
    }
}

