/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.grpc.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.DivideUpstream;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.grpc.cache.GrpcClientCache;
import org.dromara.soul.plugin.grpc.resolver.SoulServiceInstance;
import org.dromara.soul.plugin.grpc.resolver.SoulServiceInstanceLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationConfigCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private final int maxCount = 50000;
    private final LoadingCache<String, SoulServiceInstanceLists> cache = CacheBuilder.newBuilder().maximumWeight(50000L).weigher((string, referenceConfig) -> this.getSize()).build((CacheLoader)new CacheLoader<String, SoulServiceInstanceLists>(){

        public SoulServiceInstanceLists load(String key) {
            return new SoulServiceInstanceLists(new CopyOnWriteArrayList<SoulServiceInstance>(), key);
        }
    });
    private final Map<String, Consumer<Object>> listener = new ConcurrentHashMap<String, Consumer<Object>>();

    private ApplicationConfigCache() {
    }

    private int getSize() {
        return (int)this.cache.size();
    }

    public SoulServiceInstanceLists get(String contextPath) {
        try {
            return (SoulServiceInstanceLists)this.cache.get((Object)contextPath);
        }
        catch (ExecutionException e) {
            throw new SoulException(e.getCause());
        }
    }

    public void initPrx(SelectorData selectorData) {
        try {
            List upstreamList = GsonUtils.getInstance().fromList(selectorData.getHandle(), DivideUpstream.class);
            if (null == upstreamList || upstreamList.size() == 0) {
                this.invalidate(selectorData.getName());
                return;
            }
            SoulServiceInstanceLists soulServiceInstances = (SoulServiceInstanceLists)this.cache.get((Object)selectorData.getName());
            CopyOnWriteArrayList<SoulServiceInstance> instances = soulServiceInstances.getSoulServiceInstances();
            instances.clear();
            instances.addAll(upstreamList.stream().map(this::build).collect(Collectors.toList()));
            Consumer<Object> consumer = this.listener.get(selectorData.getName());
            if (Objects.nonNull(consumer)) {
                consumer.accept(System.currentTimeMillis());
            }
        }
        catch (ExecutionException e) {
            throw new SoulException(e.getCause());
        }
    }

    public void invalidate(String contextPath) {
        this.cache.invalidate((Object)contextPath);
        this.listener.remove(contextPath);
        GrpcClientCache.removeClient(contextPath);
    }

    public void watch(String key, Consumer<Object> consumer) {
        this.listener.put(key, consumer);
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    private SoulServiceInstance build(DivideUpstream divideUpstream) {
        String[] ipAndPort = divideUpstream.getUpstreamUrl().split(":");
        SoulServiceInstance instance = new SoulServiceInstance(ipAndPort[0], Integer.parseInt(ipAndPort[1]));
        instance.setWeight(divideUpstream.getWeight());
        instance.setStatus(divideUpstream.isStatus());
        return instance;
    }

    static class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        ApplicationConfigCacheInstance() {
        }
    }
}

