/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.apache.dubbo.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.service.GenericService;
import org.dromara.soul.common.config.DubboRegisterConfig;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.enums.LoadBalanceEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationConfigCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private final int maxCount = 50000;
    private final LoadingCache<String, ReferenceConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumWeight(50000L).weigher((string, referenceConfig) -> this.getSize()).removalListener(notification -> {
        ReferenceConfig config = (ReferenceConfig)notification.getValue();
        if (config != null) {
            try {
                Class<?> cz = config.getClass();
                Field field = cz.getDeclaredField("ref");
                field.setAccessible(true);
                field.set(config, null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                log.error("modify ref have exception", (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<String, ReferenceConfig<GenericService>>(){

        public ReferenceConfig<GenericService> load(String key) {
            return new ReferenceConfig();
        }
    });

    private ApplicationConfigCache() {
    }

    private int getSize() {
        return (int)this.cache.size();
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(DubboRegisterConfig dubboRegisterConfig) {
        if (this.applicationConfig == null) {
            this.applicationConfig = new ApplicationConfig("soul_proxy");
        }
        if (this.registryConfig == null) {
            this.registryConfig = new RegistryConfig();
            this.registryConfig.setProtocol(dubboRegisterConfig.getProtocol());
            this.registryConfig.setId("soul_proxy");
            this.registryConfig.setRegister(Boolean.valueOf(false));
            this.registryConfig.setAddress(dubboRegisterConfig.getRegister());
            Optional.ofNullable(dubboRegisterConfig.getGroup()).ifPresent(arg_0 -> ((RegistryConfig)this.registryConfig).setGroup(arg_0));
        }
    }

    public ReferenceConfig<GenericService> initRef(MetaData metaData) {
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            log.error("init dubbo ref ex:{}", (Object)e.getMessage());
        }
        return this.build(metaData);
    }

    public ReferenceConfig<GenericService> build(MetaData metaData) {
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric("true");
        ApplicationModel.getConfigManager().setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setInterface(metaData.getServiceName());
        reference.setProtocol("dubbo");
        String rpcExt = metaData.getRpcExt();
        DubboParamExtInfo dubboParamExtInfo = (DubboParamExtInfo)GsonUtils.getInstance().fromJson(rpcExt, DubboParamExtInfo.class);
        if (Objects.nonNull(dubboParamExtInfo)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExtInfo.getVersion()})) {
                reference.setVersion(dubboParamExtInfo.getVersion());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExtInfo.getGroup()})) {
                reference.setGroup(dubboParamExtInfo.getGroup());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExtInfo.getLoadbalance()})) {
                String loadBalance = dubboParamExtInfo.getLoadbalance();
                reference.setLoadbalance(this.buildLoadBalanceName(loadBalance));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExtInfo.getUrl()})) {
                reference.setUrl(dubboParamExtInfo.getUrl());
            }
            Optional.ofNullable(dubboParamExtInfo.getTimeout()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setTimeout(arg_0));
            Optional.ofNullable(dubboParamExtInfo.getRetries()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setRetries(arg_0));
        }
        try {
            Object obj = reference.get();
            if (obj != null) {
                log.info("init apache dubbo reference success there meteData is :{}", (Object)metaData.toString());
                this.cache.put((Object)metaData.getPath(), (Object)reference);
            }
        }
        catch (Exception e) {
            log.error("init apache dubbo reference ex:{}", (Object)e.getMessage());
        }
        return reference;
    }

    private String buildLoadBalanceName(String loadBalance) {
        if (LoadBalanceEnum.HASH.getName().equals(loadBalance) || "consistenthash".equals(loadBalance)) {
            return "consistenthash";
        }
        if (LoadBalanceEnum.ROUND_ROBIN.getName().equals(loadBalance)) {
            return "roundrobin";
        }
        return loadBalance;
    }

    public <T> ReferenceConfig<T> get(String path) {
        try {
            return (ReferenceConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new SoulException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    static class DubboParamExtInfo {
        private String group;
        private String version;
        private String loadbalance;
        private Integer retries;
        private Integer timeout;
        private String url;

        @Generated
        public DubboParamExtInfo() {
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getLoadbalance() {
            return this.loadbalance;
        }

        @Generated
        public Integer getRetries() {
            return this.retries;
        }

        @Generated
        public Integer getTimeout() {
            return this.timeout;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setGroup(String group) {
            this.group = group;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setLoadbalance(String loadbalance) {
            this.loadbalance = loadbalance;
        }

        @Generated
        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        @Generated
        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DubboParamExtInfo)) {
                return false;
            }
            DubboParamExtInfo other = (DubboParamExtInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$loadbalance = this.getLoadbalance();
            String other$loadbalance = other.getLoadbalance();
            if (this$loadbalance == null ? other$loadbalance != null : !this$loadbalance.equals(other$loadbalance)) {
                return false;
            }
            Integer this$retries = this.getRetries();
            Integer other$retries = other.getRetries();
            if (this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries)) {
                return false;
            }
            Integer this$timeout = this.getTimeout();
            Integer other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DubboParamExtInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $loadbalance = this.getLoadbalance();
            result = result * 59 + ($loadbalance == null ? 43 : $loadbalance.hashCode());
            Integer $retries = this.getRetries();
            result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
            Integer $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ApplicationConfigCache.DubboParamExtInfo(group=" + this.getGroup() + ", version=" + this.getVersion() + ", loadbalance=" + this.getLoadbalance() + ", retries=" + this.getRetries() + ", timeout=" + this.getTimeout() + ", url=" + this.getUrl() + ")";
        }
    }

    static class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        ApplicationConfigCacheInstance() {
        }
    }
}

