/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.apache.dubbo;

import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.plugin.apache.dubbo.proxy.ApacheDubboProxyService;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.api.result.SoulResultWrap;
import org.dromara.soul.plugin.api.utils.WebFluxResultUtils;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.dromara.soul.plugin.base.utils.FallbackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ApacheDubboPlugin
extends AbstractSoulPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApacheDubboPlugin.class);
    private final ApacheDubboProxyService dubboProxyService;

    public ApacheDubboPlugin(ApacheDubboProxyService dubboProxyService) {
        this.dubboProxyService = dubboProxyService;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        String param = (String)exchange.getAttribute("param_transform");
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        MetaData metaData = (MetaData)exchange.getAttribute("metaData");
        if (!this.checkMetaData(metaData)) {
            assert (metaData != null);
            log.error(" path is :{}, meta data have error.... {}", (Object)soulContext.getPath(), (Object)metaData.toString());
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = SoulResultWrap.error((int)SoulResultEnum.META_DATA_ERROR.getCode(), (String)SoulResultEnum.META_DATA_ERROR.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metaData.getParameterTypes()}) && StringUtils.isBlank((CharSequence)param)) {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = SoulResultWrap.error((int)SoulResultEnum.DUBBO_HAVE_BODY_PARAM.getCode(), (String)SoulResultEnum.DUBBO_HAVE_BODY_PARAM.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        Mono<Object> result = this.dubboProxyService.genericInvoker(param, metaData, exchange);
        return result.then(chain.execute(exchange));
    }

    public String named() {
        return PluginEnum.DUBBO.getName();
    }

    public Boolean skip(ServerWebExchange exchange) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        return !Objects.equals(soulContext.getRpcType(), RpcTypeEnum.DUBBO.getName());
    }

    public int getOrder() {
        return PluginEnum.DUBBO.getCode();
    }

    protected Mono<Void> handleSelectorIsNull(String pluginName, ServerWebExchange exchange, SoulPluginChain chain) {
        return FallbackUtils.getNoSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIsNull(String pluginName, ServerWebExchange exchange, SoulPluginChain chain) {
        return FallbackUtils.getNoRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    private boolean checkMetaData(MetaData metaData) {
        return null != metaData && !StringUtils.isBlank((CharSequence)metaData.getMethodName()) && !StringUtils.isBlank((CharSequence)metaData.getServiceName());
    }
}

