/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dromara.raincat.annotation.RaincatSPI;
import org.dromara.raincat.common.exception.TransactionException;
import org.dromara.raincat.common.serializer.ObjectSerializer;

@RaincatSPI(value="kryo")
public class KryoSerializer
implements ObjectSerializer {
    @Override
    public byte[] serialize(Object obj) throws TransactionException {
        byte[] bytes;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             Output output = new Output((OutputStream)outputStream);){
            Kryo kryo = new Kryo();
            kryo.writeObject(output, obj);
            bytes = output.toBytes();
            output.flush();
        }
        catch (IOException ex) {
            throw new TransactionException("kryo serialize error" + ex.getMessage());
        }
        return bytes;
    }

    @Override
    public <T> T deSerialize(byte[] param, Class<T> clazz) throws TransactionException {
        Object object;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(param);){
            Kryo kryo = new Kryo();
            Input input = new Input((InputStream)inputStream);
            object = kryo.readObject(input, clazz);
            input.close();
        }
        catch (IOException e) {
            throw new TransactionException("kryo deSerialize error" + e.getMessage());
        }
        return (T)object;
    }
}

