/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.netty.serizlize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dromara.raincat.common.netty.NettyTransferSerialize;

public class KryoSerialize
implements NettyTransferSerialize {
    private KryoPool pool;

    public KryoSerialize(KryoPool pool) {
        this.pool = pool;
    }

    @Override
    public void serialize(OutputStream output, Object object) throws IOException {
        Kryo kryo = this.pool.borrow();
        Output out = new Output(output);
        kryo.writeClassAndObject(out, object);
        out.close();
        output.close();
        this.pool.release(kryo);
    }

    /*
     * Loose catch block
     */
    @Override
    public Object deserialize(InputStream input) throws IOException {
        Kryo kryo = this.pool.borrow();
        try {
            try (Input in = new Input(input);){
                Object object = kryo.readClassAndObject(in);
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            input.close();
            this.pool.release(kryo);
        }
    }
}

