/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.netty.serizlize;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dromara.raincat.common.netty.MessageCodecService;

public abstract class AbstractMessageDecoder
extends ByteToMessageDecoder {
    private static final int MESSAGE_LENGTH = 4;
    private MessageCodecService util;

    public AbstractMessageDecoder(MessageCodecService service) {
        this.util = service;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int messageLength = in.readInt();
        if (messageLength < 0) {
            ctx.close();
        }
        if (in.readableBytes() < messageLength) {
            in.resetReaderIndex();
        } else {
            byte[] messageBody = new byte[messageLength];
            in.readBytes(messageBody);
            try {
                Object obj = this.util.decode(messageBody);
                out.add(obj);
            }
            catch (IOException ex) {
                Logger.getLogger(AbstractMessageDecoder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

