/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.holder.extension;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.dromara.raincat.annotation.RaincatSPI;
import org.dromara.raincat.common.exception.TransactionRuntimeException;
import org.dromara.raincat.common.holder.extension.ServiceBootstrap;

public final class ExtensionLoader<T> {
    private Class<T> type;

    private ExtensionLoader(Class<T> type) {
        this.type = type;
    }

    private static <T> boolean withExtensionAnnotation(Class<T> type) {
        return type.isAnnotationPresent(RaincatSPI.class);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new TransactionRuntimeException("type == null");
        }
        if (!type.isInterface()) {
            throw new TransactionRuntimeException("Extension type(" + type + ") not interface!");
        }
        if (!ExtensionLoader.withExtensionAnnotation(type)) {
            throw new TransactionRuntimeException("type" + type.getName() + "not exist");
        }
        return new ExtensionLoader<T>(type);
    }

    public T getActivateExtension(String value) {
        ServiceLoader<T> loader = ServiceBootstrap.loadAll(this.type);
        return (T)StreamSupport.stream(loader.spliterator(), false).filter(e -> Objects.equals(e.getClass().getAnnotation(RaincatSPI.class).value(), value)).findFirst().orElseThrow(() -> new TransactionRuntimeException("Please check your configuration"));
    }
}

