/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.holder;

import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATE_FORMAT_DATEONLY = "yyyy-MM-dd";
    public static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DATETIME14 = "yyyyMMddHHmmss";
    public static final String SHORTDATEFORMAT = "yyyyMMdd";
    public static final String HMS_FORMAT = "HH:mm:ss";
    private static final ZoneId UTC_ZONE = ZoneOffset.UTC.normalized();
    private static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();
    private static final Integer QUARTER_FIRST = 1;
    private static final Integer QUARTER_SECOND = 2;
    private static final Integer QUARTER_THIRD = 3;
    private static final Integer QUARTER_FOURTH = 4;

    public static LocalDateTime parseLocalDateTime(String str) throws ParseException {
        return LocalDateTime.parse(str, DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static Date getDateYYYY() throws ParseException {
        LocalDateTime localDateTime = DateUtils.parseLocalDateTime(DateUtils.getCurrentDateTime());
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static String parseDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return DateUtils.formaterLocalDateTime(localDateTime);
    }

    public static LocalDateTime parseLocalDateTime(String str, String dateFormat) throws ParseException {
        LocalDateTime localDateTime = LocalDateTime.parse(str, DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
        DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern(dateFormat);
        return LocalDateTime.parse(localDateTime.format(ofPattern), ofPattern);
    }

    public static LocalDateTime parseLocalDateTime10(String str) throws ParseException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT_DATEONLY);
        LocalDateTime time = LocalDateTime.from(LocalDate.parse(str, formatter).atStartOfDay());
        return time;
    }

    public static LocalDate parseLocalDate(String str) throws ParseException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT_DATEONLY);
        return LocalDate.parse(str, formatter);
    }

    public static LocalDate parseLocalDate(String str, String format) throws ParseException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return LocalDate.parse(str, formatter);
    }

    public static long nowTimeMillis() {
        return Clock.systemDefaultZone().millis();
    }

    public static long nowEpochSecond() {
        return Clock.systemDefaultZone().instant().getEpochSecond();
    }

    public static Instant nowTimestamp() {
        return Instant.now(Clock.systemDefaultZone());
    }

    public static String getCurrentDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATEONLY));
    }

    public static String getCurrentDateTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static String getCurrentDateTime(String format) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String getCurrentTime() {
        return LocalTime.now().format(DateTimeFormatter.ofPattern(HMS_FORMAT));
    }

    public static String formaterDate(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATEONLY));
    }

    public static String formaterTime(LocalTime time, String dateFormat) {
        return time.format(DateTimeFormatter.ofPattern(dateFormat));
    }

    public static String formaterDateToyyyyMMdd(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern(SHORTDATEFORMAT));
    }

    public static String formaterLocalDateTime(LocalDateTime dateTime) {
        return dateTime.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static String formaterLocalDateTime(LocalDateTime dateTime, String dateFormat) {
        return dateTime.format(DateTimeFormatter.ofPattern(dateFormat));
    }

    public static String parseInstantToDataStr(Instant instant) throws ParseException {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static String getTimeStampStr(LocalDateTime date) {
        return date.toInstant(ZoneOffset.UTC).toString();
    }

    public static LocalDateTime addSecond(LocalDateTime date, int second) {
        return date.plusSeconds(second);
    }

    public static LocalDateTime addMinute(LocalDateTime date, int minute) {
        return date.plusMinutes(minute);
    }

    public static LocalDateTime addHour(LocalDateTime date, int hour) {
        return date.plusHours(hour);
    }

    public static LocalDateTime addDay(LocalDateTime date, int day) {
        return date.plusDays(day);
    }

    public static LocalDateTime addMoth(LocalDateTime date, int month) {
        return date.plusMonths(month);
    }

    public static LocalDateTime addYear(LocalDateTime date, int year) {
        return date.plusYears(year);
    }

    public static LocalDateTime getDayStart(LocalDate date) {
        LocalDateTime localDateTime = LocalDateTime.of(date, LocalTime.of(0, 0, 0));
        return localDateTime;
    }

    public static LocalDateTime getDayEnd(LocalDate date) {
        LocalDateTime localDateTime = LocalDateTime.of(date, LocalTime.of(23, 59, 59));
        return localDateTime;
    }

    public static Instant parseDataStrToInstant(String dateStr) throws ParseException {
        return DateUtils.parseLocalDateTime(dateStr).toInstant(ZoneOffset.UTC);
    }

    public static boolean isSameDate(LocalDateTime date1, LocalDateTime date2) {
        String date1Str = date1.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATEONLY));
        String date2Str = date2.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATEONLY));
        return date1Str.equals(date2Str);
    }

    public static long getYearsBetween(LocalDate t1, LocalDate t2) {
        return t1.until(t2, ChronoUnit.YEARS);
    }

    public static long getDaysBetween(LocalDate t1, LocalDate t2) {
        return t1.until(t2, ChronoUnit.DAYS);
    }

    public static long getMonthsBetween(LocalDate t1, LocalDate t2) {
        return t1.until(t2, ChronoUnit.MONTHS);
    }

    public static long getHoursBetween(LocalDateTime t1, LocalDateTime t2) {
        return t1.until(t2, ChronoUnit.HOURS);
    }

    public static long getSecondsBetween(LocalDateTime t1, LocalDateTime t2) {
        return t1.until(t2, ChronoUnit.SECONDS);
    }

    public static long getMinutesBetween(LocalDateTime t1, LocalDateTime t2) {
        return t1.until(t2, ChronoUnit.MINUTES);
    }

    public static DayOfWeek getWeek() {
        return LocalDate.now().getDayOfWeek();
    }

    public static boolean isBetween(LocalDateTime date, LocalDateTime start, LocalDateTime end) {
        if (date == null || start == null || end == null) {
            throw new IllegalArgumentException("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return date.isAfter(start) && date.isBefore(end);
    }

    public static boolean isBetween(LocalTime date, LocalTime start, LocalTime end) {
        if (date == null || start == null || end == null) {
            throw new IllegalArgumentException("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return date.isAfter(start) && date.isBefore(end);
    }

    public static LocalDate getWeekStart(LocalDate date) {
        return date.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
    }

    public static LocalDate getWeekEnd(LocalDate date) {
        return date.with(TemporalAdjusters.previousOrSame(DayOfWeek.SUNDAY));
    }

    public static LocalDate getMonthEnd(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate getMonthStart(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getYearStart(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDate getYearEnd(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfYear());
    }

    public static LocalDate getSeasonStart(LocalDate date) {
        return DateUtils.getSeasonDate(date)[0];
    }

    public static LocalDate getSeasonEnd(LocalDate date) {
        return DateUtils.getSeasonDate(date)[2].with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate[] getSeasonDate(LocalDate date) {
        LocalDate[] season = new LocalDate[3];
        int nSeason = DateUtils.getSeason(date);
        int year = date.getYear();
        if (nSeason == QUARTER_FIRST) {
            season[0] = LocalDate.of(year, Month.JANUARY, 1);
            season[1] = LocalDate.of(year, Month.FEBRUARY, 1);
            season[2] = LocalDate.of(year, Month.MARCH, 1);
        } else if (nSeason == QUARTER_SECOND) {
            season[0] = LocalDate.of(year, Month.APRIL, 1);
            season[1] = LocalDate.of(year, Month.MAY, 1);
            season[2] = LocalDate.of(year, Month.JUNE, 1);
        } else if (nSeason == QUARTER_THIRD) {
            season[0] = LocalDate.of(year, Month.JULY, 1);
            season[1] = LocalDate.of(year, Month.AUGUST, 1);
            season[2] = LocalDate.of(year, Month.SEPTEMBER, 1);
        } else if (nSeason == QUARTER_FOURTH) {
            season[0] = LocalDate.of(year, Month.OCTOBER, 1);
            season[1] = LocalDate.of(year, Month.NOVEMBER, 1);
            season[2] = LocalDate.of(year, Month.DECEMBER, 1);
        }
        return season;
    }

    public static int getSeason(LocalDate date) {
        int season = 0;
        Month month = date.getMonth();
        switch (month) {
            case JANUARY: 
            case FEBRUARY: 
            case MARCH: {
                season = 1;
                break;
            }
            case APRIL: 
            case MAY: 
            case JUNE: {
                season = 2;
                break;
            }
            case JULY: 
            case AUGUST: 
            case SEPTEMBER: {
                season = 3;
                break;
            }
            case OCTOBER: 
            case NOVEMBER: 
            case DECEMBER: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static String subDays(int days) {
        return LocalDate.now().minusDays(days).format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATEONLY));
    }

    public static boolean isOverIntervalLimit(LocalDate startDate, LocalDate endDate, int interval) {
        return DateUtils.getDaysBetween(startDate, endDate) >= (long)interval;
    }

    public static String getYesterday() {
        return DateUtils.getYesterday(LocalDate.now());
    }

    public static String getYesterday(LocalDate date) {
        return date.minusDays(1L).format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATEONLY));
    }

    public static LocalDate getPreviousMonthFirstDay() {
        return LocalDate.now().minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getPreviousMonthLastDay() {
        return LocalDate.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static Date getTimesmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static LocalDateTime getAWeekFromNow() {
        LocalDateTime date = LocalDateTime.now();
        return date.plusWeeks(-1L);
    }

    public static LocalDateTime getAMonthFromNow() {
        LocalDateTime date = LocalDateTime.now();
        return date.plusMonths(-1L);
    }

    public static LocalDateTime getAYearFromNow() {
        LocalDateTime date = LocalDateTime.now();
        return date.plusYears(-1L);
    }

    public static LocalDateTime getUTCLocalDateTime() {
        return LocalDateTime.now(UTC_ZONE);
    }

    public static LocalDateTime toUTCDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        Instant instant = dateTime.toInstant(DEFAULT_ZONE.getRules().getOffset(dateTime));
        return LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), ZoneOffset.UTC);
    }

    public static LocalDateTime toDefaultDateTime(LocalDateTime dateTime) {
        return dateTime == null ? null : LocalDateTime.ofInstant(dateTime.toInstant(ZoneOffset.UTC), DEFAULT_ZONE);
    }

    public static LocalDateTime toDefaultDateTime(Timestamp timestamp) {
        return timestamp == null ? null : DateUtils.toDefaultDateTime(timestamp.toLocalDateTime());
    }

    public String toString() {
        return super.toString();
    }
}

