/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.captcha;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.ThreadLocalRandom;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.swing.captcha.AbstractCaptcha;
import org.dromara.hutool.swing.captcha.generator.CodeGenerator;
import org.dromara.hutool.swing.captcha.generator.RandomGenerator;
import org.dromara.hutool.swing.img.GraphicsUtil;
import org.dromara.hutool.swing.img.color.ColorUtil;

public class LineCaptcha
extends AbstractCaptcha {
    private static final long serialVersionUID = 8691294460763091089L;

    public LineCaptcha(int width, int height) {
        this(width, height, 5, 150);
    }

    public LineCaptcha(int width, int height, int codeCount, int lineCount) {
        this(width, height, new RandomGenerator(codeCount), lineCount);
    }

    public LineCaptcha(int width, int height, CodeGenerator generator, int interfereCount) {
        super(width, height, generator, interfereCount);
    }

    @Override
    public Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = GraphicsUtil.createGraphics(image, (Color)ObjUtil.defaultIfNull((Object)this.background, (Object)Color.WHITE));
        this.drawInterfere(g);
        this.drawString(g, code);
        return image;
    }

    private void drawString(Graphics2D g, String code) {
        if (null != this.textAlpha) {
            g.setComposite(this.textAlpha);
        }
        GraphicsUtil.drawStringColourful(g, code, this.font, this.width, this.height);
    }

    private void drawInterfere(Graphics2D g) {
        ThreadLocalRandom random = RandomUtil.getRandom();
        for (int i = 0; i < this.interfereCount; ++i) {
            int xs = random.nextInt(this.width);
            int ys = random.nextInt(this.height);
            int xe = xs + random.nextInt(this.width / 8);
            int ye = ys + random.nextInt(this.height / 8);
            g.setColor(ColorUtil.randomColor(random));
            g.drawLine(xs, ys, xe, ye);
        }
    }
}

