/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.sqlparser.shardingsphere;

import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngineFactory;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLUpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleUpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLUpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dml.SQLServerDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dml.SQLServerInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dml.SQLServerUpdateStatement;
import org.dromara.hmily.spi.HmilySPI;
import org.dromara.hmily.tac.common.database.type.DatabaseType;
import org.dromara.hmily.tac.sqlparser.model.common.statement.HmilyStatement;
import org.dromara.hmily.tac.sqlparser.shardingsphere.dialect.HmilyMySQLParserExecutor;
import org.dromara.hmily.tac.sqlparser.shardingsphere.dialect.HmilyOracleParserExecutor;
import org.dromara.hmily.tac.sqlparser.shardingsphere.dialect.HmilyPostgreSQLParserExecutor;
import org.dromara.hmily.tac.sqlparser.shardingsphere.dialect.HmilySQLServerParserExecutor;
import org.dromara.hmily.tac.sqlparser.spi.HmilySqlParserEngine;
import org.dromara.hmily.tac.sqlparser.spi.exception.SqlParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="shardingsphere")
public final class ShardingSphereSqlParserEngine
implements HmilySqlParserEngine {
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereSqlParserEngine.class);

    public HmilyStatement parser(String sql, DatabaseType databaseType) throws SqlParserException {
        SQLStatement sqlStatement = SQLStatementParserEngineFactory.getSQLStatementParserEngine((String)databaseType.getName()).parse(sql, true);
        if (sqlStatement instanceof UpdateStatement) {
            return this.executeUpdateStatementParser((UpdateStatement)sqlStatement);
        }
        if (sqlStatement instanceof InsertStatement) {
            return this.executeInsertStatementParser((InsertStatement)sqlStatement);
        }
        if (sqlStatement instanceof DeleteStatement) {
            return this.executeDeleteStatementParser((DeleteStatement)sqlStatement);
        }
        throw new SqlParserException("Unsupported SQL Statement.");
    }

    private HmilyStatement executeUpdateStatementParser(UpdateStatement updateStatement) {
        if (updateStatement instanceof MySQLUpdateStatement) {
            HmilyMySQLParserExecutor hmilyMySQLParserExecutor = new HmilyMySQLParserExecutor();
            return hmilyMySQLParserExecutor.executeUpdateStatement(updateStatement);
        }
        if (updateStatement instanceof PostgreSQLUpdateStatement) {
            HmilyPostgreSQLParserExecutor hmilyPostgreSQLParserExecutor = new HmilyPostgreSQLParserExecutor();
            return hmilyPostgreSQLParserExecutor.executeUpdateStatement(updateStatement);
        }
        if (updateStatement instanceof OracleUpdateStatement) {
            HmilyOracleParserExecutor hmilyOracleParserExecutor = new HmilyOracleParserExecutor();
            return hmilyOracleParserExecutor.executeUpdateStatement(updateStatement);
        }
        if (updateStatement instanceof SQLServerUpdateStatement) {
            HmilySQLServerParserExecutor hmilySQLServerParserExecutor = new HmilySQLServerParserExecutor();
            return hmilySQLServerParserExecutor.executeUpdateStatement(updateStatement);
        }
        throw new SqlParserException("Unsupported Dialect of Update Statement.");
    }

    private HmilyStatement executeInsertStatementParser(InsertStatement insertStatement) {
        if (insertStatement instanceof MySQLInsertStatement) {
            HmilyMySQLParserExecutor hmilyMySQLParserExecutor = new HmilyMySQLParserExecutor();
            return hmilyMySQLParserExecutor.executeInsertStatement(insertStatement);
        }
        if (insertStatement instanceof PostgreSQLInsertStatement) {
            HmilyPostgreSQLParserExecutor hmilyPostgreSQLParserExecutor = new HmilyPostgreSQLParserExecutor();
            return hmilyPostgreSQLParserExecutor.executeInsertStatement(insertStatement);
        }
        if (insertStatement instanceof OracleInsertStatement) {
            HmilyOracleParserExecutor hmilyOracleParserExecutor = new HmilyOracleParserExecutor();
            return hmilyOracleParserExecutor.executeInsertStatement(insertStatement);
        }
        if (insertStatement instanceof SQLServerInsertStatement) {
            HmilySQLServerParserExecutor hmilySQLServerParserExecutor = new HmilySQLServerParserExecutor();
            return hmilySQLServerParserExecutor.executeInsertStatement(insertStatement);
        }
        throw new SqlParserException("Unsupported Dialect of Insert Statement.");
    }

    private HmilyStatement executeDeleteStatementParser(DeleteStatement deleteStatement) {
        if (deleteStatement instanceof MySQLDeleteStatement) {
            HmilyMySQLParserExecutor hmilyMySQLParserExecutor = new HmilyMySQLParserExecutor();
            return hmilyMySQLParserExecutor.executeDeleteStatement(deleteStatement);
        }
        if (deleteStatement instanceof PostgreSQLDeleteStatement) {
            HmilyPostgreSQLParserExecutor hmilyPostgreSQLParserExecutor = new HmilyPostgreSQLParserExecutor();
            return hmilyPostgreSQLParserExecutor.executeDeleteStatement(deleteStatement);
        }
        if (deleteStatement instanceof OracleDeleteStatement) {
            HmilyOracleParserExecutor hmilyOracleParserExecutor = new HmilyOracleParserExecutor();
            return hmilyOracleParserExecutor.executeDeleteStatement(deleteStatement);
        }
        if (deleteStatement instanceof SQLServerDeleteStatement) {
            HmilySQLServerParserExecutor hmilySQLServerParserExecutor = new HmilySQLServerParserExecutor();
            return hmilySQLServerParserExecutor.executeDeleteStatement(deleteStatement);
        }
        throw new SqlParserException("Unsupported Dialect of Delete Statement.");
    }
}

