/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.utils;

import java.util.ArrayList;
import java.util.List;
import org.dromara.hmily.common.bean.adapter.CoordinatorRepositoryAdapter;
import org.dromara.hmily.common.bean.entity.HmilyParticipant;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.serializer.ObjectSerializer;
import org.dromara.hmily.common.utils.CollectionUtils;

public class RepositoryConvertUtils {
    public static byte[] convert(HmilyTransaction hmilyTransaction, ObjectSerializer objectSerializer) throws HmilyException {
        CoordinatorRepositoryAdapter adapter = new CoordinatorRepositoryAdapter();
        adapter.setTransId(hmilyTransaction.getTransId());
        adapter.setLastTime(hmilyTransaction.getLastTime());
        adapter.setCreateTime(hmilyTransaction.getCreateTime());
        adapter.setRetriedCount(hmilyTransaction.getRetriedCount());
        adapter.setStatus(hmilyTransaction.getStatus());
        adapter.setTargetClass(hmilyTransaction.getTargetClass());
        adapter.setTargetMethod(hmilyTransaction.getTargetMethod());
        adapter.setPattern(hmilyTransaction.getPattern());
        adapter.setRole(hmilyTransaction.getRole());
        adapter.setVersion(hmilyTransaction.getVersion());
        if (CollectionUtils.isNotEmpty(hmilyTransaction.getHmilyParticipants())) {
            HmilyParticipant hmilyParticipant = hmilyTransaction.getHmilyParticipants().get(0);
            adapter.setConfirmMethod(hmilyParticipant.getConfirmHmilyInvocation().getMethodName());
            adapter.setCancelMethod(hmilyParticipant.getCancelHmilyInvocation().getMethodName());
        }
        adapter.setContents(objectSerializer.serialize(hmilyTransaction.getHmilyParticipants()));
        return objectSerializer.serialize(adapter);
    }

    public static HmilyTransaction transformBean(byte[] contents, ObjectSerializer objectSerializer) throws HmilyException {
        HmilyTransaction hmilyTransaction = new HmilyTransaction();
        CoordinatorRepositoryAdapter adapter = objectSerializer.deSerialize(contents, CoordinatorRepositoryAdapter.class);
        List hmilyParticipants = objectSerializer.deSerialize(adapter.getContents(), ArrayList.class);
        hmilyTransaction.setLastTime(adapter.getLastTime());
        hmilyTransaction.setRetriedCount(adapter.getRetriedCount());
        hmilyTransaction.setCreateTime(adapter.getCreateTime());
        hmilyTransaction.setTransId(adapter.getTransId());
        hmilyTransaction.setStatus(adapter.getStatus());
        hmilyTransaction.setHmilyParticipants(hmilyParticipants);
        hmilyTransaction.setRole(adapter.getRole());
        hmilyTransaction.setPattern(adapter.getPattern());
        hmilyTransaction.setTargetClass(adapter.getTargetClass());
        hmilyTransaction.setTargetMethod(adapter.getTargetMethod());
        hmilyTransaction.setVersion(adapter.getVersion());
        return hmilyTransaction;
    }
}

