/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.serializer;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dromara.hmily.annotation.HmilySPI;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.serializer.ObjectSerializer;

@HmilySPI(value="hessian")
public class HessianSerializer
implements ObjectSerializer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(Object obj) throws HmilyException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Hessian2Output hos = new Hessian2Output((OutputStream)bos);
            hos.writeObject(obj);
            hos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new HmilyException("Hessian serialize error " + ex.getMessage());
        }
    }

    @Override
    public <T> T deSerialize(byte[] param, Class<T> clazz) throws HmilyException {
        try {
            ByteArrayInputStream bios = new ByteArrayInputStream(param);
            Hessian2Input his = new Hessian2Input((InputStream)bios);
            return (T)his.readObject();
        }
        catch (IOException e) {
            throw new HmilyException("Hessian deSerialize error " + e.getMessage());
        }
    }
}

