/*
 * Decompiled with CFR 0.152.
 */
package jcuda.runtime;

import java.util.Arrays;
import jcuda.runtime.cudaTextureAddressMode;
import jcuda.runtime.cudaTextureFilterMode;
import jcuda.runtime.cudaTextureReadMode;

public class cudaTextureDesc {
    public int[] addressMode = new int[3];
    public int filterMode;
    public int readMode;
    public int sRGB;
    public float[] borderColor = new float[4];
    public int normalizedCoords;
    public int maxAnisotropy;
    public int mipmapFilterMode;
    public float mipmapLevelBias;
    public float minMipmapLevelClamp;
    public float maxMipmapLevelClamp;
    public int disableTrilinearOptimization;
    public int seamlessCubemap;

    public String toString() {
        return "cudaTextureDesc[" + this.createString(",") + "]";
    }

    public String toFormattedString() {
        return "CUDA texture descriptor:\n    " + this.createString("\n    ");
    }

    private String createString(String f) {
        StringBuilder sb = new StringBuilder();
        sb.append("addressMode=[" + cudaTextureAddressMode.stringFor(this.addressMode[0]) + "," + cudaTextureAddressMode.stringFor(this.addressMode[1]) + "," + cudaTextureAddressMode.stringFor(this.addressMode[2]) + "]" + f);
        sb.append("filterMode=" + cudaTextureFilterMode.stringFor(this.filterMode) + f);
        sb.append("readMode=" + cudaTextureReadMode.stringFor(this.readMode) + f);
        sb.append("sRGB=" + this.sRGB + f);
        sb.append("borderColor=" + Arrays.toString(this.borderColor) + f);
        sb.append("normalizedCoords=" + this.normalizedCoords + f);
        sb.append("maxAnisotropy=" + this.maxAnisotropy + f);
        sb.append("mipmapFilterMode=" + cudaTextureFilterMode.stringFor(this.mipmapFilterMode) + f);
        sb.append("mipmapLevelBias=" + this.mipmapLevelBias + f);
        sb.append("minMipmapLevelClamp=" + this.minMipmapLevelClamp + f);
        sb.append("maxMipmapLevelClamp=" + this.maxMipmapLevelClamp + f);
        sb.append("disableTrilinearOptimization=" + this.disableTrilinearOptimization + f);
        sb.append("seamlessCubemap=" + this.seamlessCubemap + f);
        return sb.toString();
    }
}

