/*
 * Decompiled with CFR 0.152.
 */
package jcuda.driver;

import java.util.Arrays;
import jcuda.CudaException;
import jcuda.JCudaVersion;
import jcuda.LibUtils;
import jcuda.LibUtilsCuda;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.driver.CUDA_ARRAY3D_DESCRIPTOR;
import jcuda.driver.CUDA_ARRAY_DESCRIPTOR;
import jcuda.driver.CUDA_ARRAY_MEMORY_REQUIREMENTS;
import jcuda.driver.CUDA_ARRAY_SPARSE_PROPERTIES;
import jcuda.driver.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS;
import jcuda.driver.CUDA_EXT_SEM_WAIT_NODE_PARAMS;
import jcuda.driver.CUDA_HOST_NODE_PARAMS;
import jcuda.driver.CUDA_KERNEL_NODE_PARAMS;
import jcuda.driver.CUDA_LAUNCH_PARAMS;
import jcuda.driver.CUDA_MEMCPY2D;
import jcuda.driver.CUDA_MEMCPY3D;
import jcuda.driver.CUDA_MEMCPY3D_PEER;
import jcuda.driver.CUDA_MEMSET_NODE_PARAMS;
import jcuda.driver.CUDA_RESOURCE_DESC;
import jcuda.driver.CUDA_RESOURCE_VIEW_DESC;
import jcuda.driver.CUDA_TEXTURE_DESC;
import jcuda.driver.CUarray;
import jcuda.driver.CUarrayMapInfo;
import jcuda.driver.CUcontext;
import jcuda.driver.CUdevice;
import jcuda.driver.CUdeviceptr;
import jcuda.driver.CUdevprop;
import jcuda.driver.CUevent;
import jcuda.driver.CUfunction;
import jcuda.driver.CUgraph;
import jcuda.driver.CUgraphExec;
import jcuda.driver.CUgraphNode;
import jcuda.driver.CUgraphicsResource;
import jcuda.driver.CUhostFn;
import jcuda.driver.CUipcEventHandle;
import jcuda.driver.CUipcMemHandle;
import jcuda.driver.CUkernelNodeAttrValue;
import jcuda.driver.CUlinkState;
import jcuda.driver.CUmemAccessDesc;
import jcuda.driver.CUmemAllocationProp;
import jcuda.driver.CUmemGenericAllocationHandle;
import jcuda.driver.CUmemLocation;
import jcuda.driver.CUmipmappedArray;
import jcuda.driver.CUmodule;
import jcuda.driver.CUoccupancyB2DSize;
import jcuda.driver.CUresult;
import jcuda.driver.CUstream;
import jcuda.driver.CUstreamAttrValue;
import jcuda.driver.CUstreamBatchMemOpParams;
import jcuda.driver.CUstreamCallback;
import jcuda.driver.CUsurfObject;
import jcuda.driver.CUsurfref;
import jcuda.driver.CUtexObject;
import jcuda.driver.CUtexref;
import jcuda.driver.CUuuid;
import jcuda.driver.JITOptions;

public class JCudaDriver {
    public static final int CUDA_VERSION = 12000;
    public static final int CU_MEMHOSTALLOC_PORTABLE = 1;
    public static final int CU_MEMHOSTALLOC_DEVICEMAP = 2;
    public static final int CU_MEMHOSTALLOC_WRITECOMBINED = 4;
    public static final int CU_MEMHOSTREGISTER_PORTABLE = 1;
    public static final int CU_MEMHOSTREGISTER_DEVICEMAP = 2;
    @Deprecated
    public static final int CU_MEMPEERREGISTER_DEVICEMAP = 2;
    public static final int CU_MEMHOSTREGISTER_IOMEMORY = 4;
    public static final int CU_MEMHOSTREGISTER_READ_ONLY = 8;
    public static final int CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL = 1;
    public static final int CU_MEM_CREATE_USAGE_TILE_POOL = 1;
    public static final int CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC = 1;
    public static final int CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC = 2;
    public static final int CUDA_ARRAY3D_LAYERED = 1;
    @Deprecated
    public static final int CUDA_ARRAY3D_2DARRAY = 1;
    public static final int CUDA_ARRAY3D_SURFACE_LDST = 2;
    public static final int CUDA_ARRAY3D_CUBEMAP = 4;
    public static final int CUDA_ARRAY3D_TEXTURE_GATHER = 8;
    public static final int CUDA_ARRAY3D_DEPTH_TEXTURE = 16;
    public static final int CUDA_ARRAY3D_COLOR_ATTACHMENT = 32;
    public static final int CUDA_ARRAY3D_SPARSE = 64;
    public static final int CUDA_ARRAY3D_DEFERRED_MAPPING = 128;
    public static final int CU_PARAM_TR_DEFAULT = -1;
    public static final int CU_TRSA_OVERRIDE_FORMAT = 1;
    public static final int CU_TRSF_READ_AS_INTEGER = 1;
    public static final int CU_TRSF_NORMALIZED_COORDINATES = 2;
    public static final int CU_TRSF_SRGB = 16;
    @Deprecated
    public static final int CU_STREAM_CALLBACK_NONBLOCKING = 0;
    @Deprecated
    public static final int CU_STREAM_CALLBACK_BLOCKING = 1;
    public static final int CU_TRSF_DISABLE_TRILINEAR_OPTIMIZATION = 32;
    public static final int CU_COMPUTE_ACCELERATED_TARGET_BASE = 65536;
    public static final Pointer CU_LAUNCH_PARAM_END = new ConstantPointer(0L);
    public static final Pointer CU_LAUNCH_PARAM_BUFFER_POINTER = new ConstantPointer(1L);
    public static final Pointer CU_LAUNCH_PARAM_BUFFER_SIZE = new ConstantPointer(2L);
    public static final CUdevice CU_DEVICE_CPU = new CUdevice(-1L);
    public static final CUdevice CU_DEVICE_INVALID = new CUdevice(-2L);
    public static final CUstream CU_STREAM_LEGACY = new CUstream(1L);
    public static final CUstream CU_STREAM_PER_THREAD = new CUstream(2L);
    private static boolean exceptionsEnabled = false;
    private static final Object OCCUPANCY_LOCK;

    private JCudaDriver() {
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCudaDriver.setLogLevel(logLevel.ordinal());
    }

    private static native void setLogLevel(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(CUresult.stringFor(result));
        }
        return result;
    }

    @Deprecated
    public static int align(int value, int alignment) {
        return value + alignment - 1 & ~(alignment - 1);
    }

    public static int cuModuleLoadDataJIT(CUmodule module, Pointer pointer, JITOptions jitOptions) {
        return JCudaDriver.cuModuleLoadDataJITNative(module, pointer, jitOptions);
    }

    private static native int cuModuleLoadDataJITNative(CUmodule var0, Pointer var1, JITOptions var2);

    public static int cuModuleLoadDataEx(CUmodule phMod, String string, int numOptions, int[] options, Pointer optionValues) {
        byte[] bytes = string.getBytes();
        byte[] image = Arrays.copyOf(bytes, bytes.length + 1);
        return JCudaDriver.cuModuleLoadDataEx(phMod, Pointer.to(image), numOptions, options, optionValues);
    }

    public static int cuModuleLoadData(CUmodule module, String string) {
        byte[] bytes = string.getBytes();
        byte[] image = Arrays.copyOf(bytes, bytes.length + 1);
        return JCudaDriver.cuModuleLoadData(module, image);
    }

    public static int cuGetErrorString(int error, String[] pStr) {
        return JCudaDriver.checkResult(JCudaDriver.cuGetErrorStringNative(error, pStr));
    }

    private static native int cuGetErrorStringNative(int var0, String[] var1);

    public static int cuGetErrorName(int error, String[] pStr) {
        return JCudaDriver.checkResult(JCudaDriver.cuGetErrorNameNative(error, pStr));
    }

    private static native int cuGetErrorNameNative(int var0, String[] var1);

    public static int cuInit(int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuInitNative(Flags));
    }

    private static native int cuInitNative(int var0);

    public static int cuDeviceGet(CUdevice device, int ordinal) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetNative(device, ordinal));
    }

    private static native int cuDeviceGetNative(CUdevice var0, int var1);

    public static int cuDeviceGetCount(int[] count) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetCountNative(count));
    }

    private static native int cuDeviceGetCountNative(int[] var0);

    public static int cuDeviceGetName(byte[] name, int len, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetNameNative(name, len, dev));
    }

    private static native int cuDeviceGetNameNative(byte[] var0, int var1, CUdevice var2);

    public static int cuDeviceGetUuid(CUuuid uuid, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetUuidNative(uuid, dev));
    }

    private static native int cuDeviceGetUuidNative(CUuuid var0, CUdevice var1);

    public static int cuDeviceGetLuid(byte[] luid, int[] deviceNodeMask, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetLuidNative(luid, deviceNodeMask, dev));
    }

    public static native int cuDeviceGetLuidNative(byte[] var0, int[] var1, CUdevice var2);

    @Deprecated
    public static int cuDeviceComputeCapability(int[] major, int[] minor, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceComputeCapabilityNative(major, minor, dev));
    }

    private static native int cuDeviceComputeCapabilityNative(int[] var0, int[] var1, CUdevice var2);

    public static int cuDevicePrimaryCtxRetain(CUcontext pctx, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDevicePrimaryCtxRetainNative(pctx, dev));
    }

    private static native int cuDevicePrimaryCtxRetainNative(CUcontext var0, CUdevice var1);

    public static int cuDevicePrimaryCtxRelease(CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDevicePrimaryCtxReleaseNative(dev));
    }

    private static native int cuDevicePrimaryCtxReleaseNative(CUdevice var0);

    public static int cuDevicePrimaryCtxSetFlags(CUdevice dev, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuDevicePrimaryCtxSetFlagsNative(dev, flags));
    }

    private static native int cuDevicePrimaryCtxSetFlagsNative(CUdevice var0, int var1);

    public static int cuDevicePrimaryCtxGetState(CUdevice dev, int[] flags, int[] active) {
        return JCudaDriver.checkResult(JCudaDriver.cuDevicePrimaryCtxGetStateNative(dev, flags, active));
    }

    private static native int cuDevicePrimaryCtxGetStateNative(CUdevice var0, int[] var1, int[] var2);

    public static int cuDevicePrimaryCtxReset(CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDevicePrimaryCtxResetNative(dev));
    }

    private static native int cuDevicePrimaryCtxResetNative(CUdevice var0);

    public static int cuDeviceTotalMem(long[] bytes, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceTotalMemNative(bytes, dev));
    }

    private static native int cuDeviceTotalMemNative(long[] var0, CUdevice var1);

    public static int cuDeviceGetTexture1DLinearMaxWidth(long[] maxWidthInElements, int format, int numChannels, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetTexture1DLinearMaxWidthNative(maxWidthInElements, format, numChannels, dev));
    }

    private static native int cuDeviceGetTexture1DLinearMaxWidthNative(long[] var0, int var1, int var2, CUdevice var3);

    @Deprecated
    public static int cuDeviceGetProperties(CUdevprop prop, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetPropertiesNative(prop, dev));
    }

    private static native int cuDeviceGetPropertiesNative(CUdevprop var0, CUdevice var1);

    public static int cuDeviceGetAttribute(int[] pi, int attrib, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetAttributeNative(pi, attrib, dev));
    }

    private static native int cuDeviceGetAttributeNative(int[] var0, int var1, CUdevice var2);

    public static int cuDriverGetVersion(int[] driverVersion) {
        return JCudaDriver.checkResult(JCudaDriver.cuDriverGetVersionNative(driverVersion));
    }

    private static native int cuDriverGetVersionNative(int[] var0);

    public static int cuCtxCreate(CUcontext pctx, int flags, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxCreateNative(pctx, flags, dev));
    }

    private static native int cuCtxCreateNative(CUcontext var0, int var1, CUdevice var2);

    public static int cuCtxDestroy(CUcontext ctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxDestroyNative(ctx));
    }

    private static native int cuCtxDestroyNative(CUcontext var0);

    @Deprecated
    public static int cuCtxAttach(CUcontext pctx, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxAttachNative(pctx, flags));
    }

    private static native int cuCtxAttachNative(CUcontext var0, int var1);

    @Deprecated
    public static int cuCtxDetach(CUcontext ctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxDetachNative(ctx));
    }

    private static native int cuCtxDetachNative(CUcontext var0);

    public static int cuCtxPushCurrent(CUcontext ctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxPushCurrentNative(ctx));
    }

    private static native int cuCtxPushCurrentNative(CUcontext var0);

    public static int cuCtxPopCurrent(CUcontext pctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxPopCurrentNative(pctx));
    }

    private static native int cuCtxPopCurrentNative(CUcontext var0);

    public static int cuCtxSetCurrent(CUcontext ctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxSetCurrentNative(ctx));
    }

    private static native int cuCtxSetCurrentNative(CUcontext var0);

    public static int cuCtxGetCurrent(CUcontext pctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetCurrentNative(pctx));
    }

    private static native int cuCtxGetCurrentNative(CUcontext var0);

    public static int cuCtxGetDevice(CUdevice device) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetDeviceNative(device));
    }

    private static native int cuCtxGetDeviceNative(CUdevice var0);

    public static int cuCtxGetFlags(int[] flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetFlagsNative(flags));
    }

    private static native int cuCtxGetFlagsNative(int[] var0);

    public static final int cuCtxGetId(CUcontext ctx, long[] ctxId) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetIdNative(ctx, ctxId));
    }

    private static native int cuCtxGetIdNative(CUcontext var0, long[] var1);

    public static int cuCtxSynchronize() {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxSynchronizeNative());
    }

    private static native int cuCtxSynchronizeNative();

    public static int cuModuleLoad(CUmodule module, String fname) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleLoadNative(module, fname));
    }

    private static native int cuModuleLoadNative(CUmodule var0, String var1);

    public static int cuModuleGetLoadingMode(int[] mode) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleGetLoadingModeNative(mode));
    }

    private static native int cuModuleGetLoadingModeNative(int[] var0);

    public static int cuModuleLoadData(CUmodule module, byte[] image) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleLoadDataNative(module, image));
    }

    private static native int cuModuleLoadDataNative(CUmodule var0, byte[] var1);

    public static int cuModuleLoadDataEx(CUmodule phMod, Pointer p, int numOptions, int[] options, Pointer optionValues) {
        if (numOptions == 0) {
            if (options == null) {
                options = new int[]{};
            }
            if (optionValues == null) {
                optionValues = Pointer.to(new int[0]);
            }
        }
        return JCudaDriver.checkResult(JCudaDriver.cuModuleLoadDataExNative(phMod, p, numOptions, options, optionValues));
    }

    private static native int cuModuleLoadDataExNative(CUmodule var0, Pointer var1, int var2, int[] var3, Pointer var4);

    public static int cuModuleLoadFatBinary(CUmodule module, byte[] fatCubin) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleLoadFatBinaryNative(module, fatCubin));
    }

    private static native int cuModuleLoadFatBinaryNative(CUmodule var0, byte[] var1);

    public static int cuModuleUnload(CUmodule hmod) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleUnloadNative(hmod));
    }

    private static native int cuModuleUnloadNative(CUmodule var0);

    public static int cuModuleGetFunction(CUfunction hfunc, CUmodule hmod, String name) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleGetFunctionNative(hfunc, hmod, name));
    }

    private static native int cuModuleGetFunctionNative(CUfunction var0, CUmodule var1, String var2);

    public static int cuModuleGetGlobal(CUdeviceptr dptr, long[] bytes, CUmodule hmod, String name) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleGetGlobalNative(dptr, bytes, hmod, name));
    }

    private static native int cuModuleGetGlobalNative(CUdeviceptr var0, long[] var1, CUmodule var2, String var3);

    public static int cuModuleGetTexRef(CUtexref pTexRef, CUmodule hmod, String name) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleGetTexRefNative(pTexRef, hmod, name));
    }

    private static native int cuModuleGetTexRefNative(CUtexref var0, CUmodule var1, String var2);

    public static int cuModuleGetSurfRef(CUsurfref pSurfRef, CUmodule hmod, String name) {
        return JCudaDriver.checkResult(JCudaDriver.cuModuleGetSurfRefNative(pSurfRef, hmod, name));
    }

    private static native int cuModuleGetSurfRefNative(CUsurfref var0, CUmodule var1, String var2);

    public static int cuLinkCreate(JITOptions jitOptions, CUlinkState stateOut) {
        return JCudaDriver.checkResult(JCudaDriver.cuLinkCreateNative(jitOptions, stateOut));
    }

    private static native int cuLinkCreateNative(JITOptions var0, CUlinkState var1);

    public static int cuLinkAddData(CUlinkState state, int type, Pointer data, long size, String name, JITOptions jitOptions) {
        return JCudaDriver.checkResult(JCudaDriver.cuLinkAddDataNative(state, type, data, size, name, jitOptions));
    }

    private static native int cuLinkAddDataNative(CUlinkState var0, int var1, Pointer var2, long var3, String var5, JITOptions var6);

    public static int cuLinkAddFile(CUlinkState state, int type, String path, JITOptions jitOptions) {
        return JCudaDriver.checkResult(JCudaDriver.cuLinkAddFileNative(state, type, path, jitOptions));
    }

    private static native int cuLinkAddFileNative(CUlinkState var0, int var1, String var2, JITOptions var3);

    public static int cuLinkComplete(CUlinkState state, Pointer cubinOut, long[] sizeOut) {
        return JCudaDriver.checkResult(JCudaDriver.cuLinkCompleteNative(state, cubinOut, sizeOut));
    }

    private static native int cuLinkCompleteNative(CUlinkState var0, Pointer var1, long[] var2);

    public static int cuLinkDestroy(CUlinkState state) {
        return JCudaDriver.checkResult(JCudaDriver.cuLinkDestroyNative(state));
    }

    private static native int cuLinkDestroyNative(CUlinkState var0);

    public static int cuMemGetInfo(long[] free, long[] total) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemGetInfoNative(free, total));
    }

    private static native int cuMemGetInfoNative(long[] var0, long[] var1);

    public static int cuMemHostAlloc(Pointer pp, long bytes, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemHostAllocNative(pp, bytes, Flags));
    }

    private static native int cuMemHostAllocNative(Pointer var0, long var1, int var3);

    public static int cuMemHostGetDevicePointer(CUdeviceptr ret, Pointer p, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemHostGetDevicePointerNative(ret, p, Flags));
    }

    private static native int cuMemHostGetDevicePointerNative(CUdeviceptr var0, Pointer var1, int var2);

    public static int cuMemHostGetFlags(int[] pFlags, Pointer p) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemHostGetFlagsNative(pFlags, p));
    }

    private static native int cuMemHostGetFlagsNative(int[] var0, Pointer var1);

    public static int cuDeviceGetByPCIBusId(CUdevice dev, String pciBusId) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetByPCIBusIdNative(dev, pciBusId));
    }

    private static native int cuDeviceGetByPCIBusIdNative(CUdevice var0, String var1);

    public static int cuMemAllocManaged(CUdeviceptr dptr, long bytesize, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemAllocManagedNative(dptr, bytesize, flags));
    }

    private static native int cuMemAllocManagedNative(CUdeviceptr var0, long var1, int var3);

    public static int cuDeviceGetPCIBusId(String[] pciBusId, int len, CUdevice dev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetPCIBusIdNative(pciBusId, len, dev));
    }

    private static native int cuDeviceGetPCIBusIdNative(String[] var0, int var1, CUdevice var2);

    public static int cuIpcGetEventHandle(CUipcEventHandle pHandle, CUevent event) {
        return JCudaDriver.checkResult(JCudaDriver.cuIpcGetEventHandleNative(pHandle, event));
    }

    private static native int cuIpcGetEventHandleNative(CUipcEventHandle var0, CUevent var1);

    public static int cuIpcOpenEventHandle(CUevent phEvent, CUipcEventHandle handle) {
        return JCudaDriver.checkResult(JCudaDriver.cuIpcOpenEventHandleNative(phEvent, handle));
    }

    private static native int cuIpcOpenEventHandleNative(CUevent var0, CUipcEventHandle var1);

    public static int cuIpcGetMemHandle(CUipcMemHandle pHandle, CUdeviceptr dptr) {
        return JCudaDriver.checkResult(JCudaDriver.cuIpcGetMemHandleNative(pHandle, dptr));
    }

    private static native int cuIpcGetMemHandleNative(CUipcMemHandle var0, CUdeviceptr var1);

    public static int cuIpcOpenMemHandle(CUdeviceptr pdptr, CUipcMemHandle handle, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuIpcOpenMemHandleNative(pdptr, handle, Flags));
    }

    private static native int cuIpcOpenMemHandleNative(CUdeviceptr var0, CUipcMemHandle var1, int var2);

    public static int cuIpcCloseMemHandle(CUdeviceptr dptr) {
        return JCudaDriver.checkResult(JCudaDriver.cuIpcCloseMemHandleNative(dptr));
    }

    private static native int cuIpcCloseMemHandleNative(CUdeviceptr var0);

    public static int cuMemHostRegister(Pointer p, long bytesize, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemHostRegisterNative(p, bytesize, Flags));
    }

    private static native int cuMemHostRegisterNative(Pointer var0, long var1, int var3);

    public static int cuMemHostUnregister(Pointer p) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemHostUnregisterNative(p));
    }

    private static native int cuMemHostUnregisterNative(Pointer var0);

    public static int cuMemcpy(CUdeviceptr dst, CUdeviceptr src, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyNative(dst, src, ByteCount));
    }

    private static native int cuMemcpyNative(CUdeviceptr var0, CUdeviceptr var1, long var2);

    public static int cuMemcpyPeer(CUdeviceptr dstDevice, CUcontext dstContext, CUdeviceptr srcDevice, CUcontext srcContext, long ByteCount) {
        return JCudaDriver.cuMemcpyPeerNative(dstDevice, dstContext, srcDevice, srcContext, ByteCount);
    }

    private static native int cuMemcpyPeerNative(CUdeviceptr var0, CUcontext var1, CUdeviceptr var2, CUcontext var3, long var4);

    public static int cuMemAlloc(CUdeviceptr dptr, long bytesize) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemAllocNative(dptr, bytesize));
    }

    private static native int cuMemAllocNative(CUdeviceptr var0, long var1);

    public static int cuMemAllocPitch(CUdeviceptr dptr, long[] pPitch, long WidthInBytes, long Height, int ElementSizeBytes) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemAllocPitchNative(dptr, pPitch, WidthInBytes, Height, ElementSizeBytes));
    }

    private static native int cuMemAllocPitchNative(CUdeviceptr var0, long[] var1, long var2, long var4, int var6);

    public static int cuMemFree(CUdeviceptr dptr) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemFreeNative(dptr));
    }

    private static native int cuMemFreeNative(CUdeviceptr var0);

    public static int cuMemGetAddressRange(CUdeviceptr pbase, long[] psize, CUdeviceptr dptr) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemGetAddressRangeNative(pbase, psize, dptr));
    }

    private static native int cuMemGetAddressRangeNative(CUdeviceptr var0, long[] var1, CUdeviceptr var2);

    public static int cuMemAllocHost(Pointer pointer, long bytesize) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemAllocHostNative(pointer, bytesize));
    }

    private static native int cuMemAllocHostNative(Pointer var0, long var1);

    public static int cuMemFreeHost(Pointer p) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemFreeHostNative(p));
    }

    private static native int cuMemFreeHostNative(Pointer var0);

    public static int cuMemcpyHtoD(CUdeviceptr dstDevice, Pointer srcHost, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyHtoDNative(dstDevice, srcHost, ByteCount));
    }

    private static native int cuMemcpyHtoDNative(CUdeviceptr var0, Pointer var1, long var2);

    public static int cuMemcpyDtoH(Pointer dstHost, CUdeviceptr srcDevice, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyDtoHNative(dstHost, srcDevice, ByteCount));
    }

    private static native int cuMemcpyDtoHNative(Pointer var0, CUdeviceptr var1, long var2);

    public static int cuMemcpyDtoD(CUdeviceptr dstDevice, CUdeviceptr srcDevice, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyDtoDNative(dstDevice, srcDevice, ByteCount));
    }

    private static native int cuMemcpyDtoDNative(CUdeviceptr var0, CUdeviceptr var1, long var2);

    public static int cuMemcpyDtoA(CUarray dstArray, long dstIndex, CUdeviceptr srcDevice, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyDtoANative(dstArray, dstIndex, srcDevice, ByteCount));
    }

    private static native int cuMemcpyDtoANative(CUarray var0, long var1, CUdeviceptr var3, long var4);

    public static int cuMemcpyAtoD(CUdeviceptr dstDevice, CUarray hSrc, long SrcIndex, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyAtoDNative(dstDevice, hSrc, SrcIndex, ByteCount));
    }

    private static native int cuMemcpyAtoDNative(CUdeviceptr var0, CUarray var1, long var2, long var4);

    public static int cuMemcpyHtoA(CUarray dstArray, long dstIndex, Pointer pSrc, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyHtoANative(dstArray, dstIndex, pSrc, ByteCount));
    }

    private static native int cuMemcpyHtoANative(CUarray var0, long var1, Pointer var3, long var4);

    public static int cuMemcpyAtoH(Pointer dstHost, CUarray srcArray, long srcIndex, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyAtoHNative(dstHost, srcArray, srcIndex, ByteCount));
    }

    private static native int cuMemcpyAtoHNative(Pointer var0, CUarray var1, long var2, long var4);

    public static int cuMemcpyAtoA(CUarray dstArray, long dstIndex, CUarray srcArray, long srcIndex, long ByteCount) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyAtoANative(dstArray, dstIndex, srcArray, srcIndex, ByteCount));
    }

    private static native int cuMemcpyAtoANative(CUarray var0, long var1, CUarray var3, long var4, long var6);

    public static int cuMemcpy2D(CUDA_MEMCPY2D pCopy) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpy2DNative(pCopy));
    }

    private static native int cuMemcpy2DNative(CUDA_MEMCPY2D var0);

    public static int cuMemcpy2DUnaligned(CUDA_MEMCPY2D pCopy) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpy2DUnalignedNative(pCopy));
    }

    private static native int cuMemcpy2DUnalignedNative(CUDA_MEMCPY2D var0);

    public static int cuMemcpy3D(CUDA_MEMCPY3D pCopy) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpy3DNative(pCopy));
    }

    private static native int cuMemcpy3DNative(CUDA_MEMCPY3D var0);

    public static int cuMemcpy3DPeer(CUDA_MEMCPY3D_PEER pCopy) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpy3DPeerNative(pCopy));
    }

    private static native int cuMemcpy3DPeerNative(CUDA_MEMCPY3D_PEER var0);

    public static int cuMemcpyAsync(CUdeviceptr dst, CUdeviceptr src, long ByteCount, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyAsyncNative(dst, src, ByteCount, hStream));
    }

    private static native int cuMemcpyAsyncNative(CUdeviceptr var0, CUdeviceptr var1, long var2, CUstream var4);

    public static int cuMemcpyPeerAsync(CUdeviceptr dstDevice, CUcontext dstContext, CUdeviceptr srcDevice, CUcontext srcContext, long ByteCount, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyPeerAsyncNative(dstDevice, dstContext, srcDevice, srcContext, ByteCount, hStream));
    }

    private static native int cuMemcpyPeerAsyncNative(CUdeviceptr var0, CUcontext var1, CUdeviceptr var2, CUcontext var3, long var4, CUstream var6);

    public static int cuMemcpyHtoDAsync(CUdeviceptr dstDevice, Pointer srcHost, long ByteCount, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyHtoDAsyncNative(dstDevice, srcHost, ByteCount, hStream));
    }

    private static native int cuMemcpyHtoDAsyncNative(CUdeviceptr var0, Pointer var1, long var2, CUstream var4);

    public static int cuMemcpyDtoHAsync(Pointer dstHost, CUdeviceptr srcDevice, long ByteCount, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyDtoHAsyncNative(dstHost, srcDevice, ByteCount, hStream));
    }

    private static native int cuMemcpyDtoHAsyncNative(Pointer var0, CUdeviceptr var1, long var2, CUstream var4);

    public static int cuMemcpyDtoDAsync(CUdeviceptr dstDevice, CUdeviceptr srcDevice, long ByteCount, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyDtoDAsyncNative(dstDevice, srcDevice, ByteCount, hStream));
    }

    private static native int cuMemcpyDtoDAsyncNative(CUdeviceptr var0, CUdeviceptr var1, long var2, CUstream var4);

    public static int cuMemcpyHtoAAsync(CUarray dstArray, long dstIndex, Pointer pSrc, long ByteCount, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyHtoAAsyncNative(dstArray, dstIndex, pSrc, ByteCount, hStream));
    }

    private static native int cuMemcpyHtoAAsyncNative(CUarray var0, long var1, Pointer var3, long var4, CUstream var6);

    public static int cuMemcpyAtoHAsync(Pointer dstHost, CUarray srcArray, long srcIndex, long ByteCount, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpyAtoHAsyncNative(dstHost, srcArray, srcIndex, ByteCount, hStream));
    }

    private static native int cuMemcpyAtoHAsyncNative(Pointer var0, CUarray var1, long var2, long var4, CUstream var6);

    public static int cuMemcpy2DAsync(CUDA_MEMCPY2D pCopy, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpy2DAsyncNative(pCopy, hStream));
    }

    private static native int cuMemcpy2DAsyncNative(CUDA_MEMCPY2D var0, CUstream var1);

    public static int cuMemcpy3DAsync(CUDA_MEMCPY3D pCopy, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpy3DAsyncNative(pCopy, hStream));
    }

    private static native int cuMemcpy3DAsyncNative(CUDA_MEMCPY3D var0, CUstream var1);

    public static int cuMemcpy3DPeerAsync(CUDA_MEMCPY3D_PEER pCopy, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemcpy3DPeerAsyncNative(pCopy, hStream));
    }

    private static native int cuMemcpy3DPeerAsyncNative(CUDA_MEMCPY3D_PEER var0, CUstream var1);

    public static int cuMemsetD8(CUdeviceptr dstDevice, byte uc, long N) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD8Native(dstDevice, uc, N));
    }

    private static native int cuMemsetD8Native(CUdeviceptr var0, byte var1, long var2);

    public static int cuMemsetD16(CUdeviceptr dstDevice, short us, long N) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD16Native(dstDevice, us, N));
    }

    private static native int cuMemsetD16Native(CUdeviceptr var0, short var1, long var2);

    public static int cuMemsetD32(CUdeviceptr dstDevice, int ui, long N) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD32Native(dstDevice, ui, N));
    }

    private static native int cuMemsetD32Native(CUdeviceptr var0, int var1, long var2);

    public static int cuMemsetD2D8(CUdeviceptr dstDevice, long dstPitch, byte uc, long Width, long Height) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD2D8Native(dstDevice, dstPitch, uc, Width, Height));
    }

    private static native int cuMemsetD2D8Native(CUdeviceptr var0, long var1, byte var3, long var4, long var6);

    public static int cuMemsetD2D16(CUdeviceptr dstDevice, long dstPitch, short us, long Width, long Height) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD2D16Native(dstDevice, dstPitch, us, Width, Height));
    }

    private static native int cuMemsetD2D16Native(CUdeviceptr var0, long var1, short var3, long var4, long var6);

    public static int cuMemsetD2D32(CUdeviceptr dstDevice, long dstPitch, int ui, long Width, long Height) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD2D32Native(dstDevice, dstPitch, ui, Width, Height));
    }

    private static native int cuMemsetD2D32Native(CUdeviceptr var0, long var1, int var3, long var4, long var6);

    public static int cuMemsetD8Async(CUdeviceptr dstDevice, byte uc, long N, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD8AsyncNative(dstDevice, uc, N, hStream));
    }

    private static native int cuMemsetD8AsyncNative(CUdeviceptr var0, byte var1, long var2, CUstream var4);

    public static int cuMemsetD16Async(CUdeviceptr dstDevice, short us, long N, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD16AsyncNative(dstDevice, us, N, hStream));
    }

    private static native int cuMemsetD16AsyncNative(CUdeviceptr var0, short var1, long var2, CUstream var4);

    public static int cuMemsetD32Async(CUdeviceptr dstDevice, int ui, long N, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD32AsyncNative(dstDevice, ui, N, hStream));
    }

    private static native int cuMemsetD32AsyncNative(CUdeviceptr var0, int var1, long var2, CUstream var4);

    public static int cuMemsetD2D8Async(CUdeviceptr dstDevice, long dstPitch, byte uc, long Width, long Height, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD2D8AsyncNative(dstDevice, dstPitch, uc, Width, Height, hStream));
    }

    private static native int cuMemsetD2D8AsyncNative(CUdeviceptr var0, long var1, byte var3, long var4, long var6, CUstream var8);

    public static int cuMemsetD2D16Async(CUdeviceptr dstDevice, long dstPitch, short us, long Width, long Height, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD2D16AsyncNative(dstDevice, dstPitch, us, Width, Height, hStream));
    }

    private static native int cuMemsetD2D16AsyncNative(CUdeviceptr var0, long var1, short var3, long var4, long var6, CUstream var8);

    public static int cuMemsetD2D32Async(CUdeviceptr dstDevice, long dstPitch, int ui, long Width, long Height, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemsetD2D32AsyncNative(dstDevice, dstPitch, ui, Width, Height, hStream));
    }

    private static native int cuMemsetD2D32AsyncNative(CUdeviceptr var0, long var1, int var3, long var4, long var6, CUstream var8);

    public static int cuFuncGetAttribute(int[] pi, int attrib, CUfunction func) {
        return JCudaDriver.checkResult(JCudaDriver.cuFuncGetAttributeNative(pi, attrib, func));
    }

    private static native int cuFuncGetAttributeNative(int[] var0, int var1, CUfunction var2);

    public static int cuFuncSetAttribute(CUfunction hfunc, int attrib, int value) {
        return JCudaDriver.checkResult(JCudaDriver.cuFuncSetAttributeNative(hfunc, attrib, value));
    }

    private static native int cuFuncSetAttributeNative(CUfunction var0, int var1, int var2);

    @Deprecated
    public static int cuFuncSetBlockShape(CUfunction hfunc, int x, int y, int z) {
        return JCudaDriver.checkResult(JCudaDriver.cuFuncSetBlockShapeNative(hfunc, x, y, z));
    }

    private static native int cuFuncSetBlockShapeNative(CUfunction var0, int var1, int var2, int var3);

    @Deprecated
    public static int cuFuncSetSharedSize(CUfunction hfunc, int bytes) {
        return JCudaDriver.checkResult(JCudaDriver.cuFuncSetSharedSizeNative(hfunc, bytes));
    }

    private static native int cuFuncSetSharedSizeNative(CUfunction var0, int var1);

    public static int cuFuncSetCacheConfig(CUfunction hfunc, int config) {
        return JCudaDriver.checkResult(JCudaDriver.cuFuncSetCacheConfigNative(hfunc, config));
    }

    private static native int cuFuncSetCacheConfigNative(CUfunction var0, int var1);

    public static int cuFuncSetSharedMemConfig(CUfunction hfunc, int config) {
        return JCudaDriver.checkResult(JCudaDriver.cuFuncSetSharedMemConfigNative(hfunc, config));
    }

    private static native int cuFuncSetSharedMemConfigNative(CUfunction var0, int var1);

    public static int cuArrayCreate(CUarray pHandle, CUDA_ARRAY_DESCRIPTOR pAllocateArray) {
        return JCudaDriver.checkResult(JCudaDriver.cuArrayCreateNative(pHandle, pAllocateArray));
    }

    private static native int cuArrayCreateNative(CUarray var0, CUDA_ARRAY_DESCRIPTOR var1);

    public static int cuArrayGetDescriptor(CUDA_ARRAY_DESCRIPTOR pArrayDescriptor, CUarray hArray) {
        return JCudaDriver.checkResult(JCudaDriver.cuArrayGetDescriptorNative(pArrayDescriptor, hArray));
    }

    private static native int cuArrayGetDescriptorNative(CUDA_ARRAY_DESCRIPTOR var0, CUarray var1);

    public static int cuArrayGetSparseProperties(CUDA_ARRAY_SPARSE_PROPERTIES sparseProperties, CUarray array) {
        return JCudaDriver.checkResult(JCudaDriver.cuArrayGetSparsePropertiesNative(sparseProperties, array));
    }

    private static native int cuArrayGetSparsePropertiesNative(CUDA_ARRAY_SPARSE_PROPERTIES var0, CUarray var1);

    public static int cuMipmappedArrayGetSparseProperties(CUDA_ARRAY_SPARSE_PROPERTIES sparseProperties, CUmipmappedArray mipmap) {
        return JCudaDriver.checkResult(JCudaDriver.cuMipmappedArrayGetSparsePropertiesNative(sparseProperties, mipmap));
    }

    private static native int cuMipmappedArrayGetSparsePropertiesNative(CUDA_ARRAY_SPARSE_PROPERTIES var0, CUmipmappedArray var1);

    public static int cuArrayGetPlane(CUarray pPlaneArray, CUarray hArray, int planeIdx) {
        return JCudaDriver.checkResult(JCudaDriver.cuArrayGetPlaneNative(pPlaneArray, hArray, planeIdx));
    }

    private static native int cuArrayGetPlaneNative(CUarray var0, CUarray var1, int var2);

    public static int cuArrayGetMemoryRequirements(CUDA_ARRAY_MEMORY_REQUIREMENTS memoryRequirements, CUarray array, CUdevice device) {
        return JCudaDriver.checkResult(JCudaDriver.cuArrayGetMemoryRequirementsNative(memoryRequirements, array, device));
    }

    private static native int cuArrayGetMemoryRequirementsNative(CUDA_ARRAY_MEMORY_REQUIREMENTS var0, CUarray var1, CUdevice var2);

    public static int cuMipmappedArrayGetMemoryRequirements(CUDA_ARRAY_MEMORY_REQUIREMENTS memoryRequirements, CUmipmappedArray mipmap, CUdevice device) {
        return JCudaDriver.checkResult(JCudaDriver.cuMipmappedArrayGetMemoryRequirementsNative(memoryRequirements, mipmap, device));
    }

    private static native int cuMipmappedArrayGetMemoryRequirementsNative(CUDA_ARRAY_MEMORY_REQUIREMENTS var0, CUmipmappedArray var1, CUdevice var2);

    public static int cuArrayDestroy(CUarray hArray) {
        return JCudaDriver.checkResult(JCudaDriver.cuArrayDestroyNative(hArray));
    }

    private static native int cuArrayDestroyNative(CUarray var0);

    public static int cuArray3DCreate(CUarray pHandle, CUDA_ARRAY3D_DESCRIPTOR pAllocateArray) {
        return JCudaDriver.checkResult(JCudaDriver.cuArray3DCreateNative(pHandle, pAllocateArray));
    }

    private static native int cuArray3DCreateNative(CUarray var0, CUDA_ARRAY3D_DESCRIPTOR var1);

    public static int cuArray3DGetDescriptor(CUDA_ARRAY3D_DESCRIPTOR pArrayDescriptor, CUarray hArray) {
        return JCudaDriver.checkResult(JCudaDriver.cuArray3DGetDescriptorNative(pArrayDescriptor, hArray));
    }

    private static native int cuArray3DGetDescriptorNative(CUDA_ARRAY3D_DESCRIPTOR var0, CUarray var1);

    public static int cuMipmappedArrayCreate(CUmipmappedArray pHandle, CUDA_ARRAY3D_DESCRIPTOR pMipmappedArrayDesc, int numMipmapLevels) {
        return JCudaDriver.checkResult(JCudaDriver.cuMipmappedArrayCreateNative(pHandle, pMipmappedArrayDesc, numMipmapLevels));
    }

    private static native int cuMipmappedArrayCreateNative(CUmipmappedArray var0, CUDA_ARRAY3D_DESCRIPTOR var1, int var2);

    public static int cuMipmappedArrayGetLevel(CUarray pLevelArray, CUmipmappedArray hMipmappedArray, int level) {
        return JCudaDriver.checkResult(JCudaDriver.cuMipmappedArrayGetLevelNative(pLevelArray, hMipmappedArray, level));
    }

    private static native int cuMipmappedArrayGetLevelNative(CUarray var0, CUmipmappedArray var1, int var2);

    public static int cuMipmappedArrayDestroy(CUmipmappedArray hMipmappedArray) {
        return JCudaDriver.checkResult(JCudaDriver.cuMipmappedArrayDestroyNative(hMipmappedArray));
    }

    private static native int cuMipmappedArrayDestroyNative(CUmipmappedArray var0);

    public static int cuMemAddressReserve(CUdeviceptr ptr, long size, long alignment, CUdeviceptr addr, long flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemAddressReserveNative(ptr, size, alignment, addr, flags));
    }

    private static native int cuMemAddressReserveNative(CUdeviceptr var0, long var1, long var3, CUdeviceptr var5, long var6);

    public static int cuMemAddressFree(CUdeviceptr ptr, long size) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemAddressFreeNative(ptr, size));
    }

    private static native int cuMemAddressFreeNative(CUdeviceptr var0, long var1);

    public static int cuMemCreate(CUmemGenericAllocationHandle handle, long size, CUmemAllocationProp prop, long flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemCreateNative(handle, size, prop, flags));
    }

    private static native int cuMemCreateNative(CUmemGenericAllocationHandle var0, long var1, CUmemAllocationProp var3, long var4);

    public static int cuMemRelease(CUmemGenericAllocationHandle handle) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemReleaseNative(handle));
    }

    private static native int cuMemReleaseNative(CUmemGenericAllocationHandle var0);

    public static int cuMemMap(CUdeviceptr ptr, long size, long offset, CUmemGenericAllocationHandle handle, long flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemMapNative(ptr, size, offset, handle, flags));
    }

    private static native int cuMemMapNative(CUdeviceptr var0, long var1, long var3, CUmemGenericAllocationHandle var5, long var6);

    public static int cuMemMapArrayAsync(CUarrayMapInfo[] mapInfoList, int count, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemMapArrayAsyncNative(mapInfoList, count, hStream));
    }

    private static native int cuMemMapArrayAsyncNative(CUarrayMapInfo[] var0, int var1, CUstream var2);

    public static int cuMemUnmap(CUdeviceptr ptr, long size) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemUnmapNative(ptr, size));
    }

    private static native int cuMemUnmapNative(CUdeviceptr var0, long var1);

    public static int cuMemSetAccess(CUdeviceptr ptr, long size, CUmemAccessDesc[] desc, long count) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemSetAccessNative(ptr, size, desc, count));
    }

    private static native int cuMemSetAccessNative(CUdeviceptr var0, long var1, CUmemAccessDesc[] var3, long var4);

    public static int cuMemGetAccess(long[] flags, CUmemLocation location, CUdeviceptr ptr) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemGetAccessNative(flags, location, ptr));
    }

    private static native int cuMemGetAccessNative(long[] var0, CUmemLocation var1, CUdeviceptr var2);

    public static int cuMemExportToShareableHandle(Pointer shareableHandle, CUmemGenericAllocationHandle handle, int handleType, long flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemExportToShareableHandleNative(shareableHandle, handle, handleType, flags));
    }

    private static native int cuMemExportToShareableHandleNative(Pointer var0, CUmemGenericAllocationHandle var1, int var2, long var3);

    public static int cuMemImportFromShareableHandle(CUmemGenericAllocationHandle handle, Pointer osHandle, int shHandleType) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemImportFromShareableHandleNative(handle, osHandle, shHandleType));
    }

    private static native int cuMemImportFromShareableHandleNative(CUmemGenericAllocationHandle var0, Pointer var1, int var2);

    public static int cuMemGetAllocationGranularity(long[] granularity, CUmemAllocationProp prop, int option) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemGetAllocationGranularityNative(granularity, prop, option));
    }

    private static native int cuMemGetAllocationGranularityNative(long[] var0, CUmemAllocationProp var1, int var2);

    public static int cuMemGetAllocationPropertiesFromHandle(CUmemAllocationProp prop, CUmemGenericAllocationHandle handle) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemGetAllocationPropertiesFromHandleNative(prop, handle));
    }

    private static native int cuMemGetAllocationPropertiesFromHandleNative(CUmemAllocationProp var0, CUmemGenericAllocationHandle var1);

    public static int cuMemRetainAllocationHandle(CUmemGenericAllocationHandle handle, Pointer addr) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemRetainAllocationHandleNative(handle, addr));
    }

    private static native int cuMemRetainAllocationHandleNative(CUmemGenericAllocationHandle var0, Pointer var1);

    public static int cuMemFreeAsync(CUdeviceptr dptr, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemFreeAsyncNative(dptr, hStream));
    }

    private static native int cuMemFreeAsyncNative(CUdeviceptr var0, CUstream var1);

    @Deprecated
    public static int cuTexRefCreate(CUtexref pTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefCreateNative(pTexRef));
    }

    private static native int cuTexRefCreateNative(CUtexref var0);

    @Deprecated
    public static int cuTexRefDestroy(CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefDestroyNative(hTexRef));
    }

    private static native int cuTexRefDestroyNative(CUtexref var0);

    public static int cuTexRefSetArray(CUtexref hTexRef, CUarray hArray, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetArrayNative(hTexRef, hArray, Flags));
    }

    private static native int cuTexRefSetArrayNative(CUtexref var0, CUarray var1, int var2);

    public static int cuTexRefSetMipmappedArray(CUtexref hTexRef, CUmipmappedArray hMipmappedArray, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetMipmappedArrayNative(hTexRef, hMipmappedArray, Flags));
    }

    private static native int cuTexRefSetMipmappedArrayNative(CUtexref var0, CUmipmappedArray var1, int var2);

    public static int cuTexRefSetAddress(long[] ByteOffset, CUtexref hTexRef, CUdeviceptr dptr, long bytes) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetAddressNative(ByteOffset, hTexRef, dptr, bytes));
    }

    private static native int cuTexRefSetAddressNative(long[] var0, CUtexref var1, CUdeviceptr var2, long var3);

    public static int cuTexRefSetFormat(CUtexref hTexRef, int fmt, int NumPackedComponents) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetFormatNative(hTexRef, fmt, NumPackedComponents));
    }

    private static native int cuTexRefSetFormatNative(CUtexref var0, int var1, int var2);

    public static int cuTexRefSetAddress2D(CUtexref hTexRef, CUDA_ARRAY_DESCRIPTOR desc, CUdeviceptr dptr, long PitchInBytes) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetAddress2DNative(hTexRef, desc, dptr, PitchInBytes));
    }

    private static native int cuTexRefSetAddress2DNative(CUtexref var0, CUDA_ARRAY_DESCRIPTOR var1, CUdeviceptr var2, long var3);

    public static int cuTexRefSetAddressMode(CUtexref hTexRef, int dim, int am) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetAddressModeNative(hTexRef, dim, am));
    }

    private static native int cuTexRefSetAddressModeNative(CUtexref var0, int var1, int var2);

    public static int cuTexRefSetFilterMode(CUtexref hTexRef, int fm) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetFilterModeNative(hTexRef, fm));
    }

    private static native int cuTexRefSetFilterModeNative(CUtexref var0, int var1);

    public static int cuTexRefSetMipmapFilterMode(CUtexref hTexRef, int fm) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetMipmapFilterModeNative(hTexRef, fm));
    }

    private static native int cuTexRefSetMipmapFilterModeNative(CUtexref var0, int var1);

    public static int cuTexRefSetMipmapLevelBias(CUtexref hTexRef, float bias) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetMipmapLevelBiasNative(hTexRef, bias));
    }

    private static native int cuTexRefSetMipmapLevelBiasNative(CUtexref var0, float var1);

    public static int cuTexRefSetMipmapLevelClamp(CUtexref hTexRef, float minMipmapLevelClamp, float maxMipmapLevelClamp) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetMipmapLevelClampNative(hTexRef, minMipmapLevelClamp, maxMipmapLevelClamp));
    }

    private static native int cuTexRefSetMipmapLevelClampNative(CUtexref var0, float var1, float var2);

    public static int cuTexRefSetMaxAnisotropy(CUtexref hTexRef, int maxAniso) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetMaxAnisotropyNative(hTexRef, maxAniso));
    }

    private static native int cuTexRefSetMaxAnisotropyNative(CUtexref var0, int var1);

    public static int cuTexRefSetBorderColor(CUtexref hTexRef, float[] pBorderColor) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetBorderColorNative(hTexRef, pBorderColor));
    }

    private static native int cuTexRefSetBorderColorNative(CUtexref var0, float[] var1);

    public static int cuTexRefSetFlags(CUtexref hTexRef, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefSetFlagsNative(hTexRef, Flags));
    }

    private static native int cuTexRefSetFlagsNative(CUtexref var0, int var1);

    public static int cuTexRefGetAddress(CUdeviceptr pdptr, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetAddressNative(pdptr, hTexRef));
    }

    private static native int cuTexRefGetAddressNative(CUdeviceptr var0, CUtexref var1);

    public static int cuTexRefGetArray(CUarray phArray, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetArrayNative(phArray, hTexRef));
    }

    private static native int cuTexRefGetArrayNative(CUarray var0, CUtexref var1);

    public static int cuTexRefGetMipmappedArray(CUmipmappedArray phMipmappedArray, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetMipmappedArrayNative(phMipmappedArray, hTexRef));
    }

    private static native int cuTexRefGetMipmappedArrayNative(CUmipmappedArray var0, CUtexref var1);

    public static int cuTexRefGetAddressMode(int[] pam, CUtexref hTexRef, int dim) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetAddressModeNative(pam, hTexRef, dim));
    }

    private static native int cuTexRefGetAddressModeNative(int[] var0, CUtexref var1, int var2);

    public static int cuTexRefGetFilterMode(int[] pfm, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetFilterModeNative(pfm, hTexRef));
    }

    private static native int cuTexRefGetFilterModeNative(int[] var0, CUtexref var1);

    public static int cuTexRefGetFormat(int[] pFormat, int[] pNumChannels, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetFormatNative(pFormat, pNumChannels, hTexRef));
    }

    private static native int cuTexRefGetFormatNative(int[] var0, int[] var1, CUtexref var2);

    public static int cuTexRefGetMipmapFilterMode(int[] pfm, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetMipmapFilterModeNative(pfm, hTexRef));
    }

    private static native int cuTexRefGetMipmapFilterModeNative(int[] var0, CUtexref var1);

    public static int cuTexRefGetMipmapLevelBias(float[] pbias, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetMipmapLevelBiasNative(pbias, hTexRef));
    }

    private static native int cuTexRefGetMipmapLevelBiasNative(float[] var0, CUtexref var1);

    public static int cuTexRefGetMipmapLevelClamp(float[] pminMipmapLevelClamp, float[] pmaxMipmapLevelClamp, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetMipmapLevelClampNative(pminMipmapLevelClamp, pmaxMipmapLevelClamp, hTexRef));
    }

    private static native int cuTexRefGetMipmapLevelClampNative(float[] var0, float[] var1, CUtexref var2);

    public static int cuTexRefGetMaxAnisotropy(int[] pmaxAniso, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetMaxAnisotropyNative(pmaxAniso, hTexRef));
    }

    private static native int cuTexRefGetMaxAnisotropyNative(int[] var0, CUtexref var1);

    public static int cuTexRefGetBorderColor(float[] pBorderColor, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetBorderColorNative(pBorderColor, hTexRef));
    }

    private static native int cuTexRefGetBorderColorNative(float[] var0, CUtexref var1);

    public static int cuTexRefGetFlags(int[] pFlags, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexRefGetFlagsNative(pFlags, hTexRef));
    }

    private static native int cuTexRefGetFlagsNative(int[] var0, CUtexref var1);

    public static int cuSurfRefSetArray(CUsurfref hSurfRef, CUarray hArray, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuSurfRefSetArrayNative(hSurfRef, hArray, Flags));
    }

    private static native int cuSurfRefSetArrayNative(CUsurfref var0, CUarray var1, int var2);

    public static int cuSurfRefGetArray(CUarray phArray, CUsurfref hSurfRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuSurfRefGetArrayNative(phArray, hSurfRef));
    }

    private static native int cuSurfRefGetArrayNative(CUarray var0, CUsurfref var1);

    public static int cuTexObjectCreate(CUtexObject pTexObject, CUDA_RESOURCE_DESC pResDesc, CUDA_TEXTURE_DESC pTexDesc, CUDA_RESOURCE_VIEW_DESC pResViewDesc) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexObjectCreateNative(pTexObject, pResDesc, pTexDesc, pResViewDesc));
    }

    private static native int cuTexObjectCreateNative(CUtexObject var0, CUDA_RESOURCE_DESC var1, CUDA_TEXTURE_DESC var2, CUDA_RESOURCE_VIEW_DESC var3);

    public static int cuTexObjectDestroy(CUtexObject texObject) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexObjectDestroyNative(texObject));
    }

    private static native int cuTexObjectDestroyNative(CUtexObject var0);

    public static int cuTexObjectGetResourceDesc(CUDA_RESOURCE_DESC pResDesc, CUtexObject texObject) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexObjectGetResourceDescNative(pResDesc, texObject));
    }

    private static native int cuTexObjectGetResourceDescNative(CUDA_RESOURCE_DESC var0, CUtexObject var1);

    public static int cuTexObjectGetTextureDesc(CUDA_TEXTURE_DESC pTexDesc, CUtexObject texObject) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexObjectGetTextureDescNative(pTexDesc, texObject));
    }

    private static native int cuTexObjectGetTextureDescNative(CUDA_TEXTURE_DESC var0, CUtexObject var1);

    public static int cuTexObjectGetResourceViewDesc(CUDA_RESOURCE_VIEW_DESC pResViewDesc, CUtexObject texObject) {
        return JCudaDriver.checkResult(JCudaDriver.cuTexObjectGetResourceViewDescNative(pResViewDesc, texObject));
    }

    private static native int cuTexObjectGetResourceViewDescNative(CUDA_RESOURCE_VIEW_DESC var0, CUtexObject var1);

    public static int cuSurfObjectCreate(CUsurfObject pSurfObject, CUDA_RESOURCE_DESC pResDesc) {
        return JCudaDriver.checkResult(JCudaDriver.cuSurfObjectCreateNative(pSurfObject, pResDesc));
    }

    private static native int cuSurfObjectCreateNative(CUsurfObject var0, CUDA_RESOURCE_DESC var1);

    public static int cuSurfObjectDestroy(CUsurfObject surfObject) {
        return JCudaDriver.checkResult(JCudaDriver.cuSurfObjectDestroyNative(surfObject));
    }

    private static native int cuSurfObjectDestroyNative(CUsurfObject var0);

    public static int cuSurfObjectGetResourceDesc(CUDA_RESOURCE_DESC pResDesc, CUsurfObject surfObject) {
        return JCudaDriver.checkResult(JCudaDriver.cuSurfObjectGetResourceDescNative(pResDesc, surfObject));
    }

    private static native int cuSurfObjectGetResourceDescNative(CUDA_RESOURCE_DESC var0, CUsurfObject var1);

    public static int cuDeviceCanAccessPeer(int[] canAccessPeer, CUdevice dev, CUdevice peerDev) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceCanAccessPeerNative(canAccessPeer, dev, peerDev));
    }

    private static native int cuDeviceCanAccessPeerNative(int[] var0, CUdevice var1, CUdevice var2);

    public static int cuDeviceGetP2PAttribute(int[] value, int attrib, CUdevice srcDevice, CUdevice dstDevice) {
        return JCudaDriver.checkResult(JCudaDriver.cuDeviceGetP2PAttributeNative(value, attrib, srcDevice, dstDevice));
    }

    private static native int cuDeviceGetP2PAttributeNative(int[] var0, int var1, CUdevice var2, CUdevice var3);

    public static int cuCtxEnablePeerAccess(CUcontext peerContext, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxEnablePeerAccessNative(peerContext, Flags));
    }

    private static native int cuCtxEnablePeerAccessNative(CUcontext var0, int var1);

    public static int cuCtxDisablePeerAccess(CUcontext peerContext) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxDisablePeerAccessNative(peerContext));
    }

    private static native int cuCtxDisablePeerAccessNative(CUcontext var0);

    @Deprecated
    public static int cuParamSetSize(CUfunction hfunc, int numbytes) {
        return JCudaDriver.checkResult(JCudaDriver.cuParamSetSizeNative(hfunc, numbytes));
    }

    private static native int cuParamSetSizeNative(CUfunction var0, int var1);

    @Deprecated
    public static int cuParamSeti(CUfunction hfunc, int offset, int value) {
        return JCudaDriver.checkResult(JCudaDriver.cuParamSetiNative(hfunc, offset, value));
    }

    private static native int cuParamSetiNative(CUfunction var0, int var1, int var2);

    @Deprecated
    public static int cuParamSetf(CUfunction hfunc, int offset, float value) {
        return JCudaDriver.checkResult(JCudaDriver.cuParamSetfNative(hfunc, offset, value));
    }

    private static native int cuParamSetfNative(CUfunction var0, int var1, float var2);

    @Deprecated
    public static int cuParamSetv(CUfunction hfunc, int offset, Pointer ptr, int numbytes) {
        return JCudaDriver.checkResult(JCudaDriver.cuParamSetvNative(hfunc, offset, ptr, numbytes));
    }

    private static native int cuParamSetvNative(CUfunction var0, int var1, Pointer var2, int var3);

    @Deprecated
    public static int cuParamSetTexRef(CUfunction hfunc, int texunit, CUtexref hTexRef) {
        return JCudaDriver.checkResult(JCudaDriver.cuParamSetTexRefNative(hfunc, texunit, hTexRef));
    }

    private static native int cuParamSetTexRefNative(CUfunction var0, int var1, CUtexref var2);

    public static int cuGraphCreate(CUgraph phGraph, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphCreateNative(phGraph, flags));
    }

    private static native int cuGraphCreateNative(CUgraph var0, int var1);

    public static int cuGraphAddKernelNode(CUgraphNode phGraphNode, CUgraph hGraph, CUgraphNode[] dependencies, long numDependencies, CUDA_KERNEL_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddKernelNodeNative(phGraphNode, hGraph, dependencies, numDependencies, nodeParams));
    }

    private static native int cuGraphAddKernelNodeNative(CUgraphNode var0, CUgraph var1, CUgraphNode[] var2, long var3, CUDA_KERNEL_NODE_PARAMS var5);

    public static int cuGraphKernelNodeGetParams(CUgraphNode hNode, CUDA_KERNEL_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphKernelNodeGetParamsNative(hNode, nodeParams));
    }

    private static native int cuGraphKernelNodeGetParamsNative(CUgraphNode var0, CUDA_KERNEL_NODE_PARAMS var1);

    public static int cuGraphKernelNodeSetParams(CUgraphNode hNode, CUDA_KERNEL_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphKernelNodeSetParamsNative(hNode, nodeParams));
    }

    private static native int cuGraphKernelNodeSetParamsNative(CUgraphNode var0, CUDA_KERNEL_NODE_PARAMS var1);

    public static int cuGraphAddMemcpyNode(CUgraphNode phGraphNode, CUgraph hGraph, CUgraphNode[] dependencies, long numDependencies, CUDA_MEMCPY3D copyParams, CUcontext ctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddMemcpyNodeNative(phGraphNode, hGraph, dependencies, numDependencies, copyParams, ctx));
    }

    private static native int cuGraphAddMemcpyNodeNative(CUgraphNode var0, CUgraph var1, CUgraphNode[] var2, long var3, CUDA_MEMCPY3D var5, CUcontext var6);

    public static int cuGraphMemcpyNodeGetParams(CUgraphNode hNode, CUDA_MEMCPY3D nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphMemcpyNodeGetParamsNative(hNode, nodeParams));
    }

    private static native int cuGraphMemcpyNodeGetParamsNative(CUgraphNode var0, CUDA_MEMCPY3D var1);

    public static int cuGraphMemcpyNodeSetParams(CUgraphNode hNode, CUDA_MEMCPY3D nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphMemcpyNodeSetParamsNative(hNode, nodeParams));
    }

    private static native int cuGraphMemcpyNodeSetParamsNative(CUgraphNode var0, CUDA_MEMCPY3D var1);

    public static int cuGraphAddMemsetNode(CUgraphNode phGraphNode, CUgraph hGraph, CUgraphNode[] dependencies, long numDependencies, CUDA_MEMSET_NODE_PARAMS memsetParams, CUcontext ctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddMemsetNodeNative(phGraphNode, hGraph, dependencies, numDependencies, memsetParams, ctx));
    }

    private static native int cuGraphAddMemsetNodeNative(CUgraphNode var0, CUgraph var1, CUgraphNode[] var2, long var3, CUDA_MEMSET_NODE_PARAMS var5, CUcontext var6);

    public static int cuGraphMemsetNodeGetParams(CUgraphNode hNode, CUDA_MEMSET_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphMemsetNodeGetParamsNative(hNode, nodeParams));
    }

    private static native int cuGraphMemsetNodeGetParamsNative(CUgraphNode var0, CUDA_MEMSET_NODE_PARAMS var1);

    public static int cuGraphMemsetNodeSetParams(CUgraphNode hNode, CUDA_MEMSET_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphMemsetNodeSetParamsNative(hNode, nodeParams));
    }

    private static native int cuGraphMemsetNodeSetParamsNative(CUgraphNode var0, CUDA_MEMSET_NODE_PARAMS var1);

    public static int cuGraphAddHostNode(CUgraphNode phGraphNode, CUgraph hGraph, CUgraphNode[] dependencies, long numDependencies, CUDA_HOST_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddHostNodeNative(phGraphNode, hGraph, dependencies, numDependencies, nodeParams));
    }

    private static native int cuGraphAddHostNodeNative(CUgraphNode var0, CUgraph var1, CUgraphNode[] var2, long var3, CUDA_HOST_NODE_PARAMS var5);

    public static int cuGraphHostNodeGetParams(CUgraphNode hNode, CUDA_HOST_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphHostNodeGetParamsNative(hNode, nodeParams));
    }

    private static native int cuGraphHostNodeGetParamsNative(CUgraphNode var0, CUDA_HOST_NODE_PARAMS var1);

    public static int cuGraphHostNodeSetParams(CUgraphNode hNode, CUDA_HOST_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphHostNodeSetParamsNative(hNode, nodeParams));
    }

    private static native int cuGraphHostNodeSetParamsNative(CUgraphNode var0, CUDA_HOST_NODE_PARAMS var1);

    public static int cuGraphAddChildGraphNode(CUgraphNode phGraphNode, CUgraph hGraph, CUgraphNode[] dependencies, long numDependencies, CUgraph childGraph) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddChildGraphNodeNative(phGraphNode, hGraph, dependencies, numDependencies, childGraph));
    }

    private static native int cuGraphAddChildGraphNodeNative(CUgraphNode var0, CUgraph var1, CUgraphNode[] var2, long var3, CUgraph var5);

    public static int cuGraphChildGraphNodeGetGraph(CUgraphNode hNode, CUgraph phGraph) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphChildGraphNodeGetGraphNative(hNode, phGraph));
    }

    private static native int cuGraphChildGraphNodeGetGraphNative(CUgraphNode var0, CUgraph var1);

    public static int cuGraphAddEmptyNode(CUgraphNode phGraphNode, CUgraph hGraph, CUgraphNode[] dependencies, long numDependencies) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddEmptyNodeNative(phGraphNode, hGraph, dependencies, numDependencies));
    }

    private static native int cuGraphAddEmptyNodeNative(CUgraphNode var0, CUgraph var1, CUgraphNode[] var2, long var3);

    public static int cuGraphAddEventRecordNode(CUgraphNode phGraphNode, CUgraph hGraph, CUgraphNode[] dependencies, long numDependencies, CUevent event) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddEventRecordNodeNative(phGraphNode, hGraph, dependencies, numDependencies, event));
    }

    private static native int cuGraphAddEventRecordNodeNative(CUgraphNode var0, CUgraph var1, CUgraphNode[] var2, long var3, CUevent var5);

    public static int cuGraphEventRecordNodeGetEvent(CUgraphNode hNode, CUevent event_out) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphEventRecordNodeGetEventNative(hNode, event_out));
    }

    private static native int cuGraphEventRecordNodeGetEventNative(CUgraphNode var0, CUevent var1);

    public static int cuGraphEventRecordNodeSetEvent(CUgraphNode hNode, CUevent event) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphEventRecordNodeSetEventNative(hNode, event));
    }

    private static native int cuGraphEventRecordNodeSetEventNative(CUgraphNode var0, CUevent var1);

    public static int cuGraphAddEventWaitNode(CUgraphNode phGraphNode, CUgraph hGraph, CUgraphNode[] dependencies, long numDependencies, CUevent event) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddEventWaitNodeNative(phGraphNode, hGraph, dependencies, numDependencies, event));
    }

    private static native int cuGraphAddEventWaitNodeNative(CUgraphNode var0, CUgraph var1, CUgraphNode[] var2, long var3, CUevent var5);

    public static int cuGraphEventWaitNodeGetEvent(CUgraphNode hNode, CUevent event_out) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphEventWaitNodeGetEventNative(hNode, event_out));
    }

    private static native int cuGraphEventWaitNodeGetEventNative(CUgraphNode var0, CUevent var1);

    public static int cuGraphEventWaitNodeSetEvent(CUgraphNode hNode, CUevent event) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphEventWaitNodeSetEventNative(hNode, event));
    }

    private static native int cuGraphEventWaitNodeSetEventNative(CUgraphNode var0, CUevent var1);

    public static int cuGraphClone(CUgraph phGraphClone, CUgraph originalGraph) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphCloneNative(phGraphClone, originalGraph));
    }

    private static native int cuGraphCloneNative(CUgraph var0, CUgraph var1);

    public static int cuGraphNodeFindInClone(CUgraphNode phNode, CUgraphNode hOriginalNode, CUgraph hClonedGraph) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphNodeFindInCloneNative(phNode, hOriginalNode, hClonedGraph));
    }

    private static native int cuGraphNodeFindInCloneNative(CUgraphNode var0, CUgraphNode var1, CUgraph var2);

    public static int cuGraphNodeGetType(CUgraphNode hNode, int[] type) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphNodeGetTypeNative(hNode, type));
    }

    private static native int cuGraphNodeGetTypeNative(CUgraphNode var0, int[] var1);

    public static int cuGraphGetNodes(CUgraph hGraph, CUgraphNode[] nodes, long[] numNodes) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphGetNodesNative(hGraph, nodes, numNodes));
    }

    private static native int cuGraphGetNodesNative(CUgraph var0, CUgraphNode[] var1, long[] var2);

    public static int cuGraphGetRootNodes(CUgraph hGraph, CUgraphNode[] rootNodes, long[] numRootNodes) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphGetRootNodesNative(hGraph, rootNodes, numRootNodes));
    }

    private static native int cuGraphGetRootNodesNative(CUgraph var0, CUgraphNode[] var1, long[] var2);

    public static int cuGraphGetEdges(CUgraph hGraph, CUgraphNode[] from, CUgraphNode[] to, long[] numEdges) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphGetEdgesNative(hGraph, from, to, numEdges));
    }

    private static native int cuGraphGetEdgesNative(CUgraph var0, CUgraphNode[] var1, CUgraphNode[] var2, long[] var3);

    public static int cuGraphNodeGetDependencies(CUgraphNode hNode, CUgraphNode[] dependencies, long[] numDependencies) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphNodeGetDependenciesNative(hNode, dependencies, numDependencies));
    }

    private static native int cuGraphNodeGetDependenciesNative(CUgraphNode var0, CUgraphNode[] var1, long[] var2);

    public static int cuGraphNodeGetDependentNodes(CUgraphNode hNode, CUgraphNode[] dependentNodes, long[] numDependentNodes) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphNodeGetDependentNodesNative(hNode, dependentNodes, numDependentNodes));
    }

    private static native int cuGraphNodeGetDependentNodesNative(CUgraphNode var0, CUgraphNode[] var1, long[] var2);

    public static int cuGraphAddDependencies(CUgraph hGraph, CUgraphNode[] from, CUgraphNode[] to, long numDependencies) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphAddDependenciesNative(hGraph, from, to, numDependencies));
    }

    private static native int cuGraphAddDependenciesNative(CUgraph var0, CUgraphNode[] var1, CUgraphNode[] var2, long var3);

    public static int cuGraphRemoveDependencies(CUgraph hGraph, CUgraphNode[] from, CUgraphNode[] to, long numDependencies) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphRemoveDependenciesNative(hGraph, from, to, numDependencies));
    }

    private static native int cuGraphRemoveDependenciesNative(CUgraph var0, CUgraphNode[] var1, CUgraphNode[] var2, long var3);

    public static int cuGraphDestroyNode(CUgraphNode hNode) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphDestroyNodeNative(hNode));
    }

    private static native int cuGraphDestroyNodeNative(CUgraphNode var0);

    public static int cuGraphInstantiate(CUgraphExec phGraphExec, CUgraph hGraph, long flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphInstantiateNative(phGraphExec, hGraph, flags));
    }

    private static native int cuGraphInstantiateNative(CUgraphExec var0, CUgraph var1, long var2);

    public static int cuGraphExecKernelNodeSetParams(CUgraphExec hGraphExec, CUgraphNode hNode, CUDA_KERNEL_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphExecKernelNodeSetParamsNative(hGraphExec, hNode, nodeParams));
    }

    private static native int cuGraphExecKernelNodeSetParamsNative(CUgraphExec var0, CUgraphNode var1, CUDA_KERNEL_NODE_PARAMS var2);

    public static int cuGraphExecMemcpyNodeSetParams(CUgraphExec hGraphExec, CUgraphNode hNode, CUDA_MEMCPY3D copyParams, CUcontext ctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphExecMemcpyNodeSetParamsNative(hGraphExec, hNode, copyParams, ctx));
    }

    private static native int cuGraphExecMemcpyNodeSetParamsNative(CUgraphExec var0, CUgraphNode var1, CUDA_MEMCPY3D var2, CUcontext var3);

    public static int cuGraphExecMemsetNodeSetParams(CUgraphExec hGraphExec, CUgraphNode hNode, CUDA_MEMSET_NODE_PARAMS memsetParams, CUcontext ctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphExecMemsetNodeSetParamsNative(hGraphExec, hNode, memsetParams, ctx));
    }

    private static native int cuGraphExecMemsetNodeSetParamsNative(CUgraphExec var0, CUgraphNode var1, CUDA_MEMSET_NODE_PARAMS var2, CUcontext var3);

    public static int cuGraphExecHostNodeSetParams(CUgraphExec hGraphExec, CUgraphNode hNode, CUDA_HOST_NODE_PARAMS nodeParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphExecHostNodeSetParamsNative(hGraphExec, hNode, nodeParams));
    }

    private static native int cuGraphExecHostNodeSetParamsNative(CUgraphExec var0, CUgraphNode var1, CUDA_HOST_NODE_PARAMS var2);

    public static int cuGraphExecChildGraphNodeSetParams(CUgraphExec hGraphExec, CUgraphNode hNode, CUgraph childGraph) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphExecChildGraphNodeSetParamsNative(hGraphExec, hNode, childGraph));
    }

    private static native int cuGraphExecChildGraphNodeSetParamsNative(CUgraphExec var0, CUgraphNode var1, CUgraph var2);

    public static int cuGraphExecEventRecordNodeSetEvent(CUgraphExec hGraphExec, CUgraphNode hNode, CUevent event) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphExecEventRecordNodeSetEventNative(hGraphExec, hNode, event));
    }

    private static native int cuGraphExecEventRecordNodeSetEventNative(CUgraphExec var0, CUgraphNode var1, CUevent var2);

    public static int cuGraphExecEventWaitNodeSetEvent(CUgraphExec hGraphExec, CUgraphNode hNode, CUevent event) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphExecEventWaitNodeSetEventNative(hGraphExec, hNode, event));
    }

    private static native int cuGraphExecEventWaitNodeSetEventNative(CUgraphExec var0, CUgraphNode var1, CUevent var2);

    public static int cuGraphExecExternalSemaphoresSignalNodeSetParams(CUgraphExec hGraphExec, CUgraphNode hNode, CUDA_EXT_SEM_SIGNAL_NODE_PARAMS[] nodeParams) {
        throw new UnsupportedOperationException("The cuGraphExecExternalSemaphoresSignalNodeSetParams function is not supported in JCuda");
    }

    public static int cuGraphExecExternalSemaphoresWaitNodeSetParams(CUgraphExec hGraphExec, CUgraphNode hNode, CUDA_EXT_SEM_WAIT_NODE_PARAMS[] nodeParams) {
        throw new UnsupportedOperationException("The cuGraphExecExternalSemaphoresWaitNodeSetParams function is not supported in JCuda");
    }

    public static int cuGraphUpload(CUgraphExec hGraphExec, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphUploadNative(hGraphExec, hStream));
    }

    private static native int cuGraphUploadNative(CUgraphExec var0, CUstream var1);

    public static int cuGraphLaunch(CUgraphExec hGraphExec, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphLaunchNative(hGraphExec, hStream));
    }

    private static native int cuGraphLaunchNative(CUgraphExec var0, CUstream var1);

    public static int cuGraphExecDestroy(CUgraphExec hGraphExec) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphExecDestroyNative(hGraphExec));
    }

    private static native int cuGraphExecDestroyNative(CUgraphExec var0);

    public static int cuGraphDestroy(CUgraph hGraph) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphDestroyNative(hGraph));
    }

    private static native int cuGraphDestroyNative(CUgraph var0);

    public static int cuGraphExecUpdate(CUgraphExec hGraphExec, CUgraph hGraph, CUgraphNode hErrorNode_out, int[] updateResult_out) {
        throw new UnsupportedOperationException("This function no longer exists in CUDA 12");
    }

    public static int cuGraphKernelNodeCopyAttributes(CUgraphNode dst, CUgraphNode src) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphKernelNodeCopyAttributesNative(dst, src));
    }

    private static native int cuGraphKernelNodeCopyAttributesNative(CUgraphNode var0, CUgraphNode var1);

    public static int cuGraphKernelNodeGetAttribute(CUgraphNode hNode, int attr, CUkernelNodeAttrValue value_out) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphKernelNodeGetAttributeNative(hNode, attr, value_out));
    }

    private static native int cuGraphKernelNodeGetAttributeNative(CUgraphNode var0, int var1, CUkernelNodeAttrValue var2);

    public static int cuGraphKernelNodeSetAttribute(CUgraphNode hNode, int attr, CUkernelNodeAttrValue value) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphKernelNodeSetAttributeNative(hNode, attr, value));
    }

    private static native int cuGraphKernelNodeSetAttributeNative(CUgraphNode var0, int var1, CUkernelNodeAttrValue var2);

    public static int cuOccupancyMaxActiveBlocksPerMultiprocessor(int[] numBlocks, CUfunction func, int blockSize, long dynamicSMemSize) {
        return JCudaDriver.checkResult(JCudaDriver.cuOccupancyMaxActiveBlocksPerMultiprocessorNative(numBlocks, func, blockSize, dynamicSMemSize));
    }

    private static native int cuOccupancyMaxActiveBlocksPerMultiprocessorNative(int[] var0, CUfunction var1, int var2, long var3);

    public static int cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(int[] numBlocks, CUfunction func, int blockSize, long dynamicSMemSize, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsNative(numBlocks, func, blockSize, dynamicSMemSize, flags));
    }

    private static native int cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsNative(int[] var0, CUfunction var1, int var2, long var3, int var5);

    public static int cuOccupancyAvailableDynamicSMemPerBlock(long[] dynamicSmemSize, CUfunction func, int numBlocks, int blockSize) {
        return JCudaDriver.checkResult(JCudaDriver.cuOccupancyAvailableDynamicSMemPerBlockNative(dynamicSmemSize, func, numBlocks, blockSize));
    }

    private static native int cuOccupancyAvailableDynamicSMemPerBlockNative(long[] var0, CUfunction var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int cuOccupancyMaxPotentialBlockSize(int[] minGridSize, int[] blockSize, CUfunction func, CUoccupancyB2DSize blockSizeToDynamicSMemSize, long dynamicSMemSize, int blockSizeLimit) {
        Object object = OCCUPANCY_LOCK;
        synchronized (object) {
            return JCudaDriver.checkResult(JCudaDriver.cuOccupancyMaxPotentialBlockSizeNative(minGridSize, blockSize, func, blockSizeToDynamicSMemSize, dynamicSMemSize, blockSizeLimit));
        }
    }

    private static native int cuOccupancyMaxPotentialBlockSizeNative(int[] var0, int[] var1, CUfunction var2, CUoccupancyB2DSize var3, long var4, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int cuOccupancyMaxPotentialBlockSizeWithFlags(int[] minGridSize, int[] blockSize, CUfunction func, CUoccupancyB2DSize blockSizeToDynamicSMemSize, long dynamicSMemSize, int blockSizeLimit, int flags) {
        Object object = OCCUPANCY_LOCK;
        synchronized (object) {
            return JCudaDriver.checkResult(JCudaDriver.cuOccupancyMaxPotentialBlockSizeWithFlagsNative(minGridSize, blockSize, func, blockSizeToDynamicSMemSize, dynamicSMemSize, blockSizeLimit, flags));
        }
    }

    private static native int cuOccupancyMaxPotentialBlockSizeWithFlagsNative(int[] var0, int[] var1, CUfunction var2, CUoccupancyB2DSize var3, long var4, int var6, int var7);

    @Deprecated
    public static int cuLaunch(CUfunction f) {
        return JCudaDriver.checkResult(JCudaDriver.cuLaunchNative(f));
    }

    private static native int cuLaunchNative(CUfunction var0);

    @Deprecated
    public static int cuLaunchGrid(CUfunction f, int grid_width, int grid_height) {
        return JCudaDriver.checkResult(JCudaDriver.cuLaunchGridNative(f, grid_width, grid_height));
    }

    private static native int cuLaunchGridNative(CUfunction var0, int var1, int var2);

    @Deprecated
    public static int cuLaunchGridAsync(CUfunction f, int grid_width, int grid_height, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuLaunchGridAsyncNative(f, grid_width, grid_height, hStream));
    }

    private static native int cuLaunchGridAsyncNative(CUfunction var0, int var1, int var2, CUstream var3);

    public static int cuEventCreate(CUevent phEvent, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuEventCreateNative(phEvent, Flags));
    }

    private static native int cuEventCreateNative(CUevent var0, int var1);

    public static int cuEventRecord(CUevent hEvent, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuEventRecordNative(hEvent, hStream));
    }

    private static native int cuEventRecordNative(CUevent var0, CUstream var1);

    public static int cuEventRecordWithFlags(CUevent hEvent, CUstream hStream, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuEventRecordWithFlagsNative(hEvent, hStream, flags));
    }

    private static native int cuEventRecordWithFlagsNative(CUevent var0, CUstream var1, int var2);

    public static int cuEventQuery(CUevent hEvent) {
        return JCudaDriver.checkResult(JCudaDriver.cuEventQueryNative(hEvent));
    }

    private static native int cuEventQueryNative(CUevent var0);

    public static int cuEventSynchronize(CUevent hEvent) {
        return JCudaDriver.checkResult(JCudaDriver.cuEventSynchronizeNative(hEvent));
    }

    private static native int cuEventSynchronizeNative(CUevent var0);

    public static int cuEventDestroy(CUevent hEvent) {
        return JCudaDriver.checkResult(JCudaDriver.cuEventDestroyNative(hEvent));
    }

    private static native int cuEventDestroyNative(CUevent var0);

    public static int cuEventElapsedTime(float[] pMilliseconds, CUevent hStart, CUevent hEnd) {
        return JCudaDriver.checkResult(JCudaDriver.cuEventElapsedTimeNative(pMilliseconds, hStart, hEnd));
    }

    private static native int cuEventElapsedTimeNative(float[] var0, CUevent var1, CUevent var2);

    public static int cuStreamWaitValue32(CUstream stream, CUdeviceptr addr, int value, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamWaitValue32Native(stream, addr, value, flags));
    }

    private static native int cuStreamWaitValue32Native(CUstream var0, CUdeviceptr var1, int var2, int var3);

    public static int cuStreamWriteValue32(CUstream stream, CUdeviceptr addr, int value, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamWriteValue32Native(stream, addr, value, flags));
    }

    private static native int cuStreamWriteValue32Native(CUstream var0, CUdeviceptr var1, int var2, int var3);

    public static int cuStreamWaitValue64(CUstream stream, CUdeviceptr addr, long value, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamWaitValue64Native(stream, addr, value, flags));
    }

    private static native int cuStreamWaitValue64Native(CUstream var0, CUdeviceptr var1, long var2, int var4);

    public static int cuStreamWriteValue64(CUstream stream, CUdeviceptr addr, long value, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamWriteValue64Native(stream, addr, value, flags));
    }

    private static native int cuStreamWriteValue64Native(CUstream var0, CUdeviceptr var1, long var2, int var4);

    public static int cuStreamBatchMemOp(CUstream stream, int count, CUstreamBatchMemOpParams[] paramArray, int flags) {
        throw new UnsupportedOperationException("The cuStreamBatchMemOp function is not yet supported in JCuda");
    }

    public static int cuPointerGetAttribute(Pointer data, int attribute, CUdeviceptr ptr) {
        return JCudaDriver.checkResult(JCudaDriver.cuPointerGetAttributeNative(data, attribute, ptr));
    }

    private static native int cuPointerGetAttributeNative(Pointer var0, int var1, CUdeviceptr var2);

    public static int cuMemPrefetchAsync(CUdeviceptr devPtr, long count, CUdevice dstDevice, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemPrefetchAsyncNative(devPtr, count, dstDevice, hStream));
    }

    private static native int cuMemPrefetchAsyncNative(CUdeviceptr var0, long var1, CUdevice var3, CUstream var4);

    public static int cuMemAdvise(CUdeviceptr devPtr, long count, int advice, CUdevice device) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemAdviseNative(devPtr, count, advice, device));
    }

    private static native int cuMemAdviseNative(CUdeviceptr var0, long var1, int var3, CUdevice var4);

    public static int cuMemRangeGetAttribute(Pointer data, long dataSize, int attribute, CUdeviceptr devPtr, long count) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemRangeGetAttributeNative(data, dataSize, attribute, devPtr, count));
    }

    private static native int cuMemRangeGetAttributeNative(Pointer var0, long var1, int var3, CUdeviceptr var4, long var5);

    public static int cuMemRangeGetAttributes(Pointer[] data, long[] dataSizes, int[] attributes, long numAttributes, CUdeviceptr devPtr, long count) {
        return JCudaDriver.checkResult(JCudaDriver.cuMemRangeGetAttributesNative(data, dataSizes, attributes, numAttributes, devPtr, count));
    }

    private static native int cuMemRangeGetAttributesNative(Pointer[] var0, long[] var1, int[] var2, long var3, CUdeviceptr var5, long var6);

    public static int cuPointerSetAttribute(Pointer value, int attribute, CUdeviceptr ptr) {
        return JCudaDriver.checkResult(JCudaDriver.cuPointerSetAttributeNative(value, attribute, ptr));
    }

    private static native int cuPointerSetAttributeNative(Pointer var0, int var1, CUdeviceptr var2);

    public static int cuPointerGetAttributes(int numAttributes, int[] attributes, Pointer data, CUdeviceptr ptr) {
        return JCudaDriver.checkResult(JCudaDriver.cuPointerGetAttributesNative(numAttributes, attributes, data, ptr));
    }

    private static native int cuPointerGetAttributesNative(int var0, int[] var1, Pointer var2, CUdeviceptr var3);

    public static int cuStreamCreate(CUstream phStream, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamCreateNative(phStream, Flags));
    }

    private static native int cuStreamCreateNative(CUstream var0, int var1);

    public static int cuStreamCreateWithPriority(CUstream phStream, int flags, int priority) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamCreateWithPriorityNative(phStream, flags, priority));
    }

    private static native int cuStreamCreateWithPriorityNative(CUstream var0, int var1, int var2);

    public static int cuStreamGetPriority(CUstream hStream, int[] priority) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamGetPriorityNative(hStream, priority));
    }

    private static native int cuStreamGetPriorityNative(CUstream var0, int[] var1);

    public static int cuStreamGetFlags(CUstream hStream, int[] flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamGetFlagsNative(hStream, flags));
    }

    private static native int cuStreamGetFlagsNative(CUstream var0, int[] var1);

    public static int cuStreamGetId(CUstream hStream, long[] streamId) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamGetIdNative(hStream, streamId));
    }

    private static native int cuStreamGetIdNative(CUstream var0, long[] var1);

    public static int cuStreamGetCtx(CUstream hStream, CUcontext pctx) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamGetCtxNative(hStream, pctx));
    }

    private static native int cuStreamGetCtxNative(CUstream var0, CUcontext var1);

    public static int cuStreamWaitEvent(CUstream hStream, CUevent hEvent, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamWaitEventNative(hStream, hEvent, Flags));
    }

    private static native int cuStreamWaitEventNative(CUstream var0, CUevent var1, int var2);

    public static int cuStreamAddCallback(CUstream hStream, CUstreamCallback callback, Object userData, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamAddCallbackNative(hStream, callback, userData, flags));
    }

    private static native int cuStreamAddCallbackNative(CUstream var0, CUstreamCallback var1, Object var2, int var3);

    public static int cuStreamBeginCapture(CUstream hStream, int mode) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamBeginCaptureNative(hStream, mode));
    }

    private static native int cuStreamBeginCaptureNative(CUstream var0, int var1);

    public static int cuThreadExchangeStreamCaptureMode(int[] mode) {
        return JCudaDriver.checkResult(JCudaDriver.cuThreadExchangeStreamCaptureModeNative(mode));
    }

    private static native int cuThreadExchangeStreamCaptureModeNative(int[] var0);

    public static int cuStreamEndCapture(CUstream hStream, CUgraph phGraph) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamEndCaptureNative(hStream, phGraph));
    }

    private static native int cuStreamEndCaptureNative(CUstream var0, CUgraph var1);

    public static int cuStreamIsCapturing(CUstream hStream, int[] captureStatus) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamIsCapturingNative(hStream, captureStatus));
    }

    private static native int cuStreamIsCapturingNative(CUstream var0, int[] var1);

    public static int cuStreamGetCaptureInfo(CUstream hStream, int[] captureStatus, long[] id) {
        throw new UnsupportedOperationException("This function no longer exists in CUDA 12");
    }

    public static int cuStreamAttachMemAsync(CUstream hStream, CUdeviceptr dptr, long length, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamAttachMemAsyncNative(hStream, dptr, length, flags));
    }

    private static native int cuStreamAttachMemAsyncNative(CUstream var0, CUdeviceptr var1, long var2, int var4);

    public static int cuStreamQuery(CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamQueryNative(hStream));
    }

    private static native int cuStreamQueryNative(CUstream var0);

    public static int cuStreamSynchronize(CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamSynchronizeNative(hStream));
    }

    private static native int cuStreamSynchronizeNative(CUstream var0);

    public static int cuStreamDestroy(CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamDestroyNative(hStream));
    }

    private static native int cuStreamDestroyNative(CUstream var0);

    public static int cuStreamCopyAttributes(CUstream dst, CUstream src) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamCopyAttributesNative(dst, src));
    }

    private static native int cuStreamCopyAttributesNative(CUstream var0, CUstream var1);

    public static int cuStreamGetAttribute(CUstream hStream, int attr, CUstreamAttrValue value_out) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamGetAttributeNative(hStream, attr, value_out));
    }

    private static native int cuStreamGetAttributeNative(CUstream var0, int var1, CUstreamAttrValue var2);

    public static int cuStreamSetAttribute(CUstream hStream, int attr, CUstreamAttrValue value) {
        return JCudaDriver.checkResult(JCudaDriver.cuStreamSetAttributeNative(hStream, attr, value));
    }

    private static native int cuStreamSetAttributeNative(CUstream var0, int var1, CUstreamAttrValue var2);

    @Deprecated
    public static int cuGLInit() {
        return JCudaDriver.checkResult(JCudaDriver.cuGLInitNative());
    }

    private static native int cuGLInitNative();

    @Deprecated
    public static int cuGLCtxCreate(CUcontext pCtx, int Flags, CUdevice device) {
        return JCudaDriver.checkResult(JCudaDriver.cuGLCtxCreateNative(pCtx, Flags, device));
    }

    private static native int cuGLCtxCreateNative(CUcontext var0, int var1, CUdevice var2);

    public static int cuGLGetDevices(int[] pCudaDeviceCount, CUdevice[] pCudaDevices, int cudaDeviceCount, int CUGLDeviceList_deviceList) {
        return JCudaDriver.checkResult(JCudaDriver.cuGLGetDevicesNative(pCudaDeviceCount, pCudaDevices, cudaDeviceCount, CUGLDeviceList_deviceList));
    }

    private static native int cuGLGetDevicesNative(int[] var0, CUdevice[] var1, int var2, int var3);

    public static int cuGraphicsGLRegisterBuffer(CUgraphicsResource pCudaResource, int buffer, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsGLRegisterBufferNative(pCudaResource, buffer, Flags));
    }

    private static native int cuGraphicsGLRegisterBufferNative(CUgraphicsResource var0, int var1, int var2);

    public static int cuGraphicsGLRegisterImage(CUgraphicsResource pCudaResource, int image, int target, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsGLRegisterImageNative(pCudaResource, image, target, Flags));
    }

    private static native int cuGraphicsGLRegisterImageNative(CUgraphicsResource var0, int var1, int var2, int var3);

    @Deprecated
    public static int cuGLRegisterBufferObject(int bufferobj) {
        throw new UnsupportedOperationException("This function is deprecated as of CUDA 3.0");
    }

    @Deprecated
    public static int cuGLMapBufferObject(CUdeviceptr dptr, long[] size, int bufferobj) {
        return JCudaDriver.checkResult(JCudaDriver.cuGLMapBufferObjectNative(dptr, size, bufferobj));
    }

    private static native int cuGLMapBufferObjectNative(CUdeviceptr var0, long[] var1, int var2);

    @Deprecated
    public static int cuGLUnmapBufferObject(int bufferobj) {
        return JCudaDriver.checkResult(JCudaDriver.cuGLUnmapBufferObjectNative(bufferobj));
    }

    private static native int cuGLUnmapBufferObjectNative(int var0);

    @Deprecated
    public static int cuGLUnregisterBufferObject(int bufferobj) {
        return JCudaDriver.checkResult(JCudaDriver.cuGLUnregisterBufferObjectNative(bufferobj));
    }

    private static native int cuGLUnregisterBufferObjectNative(int var0);

    @Deprecated
    public static int cuGLSetBufferObjectMapFlags(int buffer, int Flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuGLSetBufferObjectMapFlagsNative(buffer, Flags));
    }

    private static native int cuGLSetBufferObjectMapFlagsNative(int var0, int var1);

    @Deprecated
    public static int cuGLMapBufferObjectAsync(CUdeviceptr dptr, long[] size, int buffer, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuGLMapBufferObjectAsyncNative(dptr, size, buffer, hStream));
    }

    private static native int cuGLMapBufferObjectAsyncNative(CUdeviceptr var0, long[] var1, int var2, CUstream var3);

    @Deprecated
    public static int cuGLUnmapBufferObjectAsync(int buffer, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuGLUnmapBufferObjectAsyncNative(buffer, hStream));
    }

    private static native int cuGLUnmapBufferObjectAsyncNative(int var0, CUstream var1);

    public static int cuGraphicsUnregisterResource(CUgraphicsResource resource) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsUnregisterResourceNative(resource));
    }

    private static native int cuGraphicsUnregisterResourceNative(CUgraphicsResource var0);

    public static int cuGraphicsSubResourceGetMappedArray(CUarray pArray, CUgraphicsResource resource, int arrayIndex, int mipLevel) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsSubResourceGetMappedArrayNative(pArray, resource, arrayIndex, mipLevel));
    }

    private static native int cuGraphicsSubResourceGetMappedArrayNative(CUarray var0, CUgraphicsResource var1, int var2, int var3);

    public static int cuGraphicsResourceGetMappedMipmappedArray(CUmipmappedArray pMipmappedArray, CUgraphicsResource resource) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsResourceGetMappedMipmappedArrayNative(pMipmappedArray, resource));
    }

    private static native int cuGraphicsResourceGetMappedMipmappedArrayNative(CUmipmappedArray var0, CUgraphicsResource var1);

    public static int cuGraphicsResourceGetMappedPointer(CUdeviceptr pDevPtr, long[] pSize, CUgraphicsResource resource) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsResourceGetMappedPointerNative(pDevPtr, pSize, resource));
    }

    private static native int cuGraphicsResourceGetMappedPointerNative(CUdeviceptr var0, long[] var1, CUgraphicsResource var2);

    public static int cuGraphicsResourceSetMapFlags(CUgraphicsResource resource, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsResourceSetMapFlagsNative(resource, flags));
    }

    private static native int cuGraphicsResourceSetMapFlagsNative(CUgraphicsResource var0, int var1);

    public static int cuGraphicsMapResources(int count, CUgraphicsResource[] resources, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsMapResourcesNative(count, resources, hStream));
    }

    private static native int cuGraphicsMapResourcesNative(int var0, CUgraphicsResource[] var1, CUstream var2);

    public static int cuGraphicsUnmapResources(int count, CUgraphicsResource[] resources, CUstream hStream) {
        return JCudaDriver.checkResult(JCudaDriver.cuGraphicsUnmapResourcesNative(count, resources, hStream));
    }

    private static native int cuGraphicsUnmapResourcesNative(int var0, CUgraphicsResource[] var1, CUstream var2);

    public static int cuFuncGetModule(CUmodule hmod, CUfunction hfunc) {
        return JCudaDriver.checkResult(JCudaDriver.cuFuncGetModuleNative(hmod, hfunc));
    }

    private static native int cuFuncGetModuleNative(CUmodule var0, CUfunction var1);

    public static int cuCtxSetLimit(int limit, long value) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxSetLimitNative(limit, value));
    }

    private static native int cuCtxSetLimitNative(int var0, long var1);

    public static int cuCtxGetCacheConfig(int[] pconfig) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetCacheConfigNative(pconfig));
    }

    private static native int cuCtxGetCacheConfigNative(int[] var0);

    public static int cuCtxSetCacheConfig(int config) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxSetCacheConfigNative(config));
    }

    private static native int cuCtxSetCacheConfigNative(int var0);

    public static int cuCtxGetSharedMemConfig(int[] pConfig) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetSharedMemConfigNative(pConfig));
    }

    private static native int cuCtxGetSharedMemConfigNative(int[] var0);

    public static int cuCtxSetSharedMemConfig(int config) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxSetSharedMemConfigNative(config));
    }

    private static native int cuCtxSetSharedMemConfigNative(int var0);

    public static int cuCtxGetApiVersion(CUcontext ctx, int[] version) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetApiVersionNative(ctx, version));
    }

    private static native int cuCtxGetApiVersionNative(CUcontext var0, int[] var1);

    public static int cuCtxGetStreamPriorityRange(int[] leastPriority, int[] greatestPriority) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetStreamPriorityRangeNative(leastPriority, greatestPriority));
    }

    private static native int cuCtxGetStreamPriorityRangeNative(int[] var0, int[] var1);

    public static int cuCtxResetPersistingL2Cache() {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxResetPersistingL2CacheNative());
    }

    private static native int cuCtxResetPersistingL2CacheNative();

    public static int cuLaunchKernel(CUfunction f, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, CUstream hStream, Pointer kernelParams, Pointer extra) {
        return JCudaDriver.checkResult(JCudaDriver.cuLaunchKernelNative(f, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, hStream, kernelParams, extra));
    }

    private static native int cuLaunchKernelNative(CUfunction var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, CUstream var8, Pointer var9, Pointer var10);

    public static int cuLaunchCooperativeKernel(CUfunction f, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, CUstream hStream, Pointer kernelParams) {
        return JCudaDriver.checkResult(JCudaDriver.cuLaunchCooperativeKernelNative(f, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, hStream, kernelParams));
    }

    private static native int cuLaunchCooperativeKernelNative(CUfunction var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, CUstream var8, Pointer var9);

    public static int cuLaunchCooperativeKernelMultiDevice(CUDA_LAUNCH_PARAMS[] launchParamsList, int numDevices, int flags) {
        return JCudaDriver.checkResult(JCudaDriver.cuLaunchCooperativeKernelMultiDeviceNative(launchParamsList, numDevices, flags));
    }

    private static native int cuLaunchCooperativeKernelMultiDeviceNative(CUDA_LAUNCH_PARAMS[] var0, int var1, int var2);

    public static int cuLaunchHostFunc(CUstream hStream, CUhostFn fn, Object userData) {
        return JCudaDriver.checkResult(JCudaDriver.cuLaunchHostFuncNative(hStream, fn, userData));
    }

    private static native int cuLaunchHostFuncNative(CUstream var0, CUhostFn var1, Object var2);

    public static int cuCtxGetLimit(long[] pvalue, int limit) {
        return JCudaDriver.checkResult(JCudaDriver.cuCtxGetLimitNative(pvalue, limit));
    }

    private static native int cuCtxGetLimitNative(long[] var0, int var1);

    public static int cuProfilerInitialize(String configFile, String outputFile, int outputMode) {
        return JCudaDriver.checkResult(JCudaDriver.cuProfilerInitializeNative(configFile, outputFile, outputMode));
    }

    private static native int cuProfilerInitializeNative(String var0, String var1, int var2);

    public static int cuProfilerStart() {
        return JCudaDriver.checkResult(JCudaDriver.cuProfilerStartNative());
    }

    private static native int cuProfilerStartNative();

    public static int cuProfilerStop() {
        return JCudaDriver.checkResult(JCudaDriver.cuProfilerStopNative());
    }

    private static native int cuProfilerStopNative();

    static {
        String libraryBaseName = "JCudaDriver-" + JCudaVersion.get();
        String libraryName = LibUtils.createPlatformLibraryName(libraryBaseName);
        LibUtilsCuda.loadLibrary(libraryName, new String[0]);
        OCCUPANCY_LOCK = new Object();
    }

    private static class ConstantPointer
    extends Pointer {
        private ConstantPointer(long value) {
            super(value);
        }
    }
}

