/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.common.binder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.DtpPropertiesBinderUtil;
import org.dromara.dynamictp.core.support.binder.PropertiesBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public class SpringBootPropertiesBinder
implements PropertiesBinder {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPropertiesBinder.class);

    public void bindDtpProperties(Map<?, Object> properties, DtpProperties dtpProperties) {
        this.beforeBind(properties, dtpProperties);
        try {
            Class.forName("org.springframework.boot.context.properties.bind.Binder");
            this.doBindIn2X(properties, dtpProperties);
        }
        catch (ClassNotFoundException e) {
            this.doBindIn1X(properties, dtpProperties);
        }
        this.afterBind(properties, dtpProperties);
    }

    public void bindDtpProperties(Object environment, DtpProperties dtpProperties) {
        if (!(environment instanceof Environment)) {
            throw new IllegalArgumentException("Invalid environment type, expected org.springframework.core.env.Environment");
        }
        Environment env = (Environment)environment;
        this.beforeBind(env, dtpProperties);
        try {
            Class.forName("org.springframework.boot.context.properties.bind.Binder");
            this.doBindIn2X(env, dtpProperties);
        }
        catch (ClassNotFoundException e) {
            this.doBindIn1X(env, dtpProperties);
        }
        this.afterBind(environment, dtpProperties);
    }

    public void afterBind(Object source, DtpProperties dtpProperties) {
        DtpPropertiesBinderUtil.tryResetWithGlobalConfig((Object)source, (DtpProperties)dtpProperties);
    }

    private void doBindIn2X(Map<?, Object> properties, DtpProperties dtpProperties) {
        MapConfigurationPropertySource sources = new MapConfigurationPropertySource(properties);
        Binder binder = new Binder(new ConfigurationPropertySource[]{sources});
        ResolvableType type = ResolvableType.forClass(DtpProperties.class);
        Bindable target = Bindable.of((ResolvableType)type).withExistingValue((Object)dtpProperties);
        binder.bind("dynamictp", target);
    }

    private void doBindIn2X(Environment environment, DtpProperties dtpProperties) {
        Binder binder = Binder.get((Environment)environment);
        ResolvableType type = ResolvableType.forClass(DtpProperties.class);
        Bindable target = Bindable.of((ResolvableType)type).withExistingValue((Object)dtpProperties);
        binder.bind("dynamictp", target);
    }

    private void doBindIn1X(Environment environment, DtpProperties dtpProperties) {
        try {
            Class<?> resolverClass = Class.forName("org.springframework.boot.bind.RelaxedPropertyResolver");
            Constructor<?> resolverConstructor = resolverClass.getDeclaredConstructor(PropertyResolver.class);
            Object resolver = resolverConstructor.newInstance(environment);
            Method getSubPropertiesMethod = resolverClass.getDeclaredMethod("getSubProperties", String.class);
            Map properties = (Map)getSubPropertiesMethod.invoke(resolver, "");
            this.doBindIn1X(properties, dtpProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doBindIn1X(Map<?, ?> properties, DtpProperties dtpProperties) {
        try {
            Class<?> binderClass = Class.forName("org.springframework.boot.bind.RelaxedDataBinder");
            Constructor<?> binderConstructor = binderClass.getDeclaredConstructor(Object.class, String.class);
            Object binder = binderConstructor.newInstance(dtpProperties, "dynamictp");
            Method bindMethod = binderClass.getMethod("bind", PropertyValues.class);
            bindMethod.invoke(binder, new MutablePropertyValues(properties));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

