/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.apollo.refresher;

import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigFileChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.model.ConfigFileChangeEvent;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.dromara.dynamictp.common.em.ConfigFileTypeEnum;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.core.handler.ConfigHandler;
import org.dromara.dynamictp.spring.AbstractSpringRefresher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ApolloRefresher
extends AbstractSpringRefresher
implements ConfigFileChangeListener,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ApolloRefresher.class);
    private static final Splitter NAMESPACE_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();

    public ApolloRefresher(DtpProperties dtpProperties) {
        super(dtpProperties);
    }

    public void onChange(ConfigFileChangeEvent changeEvent) {
        String namespace = changeEvent.getNamespace();
        String newValue = changeEvent.getNewValue();
        ConfigFileTypeEnum configFileType = this.deduceConfigFileType(namespace);
        this.refresh(newValue, configFileType);
    }

    public void afterPropertiesSet() {
        String namespaces = this.environment.getProperty("apollo.bootstrap.namespaces", "application");
        log.debug("Apollo bootstrap namespaces: {}", (Object)namespaces);
        List namespaceList = NAMESPACE_SPLITTER.splitToList((CharSequence)namespaces);
        for (String namespace : namespaceList) {
            ConfigFileFormat format;
            String actualNamespaceName = this.trimNamespaceFormat(namespace, format = this.determineFileFormat(namespace));
            ConfigFile configFile = ConfigService.getConfigFile((String)actualNamespaceName, (ConfigFileFormat)format);
            if (!this.isDtpNamespace(configFile.getContent(), ConfigFileTypeEnum.of((String)format.getValue()))) continue;
            try {
                configFile.addChangeListener((ConfigFileChangeListener)this);
                log.info("DynamicTp refresher, add listener success, namespace: {}", (Object)actualNamespaceName);
            }
            catch (Exception e) {
                log.error("DynamicTp refresher, add listener error, namespace: {}", (Object)actualNamespaceName, (Object)e);
            }
        }
    }

    private ConfigFileFormat determineFileFormat(String namespaceName) {
        String lowerCase = namespaceName.toLowerCase();
        for (ConfigFileFormat format : ConfigFileFormat.values()) {
            if (!lowerCase.endsWith("." + format.getValue())) continue;
            return format;
        }
        return ConfigFileFormat.Properties;
    }

    private String trimNamespaceFormat(String namespaceName, ConfigFileFormat format) {
        String extension = "." + format.getValue();
        if (!namespaceName.toLowerCase().endsWith(extension)) {
            return namespaceName;
        }
        return namespaceName.substring(0, namespaceName.length() - extension.length());
    }

    private ConfigFileTypeEnum deduceConfigFileType(String namespace) {
        ConfigFileFormat configFileFormat = this.determineFileFormat(namespace);
        return ConfigFileTypeEnum.of((String)configFileFormat.getValue());
    }

    private boolean isDtpNamespace(String content, ConfigFileTypeEnum configFileType) {
        ConfigHandler configHandler = ConfigHandler.getInstance();
        try {
            Map properties = configHandler.parseConfig(content, configFileType);
            return properties.keySet().stream().anyMatch(key -> key.toString().startsWith("dynamictp"));
        }
        catch (IOException e) {
            return false;
        }
    }
}

