/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.apollo.autoconfigure;

import com.ctrip.framework.apollo.ConfigService;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.spring.DtpBaseBeanConfiguration;
import org.dromara.dynamictp.starter.apollo.refresher.ApolloRefresher;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ConfigService.class})
@ConditionalOnProperty(value={"apollo.bootstrap.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={DtpBaseBeanConfiguration.class})
@AutoConfigureAfter(value={DtpBaseBeanConfiguration.class})
public class DtpApolloAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ApolloRefresher apolloRefresher(DtpProperties dtpProperties) {
        return new ApolloRefresher(dtpProperties);
    }
}

